/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.vip.saturn.job.console.SaturnEnvProperties;
import com.vip.saturn.job.console.domain.NamespaceDomainInfo;
import com.vip.saturn.job.console.domain.RegistryCenterClient;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.exception.SaturnJobConsoleHttpException;
import com.vip.saturn.job.console.mybatis.entity.NamespaceInfo;
import com.vip.saturn.job.console.mybatis.entity.NamespaceZkClusterMapping;
import com.vip.saturn.job.console.mybatis.entity.SystemConfig;
import com.vip.saturn.job.console.mybatis.entity.ZkClusterInfo;
import com.vip.saturn.job.console.mybatis.service.NamespaceInfoService;
import com.vip.saturn.job.console.mybatis.service.NamespaceZkClusterMapping4SqlService;
import com.vip.saturn.job.console.mybatis.service.ZkClusterInfoService;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.service.SystemConfigService;
import com.vip.saturn.job.console.service.cache.DashboardLeaderHandler;
import com.vip.saturn.job.console.service.helper.ZkClusterMappingUtils;
import com.vip.saturn.job.console.utils.ConsoleThreadFactory;
import com.vip.saturn.job.console.utils.ExecutorNodePath;
import com.vip.saturn.job.console.utils.JobNodePath;
import com.vip.saturn.job.console.utils.LocalHostService;
import com.vip.saturn.job.console.utils.SaturnConsoleUtils;
import com.vip.saturn.job.integrate.service.ReportAlarmService;
import com.vip.saturn.job.integrate.service.UpdateJobConfigService;
import com.vip.saturn.job.sharding.NamespaceShardingManager;
import com.vip.saturn.job.sharding.listener.AbstractConnectionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class RegistryCenterServiceImpl
implements RegistryCenterService {
    protected static final String DEFAULT_CONSOLE_CLUSTER_ID = "default";
    protected static final String NAMESPACE_CREATOR_NAME = "REST_API";
    protected static final String ERR_MSG_TEMPLATE_FAIL_TO_CREATE = "Fail to create new namespace {%s} for reason {%s}";
    protected static final String ERR_MSG_NS_NOT_FOUND = "The namespace does not exists.";
    protected static final String ERR_MSG_NS_ALREADY_EXIST = "Invalid request. Namespace: {%s} already existed";
    private static final Logger log = LoggerFactory.getLogger(RegistryCenterServiceImpl.class);
    @Resource
    private CuratorRepository curatorRepository;
    @Resource
    private ReportAlarmService reportAlarmService;
    @Resource
    private UpdateJobConfigService updateJobConfigService;
    @Resource
    private ZkClusterInfoService zkClusterInfoService;
    @Resource
    private SystemConfigService systemConfigService;
    @Resource
    private NamespaceZkClusterMapping4SqlService namespaceZkClusterMapping4SqlService;
    @Resource
    private NamespaceInfoService namespaceInfoService;
    private LinkedHashMap<String, ZkCluster> zkClusterMap = new LinkedHashMap();
    private ConcurrentHashMap<String, DashboardLeaderHandler> dashboardLeaderTreeCacheMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, RegistryCenterClient> registryCenterClientMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object> nnsLock = new ConcurrentHashMap();
    private ConcurrentHashMap<String, NamespaceShardingManager> namespaceShardingListenerManagerMap = new ConcurrentHashMap();
    private List<String> allOnlineNamespaces = new ArrayList<String>();
    private String consoleClusterId;
    private Set<String> restrictComputeZkClusterKeys = Sets.newHashSet();
    private Timer localRefreshTimer = null;
    private Timer localRefreshIfNecessaryTimer = null;
    private ExecutorService localRefreshThreadPool = null;

    @Override
    @PostConstruct
    public void init() {
        this.getConsoleClusterId();
        this.localRefresh();
        this.initLocalRefreshThreadPool();
        this.startLocalRefreshTimer();
        this.startLocalRefreshIfNecessaryTimer();
    }

    private void getConsoleClusterId() {
        if (StringUtils.isBlank((CharSequence)SaturnEnvProperties.VIP_SATURN_CONSOLE_CLUSTER_ID)) {
            log.info("No environment variable or system property of [VIP_SATURN_CONSOLE_CLUSTER] is set. Use the default Id");
            this.consoleClusterId = DEFAULT_CONSOLE_CLUSTER_ID;
        } else {
            this.consoleClusterId = SaturnEnvProperties.VIP_SATURN_CONSOLE_CLUSTER_ID;
        }
    }

    @PreDestroy
    public void destroy() {
        Iterator<Map.Entry<String, ZkCluster>> iterator = this.zkClusterMap.entrySet().iterator();
        while (iterator.hasNext()) {
            this.closeZkCluster(iterator.next().getValue());
        }
        if (this.localRefreshTimer != null) {
            this.localRefreshTimer.cancel();
        }
        if (this.localRefreshIfNecessaryTimer != null) {
            this.localRefreshIfNecessaryTimer.cancel();
        }
        if (this.localRefreshThreadPool != null) {
            this.localRefreshThreadPool.shutdownNow();
        }
    }

    private void initLocalRefreshThreadPool() {
        this.localRefreshThreadPool = Executors.newSingleThreadExecutor(new ConsoleThreadFactory("refresh-RegCenter-thread", false));
    }

    private void startLocalRefreshTimer() {
        this.localRefreshTimer = new Timer("refresh-RegCenter-timer", true);
        this.localRefreshTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    RegistryCenterServiceImpl.this.localRefreshThreadPool.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RegistryCenterServiceImpl.this.localRefresh();
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }, 300000L, 300000L);
    }

    private void startLocalRefreshIfNecessaryTimer() {
        this.localRefreshIfNecessaryTimer = new Timer("refresh-RegCenter-if-necessary-timer", true);
        this.localRefreshIfNecessaryTimer.schedule(new TimerTask(){
            private String lastUuid = null;

            @Override
            public void run() {
                try {
                    String uuid = RegistryCenterServiceImpl.this.systemConfigService.getValueDirectly("REFRESH_REGISTRY_CENTER_UUID");
                    if (StringUtils.isBlank((CharSequence)uuid)) {
                        RegistryCenterServiceImpl.this.notifyRefreshRegCenter();
                    } else if (!uuid.equals(this.lastUuid)) {
                        this.lastUuid = uuid;
                        RegistryCenterServiceImpl.this.localRefreshThreadPool.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RegistryCenterServiceImpl.this.localRefresh();
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }, 1000L, 1000L);
    }

    private synchronized void localRefresh() {
        try {
            log.info("Start refresh RegCenter");
            long startTime = System.currentTimeMillis();
            this.refreshRestrictComputeZkClusters();
            if (this.restrictComputeZkClusterKeys.isEmpty()) {
                log.warn("\u6839\u636eConsole\u7684\u96c6\u7fa4ID:" + this.consoleClusterId + ",\u627e\u4e0d\u5230\u914d\u7f6e\u53ef\u4ee5\u53c2\u4e0eSharding\u548cDashboard\u8ba1\u7b97\u7684zk\u96c6\u7fa4");
                return;
            }
            this.refreshRegistryCenter();
            this.refreshDashboardLeaderTreeCache();
            this.refreshNamespaceShardingListenerManagerMap();
            log.info("End refresh RegCenter, cost {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            log.error("refresh RegCenter error", (Throwable)e);
        }
    }

    private void refreshRestrictComputeZkClusters() throws SaturnJobConsoleException {
        String[] singleConsoleMappingArray;
        this.restrictComputeZkClusterKeys.clear();
        String allMappingStr = this.systemConfigService.getValueDirectly("CONSOLE_ZK_CLUSTER_MAPPING");
        if (StringUtils.isBlank((CharSequence)allMappingStr)) {
            log.info("CONSOLE_ZK_CLUSTER_MAPPING is not configured in sys_config, so all zk clusters can be computed by this console");
            this.restrictComputeZkClusterKeys.addAll(this.getZkClusterKeys());
            return;
        }
        allMappingStr = StringUtils.deleteWhitespace((String)allMappingStr);
        for (String singleConsoleMappingStr : singleConsoleMappingArray = allMappingStr.split(";")) {
            Object[] consoleAndClusterKeyArray = singleConsoleMappingStr.split(":");
            if (consoleAndClusterKeyArray.length != 2) {
                throw new SaturnJobConsoleException("the CONSOLE_ZK_CLUSTER_MAPPING(" + Arrays.toString(consoleAndClusterKeyArray) + ") format is not correct, should be like console_cluster_id:zk_cluster_id");
            }
            String tempConsoleClusterId = consoleAndClusterKeyArray[0];
            String zkClusterKeyStr = consoleAndClusterKeyArray[1];
            if (!this.consoleClusterId.equals(tempConsoleClusterId)) continue;
            String[] zkClusterKeyArray = zkClusterKeyStr.trim().split(",");
            this.restrictComputeZkClusterKeys.addAll(Arrays.asList(zkClusterKeyArray));
            log.info("the current console cluster:{} can do sharding and dashboard to zk clusters:{}", (Object)this.consoleClusterId, this.restrictComputeZkClusterKeys);
            return;
        }
    }

    private boolean isZKClusterCanBeComputed(String clusterKey) {
        if (CollectionUtils.isEmpty(this.restrictComputeZkClusterKeys)) {
            return false;
        }
        return this.restrictComputeZkClusterKeys.contains(clusterKey);
    }

    private boolean isCurrentConsoleInTheSameIdc(String clusterKey) {
        return ZkClusterMappingUtils.isCurrentConsoleInTheSameIdc(this.systemConfigService, clusterKey);
    }

    private String generateShardingLeadershipHostValue() {
        return LocalHostService.cachedIpAddress + "-" + UUID.randomUUID().toString();
    }

    private void refreshNamespaceShardingListenerManagerMap() {
        for (Map.Entry<String, ZkCluster> next : this.zkClusterMap.entrySet()) {
            ZkCluster zkCluster = next.getValue();
            ArrayList<RegistryCenterConfiguration> regCenterConfList = zkCluster.getRegCenterConfList();
            if (regCenterConfList == null) continue;
            for (RegistryCenterConfiguration conf : regCenterConfList) {
                String nns = conf.getNameAndNamespace();
                if (!this.namespaceShardingListenerManagerMap.containsKey(nns)) {
                    if (!this.isZKClusterCanBeComputed(conf.getZkClusterKey())) continue;
                    this.createNamespaceShardingManager(conf, nns);
                    continue;
                }
                NamespaceShardingManager namespaceShardingManager = this.namespaceShardingListenerManagerMap.get(nns);
                if (this.isZKClusterCanBeComputed(conf.getZkClusterKey())) continue;
                namespaceShardingManager.stopWithCurator();
                this.namespaceShardingListenerManagerMap.remove(nns);
            }
        }
    }

    private void createNamespaceShardingManager(RegistryCenterConfiguration conf, String nns) {
        block11: {
            try {
                log.info("Start NamespaceShardingManager {}", (Object)nns);
                String namespace = conf.getNamespace();
                String digest = conf.getDigest();
                CuratorFramework client = this.curatorRepository.connect(conf.getZkAddressList(), namespace, digest);
                if (client == null) {
                    log.warn("fail to connect to zk during create NamespaceShardingManager");
                    return;
                }
                NamespaceShardingManager namespaceShardingManager = null;
                try {
                    namespaceShardingManager = new NamespaceShardingManager(client, namespace, this.generateShardingLeadershipHostValue(), this.reportAlarmService, this.updateJobConfigService);
                    namespaceShardingManager.start();
                    if (this.namespaceShardingListenerManagerMap.putIfAbsent(nns, namespaceShardingManager) != null) {
                        try {
                            namespaceShardingManager.stopWithCurator();
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        break block11;
                    }
                    log.info("Done starting NamespaceShardingManager {}", (Object)nns);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    if (namespaceShardingManager != null) {
                        try {
                            namespaceShardingManager.stop();
                        }
                        catch (Exception e2) {
                            log.error(e2.getMessage(), (Throwable)e2);
                        }
                    }
                    client.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void refreshRegistryCenter() {
        ArrayList<String> allOnlineNamespacesTemp = new ArrayList<String>();
        Map<String, ZkCluster> newClusterMap = this.getZkClusterInfo();
        this.closeInvalidZkClient(newClusterMap);
        this.connectToZkClusterIfPossible(newClusterMap);
        for (Map.Entry<String, ZkCluster> zkClusterEntry : newClusterMap.entrySet()) {
            ZkCluster zkCluster = zkClusterEntry.getValue();
            String key = zkClusterEntry.getKey();
            List<NamespaceZkClusterMapping> nsZkClusterMappingList = this.namespaceZkClusterMapping4SqlService.getAllMappingsOfCluster(key);
            ArrayList<RegistryCenterConfiguration> regCenterConfList = zkCluster.getRegCenterConfList();
            this.closeMoveOutNamespace(key, nsZkClusterMappingList, regCenterConfList);
            this.initOrUpdateNamespace(allOnlineNamespacesTemp, zkCluster, nsZkClusterMappingList, regCenterConfList);
        }
        this.zkClusterMap = (LinkedHashMap)newClusterMap;
        this.allOnlineNamespaces = allOnlineNamespacesTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOrUpdateNamespace(List<String> allOnlineNamespacesTemp, ZkCluster zkCluster, List<NamespaceZkClusterMapping> nsZkClusterMappingList, List<RegistryCenterConfiguration> regCenterConfList) {
        int oldSize;
        String namespace;
        if (nsZkClusterMappingList == null || zkCluster.isOffline()) {
            return;
        }
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = zkCluster.getCuratorFrameworkOp();
        ArrayList<RegistryCenterConfiguration> newRegCenterConfList = new ArrayList<RegistryCenterConfiguration>();
        try {
            for (NamespaceZkClusterMapping mapping : nsZkClusterMappingList) {
                namespace = mapping.getNamespace();
                if ("$SaturnSelf".equals(namespace)) continue;
                boolean isNamespaceNotIncludeInOriginRegCenerConfList = false;
                if (this.isNamespaceNotIncludeInRegCenterConfList(namespace, regCenterConfList)) {
                    this.initNamespaceZkNodeIfNecessary(namespace, curatorFrameworkOp);
                    isNamespaceNotIncludeInOriginRegCenerConfList = true;
                }
                try {
                    if (!isNamespaceNotIncludeInOriginRegCenerConfList && !this.isNewerVersionSaturnNamespace(namespace, curatorFrameworkOp)) continue;
                    NamespaceInfo namespaceInfo = this.getNamespaceInfo(namespace);
                    if (namespaceInfo == null && !this.isNamespaceInfoNotFoundCanBeCalculate()) {
                        log.warn("No info about namespace {}, just skip it.", (Object)namespace);
                        continue;
                    }
                    RegistryCenterConfiguration conf = new RegistryCenterConfiguration(mapping.getName(), namespace, zkCluster.getZkAddr());
                    conf.setZkClusterKey(zkCluster.getZkClusterKey());
                    conf.setVersion(this.getVersion(namespace, curatorFrameworkOp));
                    conf.setZkAlias(zkCluster.getZkAlias());
                    if (namespaceInfo != null) {
                        this.postConstructRegistryCenterConfiguration(conf, namespaceInfo.getContent());
                    }
                    newRegCenterConfList.add(conf);
                    if (allOnlineNamespacesTemp.contains(namespace)) continue;
                    allOnlineNamespacesTemp.add(namespace);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (regCenterConfList != null) {
            block8: for (RegistryCenterConfiguration conf : regCenterConfList) {
                namespace = conf.getNamespace();
                String nns = conf.getNameAndNamespace();
                for (RegistryCenterConfiguration confNew : newRegCenterConfList) {
                    String namespaceNew = confNew.getNamespace();
                    if (!namespace.equals(namespaceNew)) continue;
                    String nnsNew = confNew.getNameAndNamespace();
                    if (nns.equals(nnsNew)) continue block8;
                    Object object = this.getNnsLock(nns);
                    synchronized (object) {
                        this.closeNamespace(nns);
                        log.info("closed the namespace info because it's nns is changed, namespace is {}", (Object)namespace);
                        continue block8;
                    }
                }
            }
        }
        int n = oldSize = regCenterConfList != null ? regCenterConfList.size() : 0;
        if (oldSize != newRegCenterConfList.size()) {
            log.info("Zkcluster [{}] namespace size change from {} to {}", new Object[]{zkCluster.getZkClusterKey(), oldSize, newRegCenterConfList.size()});
        }
        zkCluster.setRegCenterConfList(newRegCenterConfList);
    }

    protected boolean isNamespaceInfoNotFoundCanBeCalculate() {
        return true;
    }

    private boolean isNamespaceNotIncludeInRegCenterConfList(String namespace, List<RegistryCenterConfiguration> regCenterConfList) {
        if (regCenterConfList == null || regCenterConfList.isEmpty()) {
            return true;
        }
        for (RegistryCenterConfiguration conf : regCenterConfList) {
            if (!namespace.equals(conf.getNamespace())) continue;
            return false;
        }
        return true;
    }

    private boolean isNewerVersionSaturnNamespace(String namespace, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        try {
            List<String> executors;
            String jobsPath = "/" + namespace + JobNodePath.get$JobsNodePath();
            if (curatorFrameworkOp.checkExists(jobsPath)) {
                return true;
            }
            String executorsPath = "/" + namespace + ExecutorNodePath.getExecutorNodePath();
            if (curatorFrameworkOp.checkExists(executorsPath) && (executors = curatorFrameworkOp.getChildren(executorsPath)) != null && !executors.isEmpty()) {
                for (String exe : executors) {
                    String lastBeginTimePath = executorsPath + "/" + exe + "/lastBeginTime";
                    if (!curatorFrameworkOp.checkExists(lastBeginTimePath)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected NamespaceInfo getNamespaceInfo(String namespace) {
        try {
            return this.namespaceInfoService.selectByNamespace(namespace);
        }
        catch (Exception e) {
            log.error("fail to get namespaceInfo:{} from DB", (Object)namespace);
            return null;
        }
    }

    protected void postConstructRegistryCenterConfiguration(RegistryCenterConfiguration conf, String content) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMoveOutNamespace(String zkClusterKey, List<NamespaceZkClusterMapping> nsZkClusterMappingList, List<RegistryCenterConfiguration> regCenterConfList) {
        if (regCenterConfList == null) {
            return;
        }
        Iterator<RegistryCenterConfiguration> regIter = regCenterConfList.iterator();
        while (regIter.hasNext()) {
            RegistryCenterConfiguration conf = regIter.next();
            String namespace = conf.getNamespace();
            String nns = conf.getNameAndNamespace();
            boolean include = false;
            if (nsZkClusterMappingList != null) {
                for (NamespaceZkClusterMapping mapping : nsZkClusterMappingList) {
                    if (!namespace.equals(mapping.getNamespace())) continue;
                    include = true;
                    break;
                }
            }
            if (include) continue;
            Object object = this.getNnsLock(nns);
            synchronized (object) {
                regIter.remove();
                this.closeNamespace(nns);
                log.info("closed the moved namespace info, namespace is {}, old zkClusterKey is {}", (Object)namespace, (Object)zkClusterKey);
            }
        }
    }

    private void closeInvalidZkClient(Map<String, ZkCluster> newClusterMap) {
        Iterator<Map.Entry<String, ZkCluster>> iterator = this.zkClusterMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ZkCluster> next = iterator.next();
            String zkClusterKey = next.getKey();
            ZkCluster zkCluster = next.getValue();
            if (!newClusterMap.containsKey(zkClusterKey)) {
                iterator.remove();
                this.closeZkCluster(zkCluster);
                continue;
            }
            ZkCluster newZkCluster = newClusterMap.get(zkClusterKey);
            if (zkCluster.equals(newZkCluster)) {
                newClusterMap.put(zkClusterKey, zkCluster);
                continue;
            }
            iterator.remove();
            this.closeZkCluster(zkCluster);
        }
    }

    private Map<String, ZkCluster> getZkClusterInfo() {
        LinkedHashMap<String, ZkCluster> newClusterMap = new LinkedHashMap<String, ZkCluster>();
        List<ZkClusterInfo> allZkClusterInfoList = this.zkClusterInfoService.getAllZkClusterInfo();
        if (allZkClusterInfoList != null) {
            for (ZkClusterInfo zkClusterInfo : allZkClusterInfoList) {
                ZkCluster zkCluster = new ZkCluster();
                zkCluster.setZkClusterKey(zkClusterInfo.getZkClusterKey());
                zkCluster.setZkAlias(zkClusterInfo.getAlias());
                zkCluster.setZkAddr(zkClusterInfo.getConnectString());
                newClusterMap.put(zkClusterInfo.getZkClusterKey(), zkCluster);
            }
        }
        return newClusterMap;
    }

    private void connectToZkClusterIfPossible(Map<String, ZkCluster> newClusterMap) {
        for (Map.Entry<String, ZkCluster> next : newClusterMap.entrySet()) {
            ZkCluster zkCluster = next.getValue();
            CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = zkCluster.getCuratorFrameworkOp();
            if (curatorFrameworkOp != null) continue;
            this.createNewConnect(zkCluster);
            if (zkCluster.isOffline()) continue;
            this.updateExecutorConfigToZkIfNecessary(zkCluster);
        }
    }

    private Object getNnsLock(String nns) {
        Object pre;
        Object lock = this.nnsLock.get(nns);
        if (lock == null && (pre = this.nnsLock.putIfAbsent(nns, lock = new Object())) != null) {
            lock = pre;
        }
        return lock;
    }

    private void closeNamespace(String nns) {
        try {
            RegistryCenterClient registryCenterClient = this.registryCenterClientMap.remove(nns);
            if (registryCenterClient != null) {
                registryCenterClient.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            NamespaceShardingManager namespaceShardingManager = this.namespaceShardingListenerManagerMap.remove(nns);
            if (namespaceShardingManager != null) {
                namespaceShardingManager.stopWithCurator();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void refreshDashboardLeaderTreeCache() {
        this.closeDeprecatedDashboardLeaderTreeCache();
        for (Map.Entry<String, ZkCluster> next : this.zkClusterMap.entrySet()) {
            String zkClusterKey = next.getKey();
            ZkCluster zkCluster = next.getValue();
            if (!this.needToRefreshDashboardTreeCache(zkCluster, zkClusterKey)) continue;
            DashboardLeaderHandler dashboardLeaderHandler = null;
            try {
                dashboardLeaderHandler = new DashboardLeaderHandler(zkCluster.getZkAlias(), zkCluster.getCuratorFrameworkOp().getCuratorFramework());
                dashboardLeaderHandler.start();
                this.dashboardLeaderTreeCacheMap.put(zkClusterKey, dashboardLeaderHandler);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (dashboardLeaderHandler == null) continue;
                dashboardLeaderHandler.shutdown();
            }
        }
    }

    private boolean needToRefreshDashboardTreeCache(ZkCluster zkCluster, String zkClusterKey) {
        if (zkCluster.isOffline()) {
            return false;
        }
        if (this.dashboardLeaderTreeCacheMap.containsKey(zkClusterKey)) {
            return false;
        }
        return this.isZKClusterCanBeComputed(zkClusterKey) && this.isCurrentConsoleInTheSameIdc(zkClusterKey);
    }

    private void closeDeprecatedDashboardLeaderTreeCache() {
        if (this.dashboardLeaderTreeCacheMap == null || this.dashboardLeaderTreeCacheMap.isEmpty()) {
            return;
        }
        for (String zkClusterKey : this.dashboardLeaderTreeCacheMap.keySet()) {
            if (this.isZKClusterCanBeComputed(zkClusterKey) && this.isCurrentConsoleInTheSameIdc(zkClusterKey)) continue;
            log.info("close the deprecated dashboard leader tree Cache, {}", (Object)zkClusterKey);
            DashboardLeaderHandler oldDashboardLeaderHandler = this.dashboardLeaderTreeCacheMap.remove(zkClusterKey);
            if (oldDashboardLeaderHandler == null) continue;
            oldDashboardLeaderHandler.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeZkCluster(ZkCluster zkCluster) {
        try {
            try {
                DashboardLeaderHandler dashboardLeaderHandler = this.dashboardLeaderTreeCacheMap.remove(zkCluster.getZkClusterKey());
                if (dashboardLeaderHandler != null) {
                    dashboardLeaderHandler.shutdown();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ArrayList<RegistryCenterConfiguration> regCenterConfList = zkCluster.getRegCenterConfList();
            if (regCenterConfList != null) {
                for (RegistryCenterConfiguration conf : regCenterConfList) {
                    String nns = conf.getNameAndNamespace();
                    Object object = this.getNnsLock(nns);
                    synchronized (object) {
                        this.closeNamespace(nns);
                    }
                }
            }
            if (zkCluster.getConnectionListener() != null) {
                zkCluster.getConnectionListener().shutdownNowUntilTerminated();
                zkCluster.setConnectionListener(null);
            }
            if (zkCluster.getCuratorFrameworkOp() != null && zkCluster.getCuratorFrameworkOp().getCuratorFramework() != null) {
                zkCluster.getCuratorFrameworkOp().getCuratorFramework().close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void createNewConnect(final ZkCluster zkCluster) {
        String zkAddr = zkCluster.getZkAddr();
        try {
            CuratorFramework curatorFramework = this.curatorRepository.connect(zkAddr, null, zkCluster.getDigest());
            if (curatorFramework == null) {
                log.error("found an offline zkCluster, zkAddr is {}", (Object)zkAddr);
                zkCluster.setCuratorFrameworkOp(null);
                zkCluster.setConnectionListener(null);
                zkCluster.setOffline(true);
            } else {
                AbstractConnectionListener connectionListener = new AbstractConnectionListener("zk-connectionListener-thread-for-zkCluster-" + zkCluster.getZkAlias()){

                    public void stop() {
                        zkCluster.setOffline(true);
                    }

                    public void restart() {
                        try {
                            zkCluster.setOffline(false);
                            RegistryCenterServiceImpl.this.updateExecutorConfigToZkIfNecessary(zkCluster);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                };
                zkCluster.setCuratorFrameworkOp(this.curatorRepository.newCuratorFrameworkOp(curatorFramework));
                zkCluster.setConnectionListener(connectionListener);
                zkCluster.setOffline(false);
                curatorFramework.getConnectionStateListenable().addListener((Object)connectionListener);
            }
        }
        catch (Exception e) {
            log.error("found an offline zkCluster, zkAddr is {}", (Object)zkAddr);
            log.error(e.getMessage(), (Throwable)e);
            zkCluster.setCuratorFrameworkOp(null);
            zkCluster.setConnectionListener(null);
            zkCluster.setOffline(true);
        }
    }

    private void updateExecutorConfigToZkIfNecessary(ZkCluster zkCluster) {
        try {
            CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = zkCluster.getCuratorFrameworkOp();
            String dbData = this.systemConfigService.getValueDirectly("EXECUTOR_CONFIGS");
            JSONObject jsonObject = this.parseExecutorConfigJson(dbData);
            String configStr = jsonObject.toJSONString();
            String data = curatorFrameworkOp.getData("/$SaturnSelf/saturn-executor/config");
            if (configStr.equals(data)) {
                return;
            }
            curatorFrameworkOp.update("/$SaturnSelf/saturn-executor/config", configStr);
        }
        catch (Exception e) {
            log.error(String.format("update %s executor config error", zkCluster.getZkClusterKey()), (Throwable)e);
        }
    }

    private JSONObject parseExecutorConfigJson(String jsonStr) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return new JSONObject();
        }
        try {
            return JSON.parseObject((String)jsonStr.trim());
        }
        catch (Throwable t) {
            log.error("Fail to parse data from json string" + jsonStr, t);
            return new JSONObject();
        }
    }

    protected void initNamespaceZkNodeIfNecessary(String namespace, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        try {
            String jobsNodePath;
            String executorsNodePath = "/" + namespace + ExecutorNodePath.get$ExecutorNodePath();
            if (!curatorFrameworkOp.checkExists(executorsNodePath)) {
                curatorFrameworkOp.create(executorsNodePath);
            }
            if (!curatorFrameworkOp.checkExists(jobsNodePath = "/" + namespace + JobNodePath.get$JobsNodePath())) {
                curatorFrameworkOp.create(jobsNodePath);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getVersion(String namespace, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        try {
            ArrayList<String> versionList = new ArrayList<String>();
            String executorsPath = "/" + namespace + ExecutorNodePath.getExecutorNodePath();
            if (!curatorFrameworkOp.checkExists(executorsPath)) {
                return this.getVersionStrFromList(versionList);
            }
            List<String> executors = curatorFrameworkOp.getChildren(executorsPath);
            if (executors == null || executors.isEmpty()) {
                return this.getVersionStrFromList(versionList);
            }
            for (String exe : executors) {
                String tmp;
                String version;
                String versionPath = executorsPath + "/" + exe + "/version";
                if (!curatorFrameworkOp.checkExists(versionPath) || StringUtils.isBlank((CharSequence)(version = curatorFrameworkOp.getData(versionPath))) || versionList.contains(tmp = version.trim())) continue;
                versionList.add(tmp);
            }
            return this.getVersionStrFromList(versionList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private String getVersionStrFromList(List<String> versionList) {
        Collections.sort(versionList);
        StringBuilder versionSb = new StringBuilder();
        versionSb.append("");
        for (int i = 0; i < versionList.size(); ++i) {
            versionSb.append(versionList.get(i));
            if (i >= versionList.size() - 1) continue;
            versionSb.append(", ");
        }
        return versionSb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegistryCenterClient connect(String nameAndNameSpace) {
        RegistryCenterClient registryCenterClient = new RegistryCenterClient();
        registryCenterClient.setNameAndNamespace(nameAndNameSpace);
        if (nameAndNameSpace == null) {
            return registryCenterClient;
        }
        Object object = this.getNnsLock(nameAndNameSpace);
        synchronized (object) {
            if (!this.registryCenterClientMap.containsKey(nameAndNameSpace)) {
                RegistryCenterConfiguration registryCenterConfiguration = this.findConfig(nameAndNameSpace);
                if (registryCenterConfiguration == null) {
                    return registryCenterClient;
                }
                String zkAddressList = registryCenterConfiguration.getZkAddressList();
                String namespace = registryCenterConfiguration.getNamespace();
                String digest = registryCenterConfiguration.getDigest();
                registryCenterClient.setZkAddr(zkAddressList);
                CuratorFramework client = this.curatorRepository.connect(zkAddressList, namespace, digest);
                if (client == null) {
                    return registryCenterClient;
                }
                registryCenterClient.setConnected(client.getZookeeperClient().isConnected());
                registryCenterClient.setCuratorClient(client);
                this.registryCenterClientMap.put(nameAndNameSpace, registryCenterClient);
                return registryCenterClient;
            }
            RegistryCenterClient registryCenterClient2 = this.registryCenterClientMap.get(nameAndNameSpace);
            if (registryCenterClient2 != null) {
                if (registryCenterClient2.getCuratorClient() != null) {
                    registryCenterClient2.setConnected(registryCenterClient2.getCuratorClient().getZookeeperClient().isConnected());
                } else {
                    registryCenterClient2.setConnected(false);
                }
                return registryCenterClient2;
            }
            return registryCenterClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegistryCenterClient connectByNamespace(String namespace) {
        RegistryCenterConfiguration registryCenterConfiguration = this.findConfigByNamespace(namespace);
        if (registryCenterConfiguration == null) {
            return new RegistryCenterClient();
        }
        String nns = registryCenterConfiguration.getNameAndNamespace();
        if (nns == null) {
            return new RegistryCenterClient();
        }
        String zkAddressList = registryCenterConfiguration.getZkAddressList();
        String digest = registryCenterConfiguration.getDigest();
        Object object = this.getNnsLock(nns);
        synchronized (object) {
            if (!this.registryCenterClientMap.containsKey(nns)) {
                RegistryCenterClient registryCenterClient = new RegistryCenterClient();
                registryCenterClient.setNameAndNamespace(nns);
                registryCenterClient.setZkAddr(zkAddressList);
                CuratorFramework client = this.curatorRepository.connect(zkAddressList, namespace, digest);
                if (client == null) {
                    return registryCenterClient;
                }
                registryCenterClient.setConnected(client.getZookeeperClient().isConnected());
                registryCenterClient.setCuratorClient(client);
                this.registryCenterClientMap.put(nns, registryCenterClient);
                return registryCenterClient;
            }
            RegistryCenterClient registryCenterClient = this.registryCenterClientMap.get(nns);
            if (registryCenterClient == null) {
                registryCenterClient = new RegistryCenterClient();
                registryCenterClient.setNameAndNamespace(namespace);
                registryCenterClient.setZkAddr(zkAddressList);
            } else if (registryCenterClient.getCuratorClient() != null) {
                registryCenterClient.setConnected(registryCenterClient.getCuratorClient().getZookeeperClient().isConnected());
            } else {
                registryCenterClient.setConnected(false);
            }
            return registryCenterClient;
        }
    }

    @Override
    public RegistryCenterConfiguration findConfig(String nameAndNamespace) {
        if (Strings.isNullOrEmpty((String)nameAndNamespace)) {
            return null;
        }
        Collection<ZkCluster> zkClusters = this.zkClusterMap.values();
        for (ZkCluster zkCluster : zkClusters) {
            for (RegistryCenterConfiguration each : zkCluster.getRegCenterConfList()) {
                if (each == null || !nameAndNamespace.equals(each.getNameAndNamespace())) continue;
                return each;
            }
        }
        return null;
    }

    @Override
    public RegistryCenterConfiguration findConfigByNamespace(String namespace) {
        if (Strings.isNullOrEmpty((String)namespace)) {
            return null;
        }
        Collection<ZkCluster> zkClusters = this.zkClusterMap.values();
        for (ZkCluster zkCluster : zkClusters) {
            for (RegistryCenterConfiguration each : zkCluster.getRegCenterConfList()) {
                if (each == null || !namespace.equals(each.getNamespace())) continue;
                return each;
            }
        }
        return null;
    }

    @Override
    public List<RegistryCenterConfiguration> findConfigsByZkCluster(ZkCluster zkCluster) {
        List<String> namespaces = this.namespaceZkClusterMapping4SqlService.getAllNamespacesOfCluster(zkCluster.getZkClusterKey());
        if (namespaces == null || namespaces.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList configs = Lists.newArrayList();
        for (String namespace : namespaces) {
            RegistryCenterConfiguration config = this.constructRegistryCenterConfiguration(zkCluster, namespace);
            configs.add(config);
        }
        return configs;
    }

    protected RegistryCenterConfiguration constructRegistryCenterConfiguration(ZkCluster zkCluster, String namespace) {
        RegistryCenterConfiguration config = new RegistryCenterConfiguration("", namespace, zkCluster.getZkAddr());
        config.setZkClusterKey(zkCluster.getZkClusterKey());
        config.setZkAlias(zkCluster.getZkAlias());
        return config;
    }

    @Override
    public CuratorRepository.CuratorFrameworkOp connectOnly(String zkAddr, String namespace) throws SaturnJobConsoleException {
        CuratorFramework curatorFramework = this.curatorRepository.connect(zkAddr, namespace, null);
        if (curatorFramework != null) {
            return this.curatorRepository.newCuratorFrameworkOp(curatorFramework);
        }
        return null;
    }

    @Override
    public void notifyRefreshRegCenter() throws SaturnJobConsoleException {
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setProperty("REFRESH_REGISTRY_CENTER_UUID");
        systemConfig.setValue(UUID.randomUUID().toString());
        this.systemConfigService.insertOrUpdate(systemConfig);
    }

    @Override
    public RegistryCenterClient getCuratorByNameAndNamespace(String nameAndNamespace) {
        return this.registryCenterClientMap.get(nameAndNamespace);
    }

    @Override
    public boolean isDashboardLeader(String zkClusterKey) {
        DashboardLeaderHandler dashboardLeaderHandler = this.dashboardLeaderTreeCacheMap.get(zkClusterKey);
        if (dashboardLeaderHandler != null) {
            return dashboardLeaderHandler.isLeader();
        }
        return false;
    }

    @Override
    public ZkCluster getZkCluster(String zkClusterKey) {
        return this.zkClusterMap.get(zkClusterKey);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createZkCluster(String zkClusterKey, String alias, String connectString) throws SaturnJobConsoleException {
        ZkClusterInfo zkClusterInfo = this.zkClusterInfoService.getByClusterKey(zkClusterKey);
        if (zkClusterInfo != null) {
            throw new SaturnJobConsoleException(2, String.format("ZK cluster[%s]\u5df2\u7ecf\u5b58\u5728", zkClusterKey));
        }
        this.zkClusterInfoService.createZkCluster(zkClusterKey, alias, connectString, "");
        this.notifyRefreshRegCenter();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateZkCluster(String zkClusterKey, String connectString) throws SaturnJobConsoleException {
        ZkClusterInfo zkClusterInfo = this.zkClusterInfoService.getByClusterKey(zkClusterKey);
        if (zkClusterInfo == null) {
            throw new SaturnJobConsoleException(1, String.format("ZK cluster[%s]\u4e0d\u5b58\u5728", zkClusterKey));
        }
        zkClusterInfo.setConnectString(connectString);
        zkClusterInfo.setLastUpdateTime(new Date());
        this.zkClusterInfoService.updateZkCluster(zkClusterInfo);
        this.notifyRefreshRegCenter();
    }

    @Override
    public Collection<ZkCluster> getZkClusterList() {
        return this.zkClusterMap.values();
    }

    @Override
    public List<ZkCluster> getOnlineZkClusterList() {
        ArrayList onlineClusters = Lists.newArrayList();
        for (ZkCluster zkCluster : this.zkClusterMap.values()) {
            if (zkCluster.isOffline()) continue;
            onlineClusters.add(zkCluster);
        }
        return onlineClusters;
    }

    private List<String> getZkClusterKeys() {
        Collection<ZkCluster> zkClusters = this.getZkClusterList();
        ArrayList zkClusterKeys = Lists.newArrayList();
        for (ZkCluster zkCluster : zkClusters) {
            zkClusterKeys.add(zkCluster.getZkClusterKey());
        }
        return zkClusterKeys;
    }

    @Override
    public int domainCount(String zkClusterKey) {
        ArrayList<RegistryCenterConfiguration> regList;
        ZkCluster zkCluster = this.zkClusterMap.get(zkClusterKey);
        if (zkCluster != null && (regList = zkCluster.getRegCenterConfList()) != null) {
            return regList.size();
        }
        return 0;
    }

    @Override
    public boolean namespaceIsCorrect(String namespace, CuratorFramework curatorFramework) throws SaturnJobConsoleException {
        if ("$SaturnSelf".equals(namespace)) {
            return false;
        }
        try {
            String executorsPath = "/" + namespace + ExecutorNodePath.getExecutorNodePath();
            if (curatorFramework.checkExists().forPath(executorsPath) != null) {
                return true;
            }
            String jobsPath = "/" + namespace + JobNodePath.get$JobsNodePath();
            return curatorFramework.checkExists().forPath(jobsPath) != null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public List<String> getNamespaces() throws SaturnJobConsoleException {
        return this.allOnlineNamespaces;
    }

    @Override
    public File exportNamespaceInfo(List<String> namespaceList) throws SaturnJobConsoleException {
        HashSet targetNamespaceSet = null;
        if (namespaceList != null) {
            targetNamespaceSet = Sets.newHashSet(namespaceList);
        }
        LinkedList namespaceInfoList = Lists.newLinkedList();
        Collection<ZkCluster> zkClusterList = this.getZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            ArrayList<RegistryCenterConfiguration> namespacesOfZkCluster = zkCluster.getRegCenterConfList();
            for (RegistryCenterConfiguration ns : namespacesOfZkCluster) {
                if (targetNamespaceSet != null && !targetNamespaceSet.contains(ns.getNamespace())) continue;
                namespaceInfoList.add(ns);
            }
        }
        return this.exportNamespaceInfo2Excel(namespaceInfoList);
    }

    private File exportNamespaceInfo2Excel(List<RegistryCenterConfiguration> namespaceInfoList) throws SaturnJobConsoleException {
        try {
            File tmpFile = SaturnConsoleUtils.createTmpFile();
            WritableWorkbook writableWorkbook = Workbook.createWorkbook((File)tmpFile);
            WritableSheet sheet1 = writableWorkbook.createSheet("ns", 0);
            sheet1.addCell((WritableCell)new Label(0, 0, "\u57df\u540d"));
            sheet1.addCell((WritableCell)new Label(1, 0, "\u63cf\u8ff0"));
            sheet1.addCell((WritableCell)new Label(2, 0, "\u91cd\u8981\u7b49\u7ea7"));
            sheet1.addCell((WritableCell)new Label(3, 0, "Executor\u7248\u672c"));
            sheet1.addCell((WritableCell)new Label(4, 0, "ZK\u96c6\u7fa4"));
            for (int i = 0; i < namespaceInfoList.size(); ++i) {
                RegistryCenterConfiguration namespaceInfo = namespaceInfoList.get(i);
                sheet1.addCell((WritableCell)new Label(0, i + 1, namespaceInfo.getNamespace()));
                sheet1.addCell((WritableCell)new Label(1, i + 1, namespaceInfo.getName()));
                sheet1.addCell((WritableCell)new Label(2, i + 1, namespaceInfo.getDegree()));
                sheet1.addCell((WritableCell)new Label(3, i + 1, namespaceInfo.getVersion()));
                sheet1.addCell((WritableCell)new Label(4, i + 1, namespaceInfo.getZkAlias()));
            }
            writableWorkbook.write();
            writableWorkbook.close();
            return tmpFile;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleException(e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createNamespace(NamespaceDomainInfo namespaceDomainInfo) throws SaturnJobConsoleException {
        String namespace = namespaceDomainInfo.getNamespace();
        String zkClusterKey = namespaceDomainInfo.getZkCluster();
        ZkCluster currentCluster = this.getZkCluster(zkClusterKey);
        if (currentCluster == null) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format(ERR_MSG_TEMPLATE_FAIL_TO_CREATE, namespace, "not found zkcluster" + zkClusterKey));
        }
        if (this.checkNamespaceExists(namespace)) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format(ERR_MSG_NS_ALREADY_EXIST, namespace));
        }
        try {
            NamespaceInfo namespaceInfo = this.constructNamespaceInfo(namespaceDomainInfo);
            this.namespaceInfoService.create(namespaceInfo);
            this.namespaceZkClusterMapping4SqlService.insert(namespace, "", zkClusterKey, NAMESPACE_CREATOR_NAME);
            this.notifyRefreshRegCenter();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), String.format(ERR_MSG_TEMPLATE_FAIL_TO_CREATE, namespace, e.getMessage()));
        }
    }

    @Override
    public void updateNamespace(NamespaceDomainInfo namespaceDomainInfo) throws SaturnJobConsoleException {
        String namespace = namespaceDomainInfo.getNamespace();
        if (!this.checkNamespaceExists(namespace)) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), ERR_MSG_NS_NOT_FOUND);
        }
        try {
            NamespaceInfo namespaceInfo = this.constructNamespaceInfo(namespaceDomainInfo);
            this.namespaceInfoService.update(namespaceInfo);
            this.notifyRefreshRegCenter();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), String.format(ERR_MSG_TEMPLATE_FAIL_TO_CREATE, namespace, e.getMessage()));
        }
    }

    @Override
    public NamespaceDomainInfo getNamespace(String namespace) throws SaturnJobConsoleException {
        if (this.namespaceInfoService.selectByNamespace(namespace) == null) {
            throw new SaturnJobConsoleHttpException(HttpStatus.NOT_FOUND.value(), ERR_MSG_NS_NOT_FOUND);
        }
        String zkClusterKey = this.namespaceZkClusterMapping4SqlService.getZkClusterKey(namespace);
        if (StringUtils.isBlank((CharSequence)zkClusterKey)) {
            throw new SaturnJobConsoleHttpException(HttpStatus.NOT_FOUND.value(), ERR_MSG_NS_NOT_FOUND);
        }
        NamespaceDomainInfo namespaceDomainInfo = new NamespaceDomainInfo();
        namespaceDomainInfo.setNamespace(namespace);
        namespaceDomainInfo.setZkCluster(zkClusterKey);
        return namespaceDomainInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindNamespaceAndZkCluster(String namespace, String zkClusterKey, String updatedBy) throws SaturnJobConsoleException {
        ZkCluster currentCluster = this.getZkCluster(zkClusterKey);
        if (currentCluster == null) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format(ERR_MSG_TEMPLATE_FAIL_TO_CREATE, namespace, "not found zkcluster" + zkClusterKey));
        }
        if (!this.checkNamespaceExists(namespace)) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), ERR_MSG_NS_NOT_FOUND);
        }
        String zkClusterKeyOther = this.namespaceZkClusterMapping4SqlService.getZkClusterKey(namespace);
        if (zkClusterKeyOther != null) {
            ZkCluster zkClusterOther = this.getZkCluster(zkClusterKeyOther);
            if (zkClusterOther == null) {
                throw new SaturnJobConsoleException("zk cluster \u4e0d\u5b58\u5728\uff1a" + zkClusterKeyOther);
            }
            if (zkClusterOther.getZkClusterKey().equals(zkClusterKey)) {
                throw new SaturnJobConsoleException("Namespace\u5df2\u7ecf\u5b58\u5728\u4e8e\u6b64zk\u96c6\u7fa4\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
            throw new SaturnJobConsoleException("Namespace\u5b58\u5728\u4e8e\u53e6\u5916\u7684zk\u96c6\u7fa4\uff1a" + zkClusterOther.getZkClusterKey() + "\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        try {
            this.namespaceZkClusterMapping4SqlService.insert(namespace, "", zkClusterKey, updatedBy);
            this.postBindNamespaceAndZkCluster(namespace, currentCluster);
            this.notifyRefreshRegCenter();
        }
        catch (Exception e) {
            this.namespaceZkClusterMapping4SqlService.remove(namespace, updatedBy);
            throw new SaturnJobConsoleException(e.getMessage());
        }
    }

    protected void postBindNamespaceAndZkCluster(String namespace, ZkCluster currentCluster) throws SaturnJobConsoleException {
    }

    private boolean checkNamespaceExists(String namespace) {
        if (this.namespaceInfoService.selectByNamespace(namespace) != null) {
            return true;
        }
        String zkClusterKeyOther = this.namespaceZkClusterMapping4SqlService.getZkClusterKey(namespace);
        return zkClusterKeyOther != null;
    }

    private NamespaceInfo constructNamespaceInfo(NamespaceDomainInfo namespaceDomainInfo) {
        NamespaceInfo namespaceInfo = new NamespaceInfo();
        namespaceInfo.setCreatedBy(NAMESPACE_CREATOR_NAME);
        namespaceInfo.setCreateTime(new Date());
        namespaceInfo.setIsDeleted(0);
        namespaceInfo.setLastUpdatedBy(NAMESPACE_CREATOR_NAME);
        namespaceInfo.setLastUpdateTime(new Date());
        namespaceInfo.setNamespace(namespaceDomainInfo.getNamespace());
        namespaceInfo.setContent(namespaceDomainInfo.getContent());
        return namespaceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CuratorRepository.CuratorFrameworkOp getCuratorFrameworkOp(String namespace) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = null;
        try {
            RegistryCenterConfiguration registryCenterConfiguration = this.findConfigByNamespace(namespace);
            if (registryCenterConfiguration == null) {
                throw new SaturnJobConsoleException("Connect zookeeper failed");
            }
            String nns = registryCenterConfiguration.getNameAndNamespace();
            if (nns == null) {
                throw new SaturnJobConsoleException("Connect zookeeper failed");
            }
            String zkAddressList = registryCenterConfiguration.getZkAddressList();
            String digest = registryCenterConfiguration.getDigest();
            Object object = this.getNnsLock(nns);
            synchronized (object) {
                if (!this.registryCenterClientMap.containsKey(nns)) {
                    RegistryCenterClient registryCenterClient = new RegistryCenterClient();
                    registryCenterClient.setNameAndNamespace(nns);
                    registryCenterClient.setZkAddr(zkAddressList);
                    CuratorFramework curatorFramework = this.curatorRepository.connect(zkAddressList, namespace, digest);
                    if (curatorFramework != null) {
                        registryCenterClient.setConnected(curatorFramework.getZookeeperClient().isConnected());
                        registryCenterClient.setCuratorClient(curatorFramework);
                        this.registryCenterClientMap.put(nns, registryCenterClient);
                        curatorFrameworkOp = this.curatorRepository.newCuratorFrameworkOp(curatorFramework);
                    }
                } else {
                    CuratorFramework curatorFramework;
                    RegistryCenterClient registryCenterClient = this.registryCenterClientMap.get(nns);
                    if (registryCenterClient != null && (curatorFramework = registryCenterClient.getCuratorClient()) != null) {
                        registryCenterClient.setConnected(curatorFramework.getZookeeperClient().isConnected());
                        curatorFrameworkOp = this.curatorRepository.newCuratorFrameworkOp(curatorFramework);
                    }
                }
            }
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleException(e);
        }
        if (curatorFrameworkOp == null) {
            throw new SaturnJobConsoleException("Connect zookeeper failed");
        }
        return curatorFrameworkOp;
    }
}

