/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.google.common.collect.Lists;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.SystemConfig;
import com.vip.saturn.job.console.mybatis.service.SystemConfig4SqlService;
import com.vip.saturn.job.console.service.SystemConfigService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SystemConfigServiceImpl
implements SystemConfigService {
    private static final Logger log = LoggerFactory.getLogger(SystemConfigServiceImpl.class);
    private final ConcurrentHashMap<String, String> systemConfigCache = new ConcurrentHashMap();
    @Autowired
    private SystemConfig4SqlService systemConfig4SqlService;
    private Timer timer;
    private AtomicBoolean hasGotSystemConfigData = new AtomicBoolean(false);

    @PostConstruct
    public void init() {
        this.loadAll();
        this.timer = new Timer("get-systemConfig-to-memory-timer-" + System.currentTimeMillis(), true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    SystemConfigServiceImpl.this.loadAll();
                }
                catch (Throwable t) {
                    log.error("get system config from db error", t);
                }
            }
        }, 300000L, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAll() {
        try {
            log.info("begin to get system config from db");
            List<SystemConfig> systemConfigs = this.systemConfig4SqlService.selectByLastly();
            ConcurrentHashMap<String, String> concurrentHashMap = this.systemConfigCache;
            synchronized (concurrentHashMap) {
                this.systemConfigCache.clear();
                if (systemConfigs != null && !systemConfigs.isEmpty()) {
                    for (SystemConfig systemConfig : systemConfigs) {
                        this.systemConfigCache.put(systemConfig.getProperty(), systemConfig.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            log.info("end get system config from db");
            this.hasGotSystemConfigData.compareAndSet(false, true);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public boolean hasGotSystemConfigData() throws SaturnJobConsoleException {
        return this.hasGotSystemConfigData.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue(String property) {
        ConcurrentHashMap<String, String> concurrentHashMap = this.systemConfigCache;
        synchronized (concurrentHashMap) {
            return this.systemConfigCache.get(property);
        }
    }

    @Override
    public String getValueDirectly(String property) {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(property);
        List<SystemConfig> systemConfigs = this.systemConfig4SqlService.selectByPropertiesAndLastly(properties);
        return systemConfigs == null || systemConfigs.isEmpty() ? null : systemConfigs.get(0).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getValuesByPrefix(String prefix) {
        ConcurrentHashMap<String, String> concurrentHashMap = this.systemConfigCache;
        synchronized (concurrentHashMap) {
            ArrayList result = Lists.newArrayList();
            for (Map.Entry<String, String> entry : this.systemConfigCache.entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                result.add(entry.getValue());
            }
            return result;
        }
    }

    @Override
    public Integer getIntegerValue(String property, int defaultValue) {
        String strValue = this.getValue(property);
        if (StringUtils.isBlank((CharSequence)strValue)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(strValue.trim());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public boolean getBooleanValue(String property, boolean defaultValue) {
        String strValue = this.getValue(property);
        if (StringUtils.isBlank((CharSequence)strValue)) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(strValue.trim());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public List<SystemConfig> getAllSystemConfigs() {
        return this.systemConfig4SqlService.selectAllConfig();
    }

    @Override
    public List<SystemConfig> getSystemConfigsDirectly(List<String> properties) throws SaturnJobConsoleException {
        return properties != null && !properties.isEmpty() ? this.systemConfig4SqlService.selectByPropertiesAndLastly(properties) : this.systemConfig4SqlService.selectByLastly();
    }

    @Override
    public List<SystemConfig> getSystemConfigsByPrefix(String prefix) throws SaturnJobConsoleException {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return Lists.newArrayList();
        }
        return this.systemConfig4SqlService.selectByPropertyPrefix(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPropertiesCached() throws SaturnJobConsoleException {
        StringBuilder sb = new StringBuilder(100);
        ConcurrentHashMap<String, String> concurrentHashMap = this.systemConfigCache;
        synchronized (concurrentHashMap) {
            Iterator<Map.Entry<String, String>> iterator = this.systemConfigCache.entrySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().getKey();
                sb.append(key).append(',');
            }
            int lastIndex = sb.length() - 1;
            if (lastIndex > -1 && sb.charAt(lastIndex) == ',') {
                sb.deleteCharAt(lastIndex);
            }
        }
        return sb.toString();
    }

    @Override
    public Integer insertOrUpdate(SystemConfig systemConfig) throws SaturnJobConsoleException {
        SystemConfig systemConfig1;
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(systemConfig.getProperty());
        List<SystemConfig> systemConfigs = this.systemConfig4SqlService.selectByPropertiesAndLastly(properties);
        if (systemConfigs != null && systemConfigs.size() > 0 && (systemConfig1 = systemConfigs.get(0)) != null) {
            systemConfig1.setProperty(systemConfig.getProperty());
            systemConfig1.setValue(systemConfig.getValue());
            int result = this.systemConfig4SqlService.updateById(systemConfig1);
            this.updateCacheIfNeed(systemConfig, result);
            return result;
        }
        int result = this.systemConfig4SqlService.insert(systemConfig);
        this.updateCacheIfNeed(systemConfig, result);
        return result;
    }

    @Override
    public Integer createConfig(SystemConfig systemConfig) throws SaturnJobConsoleException {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(systemConfig.getProperty());
        List<SystemConfig> systemConfigs = this.systemConfig4SqlService.selectByProperty(systemConfig.getProperty());
        boolean found = false;
        if (systemConfigs != null) {
            for (int i = 0; i < systemConfigs.size(); ++i) {
                SystemConfig config = systemConfigs.get(i);
                if (!StringUtils.equals((CharSequence)config.getProperty(), (CharSequence)systemConfig.getProperty())) continue;
                found = true;
                break;
            }
        }
        if (found) {
            throw new SaturnJobConsoleException(String.format("systemConfig %s already existed", systemConfig.getProperty()));
        }
        int result = this.systemConfig4SqlService.insert(systemConfig);
        this.updateCacheIfNeed(systemConfig, result);
        return result;
    }

    @Override
    public Integer updateConfig(SystemConfig systemConfig) throws SaturnJobConsoleException {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(systemConfig.getProperty());
        List<SystemConfig> systemConfigs = this.systemConfig4SqlService.selectByPropertiesAndLastly(properties);
        if (systemConfigs == null || systemConfigs.isEmpty()) {
            throw new SaturnJobConsoleException(String.format("systemConfig %s not existed, update fail", systemConfig.getProperty()));
        }
        SystemConfig config = systemConfigs.get(0);
        config.setProperty(systemConfig.getProperty());
        config.setValue(systemConfig.getValue());
        int result = this.systemConfig4SqlService.updateById(config);
        this.updateCacheIfNeed(systemConfig, result);
        return result;
    }

    @Override
    public void reload() {
        this.loadAll();
    }

    private void updateCacheIfNeed(SystemConfig systemConfig, int result) {
        if (result > 0) {
            this.systemConfigCache.put(systemConfig.getProperty(), systemConfig.getValue());
        }
    }
}

