/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.vip.saturn.job.console.domain.ForecastCronResult;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.service.UtilsService;
import com.vip.saturn.job.console.utils.CronExpression;
import com.vip.saturn.job.console.utils.SaturnConstants;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class UtilsServiceImpl
implements UtilsService {
    @Override
    public ForecastCronResult checkAndForecastCron(String timeZone, String cron) throws SaturnJobConsoleException {
        if (StringUtils.isBlank((CharSequence)timeZone)) {
            throw new SaturnJobConsoleException("timeZone\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)cron)) {
            throw new SaturnJobConsoleException("cron\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String timeZoneTrim = timeZone.trim();
        String cronTrim = cron.trim();
        if (!SaturnConstants.TIME_ZONE_IDS.contains(timeZoneTrim)) {
            throw new SaturnJobConsoleException(String.format("timeZone(%s)\u65e0\u6548", timeZoneTrim));
        }
        TimeZone tz = TimeZone.getTimeZone(timeZoneTrim);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(tz);
        CronExpression cronExpression = null;
        try {
            cronExpression = new CronExpression(cronTrim);
        }
        catch (ParseException e) {
            throw new SaturnJobConsoleException(String.format("cron(%s)\u683c\u5f0f\u9519\u8bef:%s", cronTrim, e.getMessage()));
        }
        cronExpression.setTimeZone(tz);
        ForecastCronResult forecastCronResult = new ForecastCronResult();
        forecastCronResult.setTimeZone(timeZoneTrim);
        forecastCronResult.setCron(cronTrim);
        forecastCronResult.setNextFireTimes(new ArrayList<String>());
        Date now = new Date();
        for (int i = 0; i < 10; ++i) {
            Date next = cronExpression.getNextValidTimeAfter(now);
            if (next == null) continue;
            forecastCronResult.getNextFireTimes().add(dateFormat.format(next));
            now = next;
        }
        if (forecastCronResult.getNextFireTimes().isEmpty()) {
            throw new SaturnJobConsoleException(String.format("cron(%s)\u53ef\u80fd\u63cf\u8ff0\u7684\u662f\u4e00\u4e2a\u8fc7\u53bb\u7684\u65f6\u95f4\uff0c\u5c06\u4e0d\u4f1a\u88ab\u6267\u884c", cronTrim));
        }
        return forecastCronResult;
    }

    @Override
    public List<String> getTimeZones() throws SaturnJobConsoleException {
        return SaturnConstants.TIME_ZONE_IDS;
    }
}

