/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.vip.saturn.job.console.domain.JobConfig;
import com.vip.saturn.job.console.domain.JobDiffInfo;
import com.vip.saturn.job.console.domain.RegistryCenterClient;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.JobConfig4DB;
import com.vip.saturn.job.console.mybatis.service.CurrentJobConfigService;
import com.vip.saturn.job.console.mybatis.service.NamespaceZkClusterMapping4SqlService;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.service.ZkDBDiffService;
import com.vip.saturn.job.console.utils.ConsoleThreadFactory;
import com.vip.saturn.job.console.utils.JobNodePath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkDBDiffServiceImpl
implements ZkDBDiffService {
    private static final Logger log = LoggerFactory.getLogger(ZkDBDiffServiceImpl.class);
    private static final String NAMESPACE_NOT_EXIST_TEMPLATE = "The namespace {%s} does not exists.";
    private static final String ERR_MSG_SKIP_DIFF = "skip diff by namespace:{} for reason:{}";
    private static final int DIFF_THREAD_NUM = 10;
    @Resource
    private NamespaceZkClusterMapping4SqlService namespaceZkClusterMapping4SqlService;
    @Resource
    private CurrentJobConfigService currentJobConfigService;
    @Resource
    private JobService jobService;
    @Resource
    private RegistryCenterService registryCenterService;
    @Resource
    private CuratorRepository curatorRepository;
    private ExecutorService diffExecutorService;

    @PostConstruct
    public void init() {
        if (this.diffExecutorService != null) {
            this.diffExecutorService.shutdownNow();
        }
        this.diffExecutorService = Executors.newFixedThreadPool(10, new ConsoleThreadFactory("diff-zk-db-thread", false));
    }

    @PreDestroy
    public void destroy() {
        if (this.diffExecutorService != null) {
            this.diffExecutorService.shutdownNow();
        }
    }

    @Override
    public List<JobDiffInfo> diffByCluster(String clusterKey) throws SaturnJobConsoleException {
        long startTime = System.currentTimeMillis();
        List<String> namespaces = this.namespaceZkClusterMapping4SqlService.getAllNamespacesOfCluster(clusterKey);
        ArrayList callableList = Lists.newArrayList();
        for (final String namespace : namespaces) {
            Callable<List<JobDiffInfo>> callable = new Callable<List<JobDiffInfo>>(){

                @Override
                public List<JobDiffInfo> call() throws Exception {
                    return ZkDBDiffServiceImpl.this.diffByNamespace(namespace);
                }
            };
            callableList.add(callable);
        }
        ArrayList resultList = Lists.newArrayList();
        try {
            List futures = this.diffExecutorService.invokeAll(callableList);
            for (Future future : futures) {
                List jobDiffInfos = (List)future.get();
                if (jobDiffInfos == null || jobDiffInfos.isEmpty()) continue;
                resultList.addAll(jobDiffInfos);
            }
        }
        catch (InterruptedException e) {
            log.warn("the thread is interrupted", (Throwable)e);
            throw new SaturnJobConsoleException("the diff thread is interrupted", e);
        }
        catch (Exception e) {
            log.error("exception happens during execute diff operation", (Throwable)e);
            throw new SaturnJobConsoleException(e);
        }
        log.info("Finish diff zkcluster:{}, which cost {}ms", (Object)clusterKey, (Object)(System.currentTimeMillis() - startTime));
        return resultList;
    }

    @Override
    public List<JobDiffInfo> diffByNamespace(String namespace) throws SaturnJobConsoleException {
        long startTime = System.currentTimeMillis();
        ArrayList jobDiffInfos = Lists.newArrayList();
        try {
            List<JobConfig4DB> dbJobConfigList = this.currentJobConfigService.findConfigsByNamespace(namespace);
            if (dbJobConfigList == null || dbJobConfigList.isEmpty()) {
                ArrayList arrayList = jobDiffInfos;
                return arrayList;
            }
            CuratorRepository.CuratorFrameworkOp zkClient = this.initCuratorClient(namespace);
            if (zkClient == null) {
                ArrayList arrayList = jobDiffInfos;
                return arrayList;
            }
            Set<String> jobNamesInDb = this.getAllJobNames(dbJobConfigList);
            for (JobConfig4DB dbJobConfig : dbJobConfigList) {
                String jobName = dbJobConfig.getJobName();
                log.info("start to diff job:{}@{}", (Object)jobName, (Object)namespace);
                if (!this.checkJobIsExsitInZk(jobName, zkClient)) {
                    jobDiffInfos.add(new JobDiffInfo(namespace, jobName, JobDiffInfo.DiffType.DB_ONLY, Lists.newArrayList()));
                    continue;
                }
                JobConfig jobConfigFromZK = this.jobService.getJobConfigFromZK(namespace, jobName);
                JobDiffInfo jobDiffInfo = this.diff(namespace, dbJobConfig, jobConfigFromZK, false);
                if (jobDiffInfo == null) continue;
                jobDiffInfos.add(jobDiffInfo);
            }
            List<JobDiffInfo> jobsInZkOnly = this.getJobNamesWhichInZKOnly(namespace, jobNamesInDb);
            if (jobsInZkOnly != null && !jobsInZkOnly.isEmpty()) {
                jobDiffInfos.addAll(jobsInZkOnly);
            }
        }
        catch (SaturnJobConsoleException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("exception throws during diff by namespace [{}]", (Object)namespace, (Object)e);
            throw new SaturnJobConsoleException(e);
        }
        finally {
            log.info("Finish diff namespace:{} which cost {}ms", (Object)namespace, (Object)(System.currentTimeMillis() - startTime));
        }
        return jobDiffInfos;
    }

    @Override
    public JobDiffInfo diffByJob(String namespace, String jobName) throws SaturnJobConsoleException {
        try {
            CuratorRepository.CuratorFrameworkOp zkClient = this.initCuratorClient(namespace);
            if (zkClient == null) {
                return null;
            }
            log.info("start to diff job:{}", (Object)jobName);
            JobConfig4DB dbJobConfig = this.currentJobConfigService.findConfigByNamespaceAndJobName(namespace, jobName);
            JobConfig zkJobConfig = this.jobService.getJobConfigFromZK(namespace, jobName);
            if (dbJobConfig == null) {
                if (zkJobConfig != null) {
                    return new JobDiffInfo(namespace, jobName, JobDiffInfo.DiffType.ZK_ONLY, Lists.newArrayList());
                }
                return null;
            }
            if (zkJobConfig == null) {
                return new JobDiffInfo(namespace, jobName, JobDiffInfo.DiffType.DB_ONLY, Lists.newArrayList());
            }
            return this.diff(namespace, dbJobConfig, zkJobConfig, true);
        }
        catch (Exception e) {
            log.error("exception throws during diff by namespace [{}] and job [{}]", new Object[]{namespace, jobName, e});
            throw new SaturnJobConsoleException(e);
        }
    }

    private boolean checkJobIsExsitInZk(String jobName, CuratorRepository.CuratorFrameworkOp zkClient) {
        return zkClient.checkExists(JobNodePath.getJobNodePath(jobName));
    }

    protected JobDiffInfo diff(String namespace, JobConfig dbJobConfig, JobConfig zkJobConfig, boolean needDetail) {
        String jobName = dbJobConfig.getJobName();
        ArrayList configDiffInfos = Lists.newArrayList();
        String jobTypeInDB = dbJobConfig.getJobType();
        this.diff("jobType", jobTypeInDB, zkJobConfig.getJobType(), configDiffInfos);
        this.diff("jobClass", dbJobConfig.getJobClass(), zkJobConfig.getJobClass(), configDiffInfos);
        this.diff("shardingTotalCount", dbJobConfig.getShardingTotalCount(), zkJobConfig.getShardingTotalCount(), configDiffInfos);
        this.diff("timeZone", dbJobConfig.getTimeZone(), zkJobConfig.getTimeZone(), configDiffInfos);
        this.diff("cron", dbJobConfig.getCron(), zkJobConfig.getCron(), configDiffInfos);
        this.diff("pausePeriodDate", dbJobConfig.getPausePeriodDate(), zkJobConfig.getPausePeriodDate(), configDiffInfos);
        this.diff("pausePeriodTime", dbJobConfig.getPausePeriodTime(), zkJobConfig.getPausePeriodTime(), configDiffInfos);
        this.diff("shardingItemParameters", dbJobConfig.getShardingItemParameters(), zkJobConfig.getShardingItemParameters(), configDiffInfos);
        this.diff("jobParameter", dbJobConfig.getJobParameter(), zkJobConfig.getJobParameter(), configDiffInfos);
        this.diff("processCountIntervalSeconds", dbJobConfig.getProcessCountIntervalSeconds(), zkJobConfig.getProcessCountIntervalSeconds(), configDiffInfos);
        this.diff("timeout4AlarmSeconds", dbJobConfig.getTimeout4AlarmSeconds(), zkJobConfig.getTimeout4AlarmSeconds(), configDiffInfos);
        this.diff("timeoutSeconds", dbJobConfig.getTimeoutSeconds(), zkJobConfig.getTimeoutSeconds(), configDiffInfos);
        this.diff("loadLevel", dbJobConfig.getLoadLevel(), zkJobConfig.getLoadLevel(), configDiffInfos);
        this.diff("jobDegree", dbJobConfig.getJobDegree(), zkJobConfig.getJobDegree(), configDiffInfos);
        this.diff("enabled", dbJobConfig.getEnabled(), zkJobConfig.getEnabled(), configDiffInfos);
        this.diff("preferList", dbJobConfig.getPreferList(), zkJobConfig.getPreferList(), configDiffInfos);
        this.diff("useDispreferList", dbJobConfig.getUseDispreferList(), zkJobConfig.getUseDispreferList(), configDiffInfos);
        this.diff("useSerial", dbJobConfig.getUseSerial(), zkJobConfig.getUseSerial(), configDiffInfos);
        this.diff("queueName", dbJobConfig.getQueueName(), zkJobConfig.getQueueName(), configDiffInfos);
        this.diff("localMode", dbJobConfig.getLocalMode(), zkJobConfig.getLocalMode(), configDiffInfos);
        this.diff("dependencies", dbJobConfig.getDependencies(), zkJobConfig.getDependencies(), configDiffInfos);
        this.diff("groups", dbJobConfig.getGroups(), zkJobConfig.getGroups(), configDiffInfos);
        this.diff("description", dbJobConfig.getDescription(), zkJobConfig.getDescription(), configDiffInfos);
        this.diff("jobMode", dbJobConfig.getJobMode(), zkJobConfig.getJobMode(), configDiffInfos);
        this.diff("channelName", dbJobConfig.getChannelName(), zkJobConfig.getChannelName(), configDiffInfos);
        this.diff("showNormalLog", dbJobConfig.getShowNormalLog(), zkJobConfig.getShowNormalLog(), configDiffInfos);
        this.diff("enabledReport", dbJobConfig.getEnabledReport(), zkJobConfig.getEnabledReport(), configDiffInfos);
        this.diff("showNormalLog", dbJobConfig.getShowNormalLog(), zkJobConfig.getShowNormalLog(), configDiffInfos);
        if (!configDiffInfos.isEmpty()) {
            if (needDetail) {
                return new JobDiffInfo(namespace, jobName, JobDiffInfo.DiffType.HAS_DIFFERENCE, configDiffInfos);
            }
            return new JobDiffInfo(namespace, jobName, JobDiffInfo.DiffType.HAS_DIFFERENCE, Lists.newArrayList());
        }
        return null;
    }

    public void diff(String key, Object valueInDb, Object valueInZk, List<JobDiffInfo.ConfigDiffInfo> configDiffInfos) {
        if (valueInDb == null) {
            if (valueInZk == null) {
                return;
            }
            if (valueInZk instanceof String && StringUtils.isEmpty((CharSequence)((String)valueInZk))) {
                return;
            }
            log.debug("key:{} has difference between zk and db", (Object)key);
            configDiffInfos.add(new JobDiffInfo.ConfigDiffInfo(key, valueInDb, valueInZk));
            return;
        }
        if (valueInZk == null) {
            log.debug("key:{} has difference between zk and db", (Object)key);
            configDiffInfos.add(new JobDiffInfo.ConfigDiffInfo(key, valueInDb, valueInZk));
            return;
        }
        if (valueInDb instanceof String) {
            String dbStr = (String)valueInDb;
            String zkStr = (String)valueInZk;
            if (StringUtils.isEmpty((CharSequence)dbStr) && StringUtils.isEmpty((CharSequence)zkStr)) {
                return;
            }
            if (!dbStr.trim().equals(zkStr.trim())) {
                log.debug("key:{} has difference between zk and db", (Object)key);
                configDiffInfos.add(new JobDiffInfo.ConfigDiffInfo(key, dbStr, zkStr));
                return;
            }
            return;
        }
        if (!valueInDb.equals(valueInZk)) {
            log.debug("key:{} has difference between zk and db", (Object)key);
            configDiffInfos.add(new JobDiffInfo.ConfigDiffInfo(key, valueInDb, valueInZk));
        }
    }

    private CuratorRepository.CuratorFrameworkOp initCuratorClient(String namespace) {
        RegistryCenterConfiguration registryCenterConfiguration = this.registryCenterService.findConfigByNamespace(namespace);
        if (registryCenterConfiguration == null) {
            String errMsg = String.format(NAMESPACE_NOT_EXIST_TEMPLATE, namespace);
            log.warn(ERR_MSG_SKIP_DIFF, (Object)namespace, (Object)errMsg);
            return null;
        }
        RegistryCenterClient registryCenterClient = this.registryCenterService.connectByNamespace(namespace);
        if (registryCenterClient != null && registryCenterClient.isConnected()) {
            return this.curatorRepository.newCuratorFrameworkOp(registryCenterClient.getCuratorClient());
        }
        log.warn(ERR_MSG_SKIP_DIFF, (Object)namespace, (Object)"fail to connect to zk.");
        return null;
    }

    private List<JobDiffInfo> getJobNamesWhichInZKOnly(String namespace, Set<String> jobNamesInDb) throws SaturnJobConsoleException {
        ArrayList jobsOnlyInZK = Lists.newArrayList();
        List<String> jobNamesInZk = this.jobService.getAllJobNamesFromZK(namespace);
        for (String name : jobNamesInZk) {
            if (jobNamesInDb != null && !jobNamesInDb.isEmpty() && jobNamesInDb.contains(name)) continue;
            jobsOnlyInZK.add(new JobDiffInfo(namespace, name, JobDiffInfo.DiffType.ZK_ONLY, Lists.newArrayList()));
        }
        return jobsOnlyInZK;
    }

    private Set<String> getAllJobNames(List<JobConfig4DB> dbJobConfigList) {
        HashSet jobNames = Sets.newHashSet();
        for (JobConfig4DB jobConfig : dbJobConfigList) {
            jobNames.add(jobConfig.getJobName());
        }
        return jobNames;
    }
}

