/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl.marathon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.vip.saturn.job.console.SaturnEnvProperties;
import com.vip.saturn.job.console.domain.container.ContainerConfig;
import com.vip.saturn.job.console.domain.container.ContainerStatus;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.service.impl.marathon.entity.Tasks;
import com.vip.saturn.job.console.service.impl.marathon.entity.WrapperApp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarathonRestClient {
    private static final String AUTHORIZATION_DES = "Authorization";
    private static final String BASIC_DES = "Basic ";
    private static final String UTF8_DES = "UTF-8";
    private static final String API_VERSION_DES = "/v2/apps/";
    private static Logger log = LoggerFactory.getLogger(MarathonRestClient.class);

    private static String getEntityContent(HttpEntity entity) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(entity.getContent()));){
            StringBuilder sb = new StringBuilder();
            int maxLen = 1024;
            char[] cBuf = new char[maxLen];
            int readLen = -1;
            while ((readLen = in.read(cBuf, 0, maxLen)) != -1) {
                sb.append(cBuf, 0, readLen);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static void deploy(String userName, String password, ContainerConfig containerConfig) throws SaturnJobConsoleException {
        block12: {
            JSONObject deployFormModel = new JSONObject();
            deployFormModel.put("id", (Object)containerConfig.getTaskId());
            deployFormModel.put("instances", (Object)containerConfig.getInstances());
            deployFormModel.put("cmd", (Object)containerConfig.getCmd());
            deployFormModel.put("cpus", (Object)containerConfig.getCpus());
            deployFormModel.put("mem", (Object)containerConfig.getMem());
            deployFormModel.put("constraints", containerConfig.getConstraints());
            JSONObject container = new JSONObject();
            JSONObject docker = new JSONObject();
            docker.put("forcePullImage", (Object)containerConfig.getForcePullImage());
            docker.put("image", (Object)containerConfig.getImage());
            docker.put("network", (Object)"BRIDGE");
            docker.put("parameters", containerConfig.getParameters());
            docker.put("privileged", (Object)containerConfig.getPrivileged());
            JSONArray portMappings = new JSONArray();
            JSONObject portMapping = new JSONObject();
            portMapping.put("containerPort", (Object)24500);
            portMapping.put("hostPort", (Object)0);
            portMapping.put("servicePort", (Object)0);
            portMapping.put("protocol", (Object)"tcp");
            portMappings.add((Object)portMapping);
            docker.put("portMappings", (Object)portMappings);
            container.put("docker", (Object)docker);
            container.put("type", (Object)"DOCKER");
            container.put("volumes", containerConfig.getVolumes());
            deployFormModel.put("container", (Object)container);
            deployFormModel.put("env", containerConfig.getEnv());
            JSONArray healthChecks = new JSONArray();
            JSONObject healthCheck = new JSONObject();
            healthCheck.put("protocol", (Object)"TCP");
            healthChecks.add((Object)healthCheck);
            deployFormModel.put("healthChecks", (Object)healthChecks);
            String urlStr = SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI + "/v2/apps";
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpPost httpPost = new HttpPost(urlStr);
                httpPost.setHeader(AUTHORIZATION_DES, BASIC_DES + Base64.encodeBase64String((byte[])(userName + ":" + password).getBytes(UTF8_DES)));
                httpPost.setHeader("Content-type", "application/json; charset=utf-8");
                httpPost.setEntity((HttpEntity)new StringEntity(deployFormModel.toJSONString()));
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null) {
                    int statusCode = statusLine.getStatusCode();
                    String reasonPhrase = statusLine.getReasonPhrase();
                    if (statusCode != 200 && statusCode != 201) {
                        HttpEntity entity = httpResponse.getEntity();
                        if (entity != null) {
                            String entityContent = MarathonRestClient.getEntityContent(entity);
                            throw new SaturnJobConsoleException(entityContent);
                        }
                        throw new SaturnJobConsoleException("statusCode is " + statusCode + ", reasonPhrase is " + reasonPhrase);
                    }
                    break block12;
                }
                throw new SaturnJobConsoleException("Not status returned, url is " + urlStr);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SaturnJobConsoleException(e);
            }
            finally {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void destroy(String userName, String password, String appId) throws SaturnJobConsoleException {
        block12: {
            String urlStr = SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI + API_VERSION_DES + appId;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpDelete httpDelete = new HttpDelete(urlStr);
                httpDelete.setHeader(AUTHORIZATION_DES, BASIC_DES + Base64.encodeBase64String((byte[])(userName + ":" + password).getBytes(UTF8_DES)));
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpDelete);
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null) {
                    int statusCode = statusLine.getStatusCode();
                    String reasonPhrase = statusLine.getReasonPhrase();
                    if (statusCode != 200) {
                        HttpEntity entity = httpResponse.getEntity();
                        if (entity != null) {
                            String entityContent = MarathonRestClient.getEntityContent(entity);
                            throw new SaturnJobConsoleException(entityContent);
                        }
                        throw new SaturnJobConsoleException("statusCode is " + statusCode + ", reasonPhrase is " + reasonPhrase);
                    }
                    break block12;
                }
                throw new SaturnJobConsoleException("Not status returned, url is " + urlStr);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SaturnJobConsoleException(e);
            }
            finally {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int count(String userName, String password, String appId) throws SaturnJobConsoleException {
        String urlStr = SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI + API_VERSION_DES + appId + "/tasks";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpGet httpGet = new HttpGet(urlStr);
            httpGet.setHeader(AUTHORIZATION_DES, BASIC_DES + Base64.encodeBase64String((byte[])(userName + ":" + password).getBytes(UTF8_DES)));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) throw new SaturnJobConsoleException("Not status returned, url is " + urlStr);
            String entityContent = MarathonRestClient.getEntityContent(entity);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                Tasks tasks = (Tasks)JSON.parseObject((String)entityContent, Tasks.class);
                int n = tasks != null && tasks.getTaskList() != null ? tasks.getTaskList().size() : 0;
                return n;
            }
            try {
                throw new SaturnJobConsoleException(entityContent);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SaturnJobConsoleException(e);
            }
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void scale(String userName, String password, String appId, Integer instances) throws SaturnJobConsoleException {
        block12: {
            JSONObject params = new JSONObject();
            params.put("instances", (Object)instances);
            String urlStr = SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI + API_VERSION_DES + appId + "?force=true";
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpPut httpPut = new HttpPut(urlStr);
                httpPut.setHeader(AUTHORIZATION_DES, BASIC_DES + Base64.encodeBase64String((byte[])(userName + ":" + password).getBytes(UTF8_DES)));
                httpPut.setHeader("Content-type", "application/json; charset=utf-8");
                httpPut.setEntity((HttpEntity)new StringEntity(params.toJSONString()));
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPut);
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null) {
                    int statusCode = statusLine.getStatusCode();
                    String reasonPhrase = statusLine.getReasonPhrase();
                    if (statusCode != 200 && statusCode != 201) {
                        HttpEntity entity = httpResponse.getEntity();
                        if (entity != null) {
                            String entityContent = MarathonRestClient.getEntityContent(entity);
                            throw new SaturnJobConsoleException(entityContent);
                        }
                        throw new SaturnJobConsoleException("statusCode is " + statusCode + ", reasonPhrase is " + reasonPhrase);
                    }
                    break block12;
                }
                throw new SaturnJobConsoleException("Not status returned, url is " + urlStr);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SaturnJobConsoleException(e);
            }
            finally {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContainerStatus getContainerStatus(String userName, String password, String appId) throws SaturnJobConsoleException {
        String urlStr = SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI + API_VERSION_DES + appId;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpGet httpGet = new HttpGet(urlStr);
            httpGet.setHeader(AUTHORIZATION_DES, BASIC_DES + Base64.encodeBase64String((byte[])(userName + ":" + password).getBytes(UTF8_DES)));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) throw new SaturnJobConsoleException("Not data returned, url is " + urlStr);
            String entityContent = MarathonRestClient.getEntityContent(entity);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                WrapperApp app = (WrapperApp)JSON.parseObject((String)entityContent, WrapperApp.class);
                ContainerStatus containerStatus = new ContainerStatus();
                containerStatus.setHealthyCount(app.getApp().getTasksHealthy());
                containerStatus.setUnhealthyCount(app.getApp().getTasksUnhealthy());
                containerStatus.setRunningCount(app.getApp().getTasksRunning());
                containerStatus.setStagedCount(app.getApp().getTasksStaged());
                containerStatus.setTotalCount(app.getApp().getInstances());
                ContainerStatus containerStatus2 = containerStatus;
                return containerStatus2;
            }
            try {
                throw new SaturnJobConsoleException(entityContent);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SaturnJobConsoleException(e);
            }
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String info(String userName, String password, String appId) throws SaturnJobConsoleException {
        String urlStr = SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI + API_VERSION_DES + appId;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpGet httpGet = new HttpGet(urlStr);
            httpGet.setHeader(AUTHORIZATION_DES, BASIC_DES + Base64.encodeBase64String((byte[])(userName + ":" + password).getBytes(UTF8_DES)));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) throw new SaturnJobConsoleException("Not data returned, url is " + urlStr);
            String entityContent = MarathonRestClient.getEntityContent(entity);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                String string = entityContent;
                return string;
            }
            try {
                throw new SaturnJobConsoleException(entityContent);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SaturnJobConsoleException(e);
            }
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getRegistryCatalog() throws SaturnJobConsoleException {
        String urlStr = SaturnEnvProperties.VIP_SATURN_DCOS_REGISTRY_URI + "/v2/_catalog";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpGet httpGet = new HttpGet(urlStr);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) throw new SaturnJobConsoleException("Not data returned, url is " + urlStr);
            String entityContent = MarathonRestClient.getEntityContent(entity);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                String string = entityContent;
                return string;
            }
            try {
                throw new SaturnJobConsoleException(entityContent);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SaturnJobConsoleException(e);
            }
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getRegistryRepositoriesTagsList(String repository) throws SaturnJobConsoleException {
        String urlStr = SaturnEnvProperties.VIP_SATURN_DCOS_REGISTRY_URI + "/v2/" + repository + "/tags/list";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpGet httpGet = new HttpGet(urlStr);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) throw new SaturnJobConsoleException("Not data returned, url is " + urlStr);
            String entityContent = MarathonRestClient.getEntityContent(entity);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                String string = entityContent;
                return string;
            }
            try {
                throw new SaturnJobConsoleException(entityContent);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SaturnJobConsoleException(e);
            }
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

