/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl.marathon;

import com.alibaba.fastjson.JSON;
import com.vip.saturn.job.console.SaturnEnvProperties;
import com.vip.saturn.job.console.domain.JobConfig;
import com.vip.saturn.job.console.domain.JobStatus;
import com.vip.saturn.job.console.domain.JobType;
import com.vip.saturn.job.console.domain.container.ContainerConfig;
import com.vip.saturn.job.console.domain.container.ContainerScaleJob;
import com.vip.saturn.job.console.domain.container.ContainerScaleJobConfig;
import com.vip.saturn.job.console.domain.container.ContainerStatus;
import com.vip.saturn.job.console.domain.container.ContainerToken;
import com.vip.saturn.job.console.domain.container.vo.ContainerExecutorVo;
import com.vip.saturn.job.console.domain.container.vo.ContainerScaleJobVo;
import com.vip.saturn.job.console.domain.container.vo.ContainerVo;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.service.MarathonService;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.service.SystemConfigService;
import com.vip.saturn.job.console.service.impl.marathon.MarathonRestClient;
import com.vip.saturn.job.console.utils.ContainerNodePath;
import com.vip.saturn.job.console.utils.ExecutorNodePath;
import com.vip.saturn.job.console.utils.JobNodePath;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MarathonServiceImpl
implements MarathonService {
    private static final Logger log = LoggerFactory.getLogger(MarathonServiceImpl.class);
    @Resource
    private RegistryCenterService registryCenterService;
    @Resource
    private JobService jobService;
    @Resource
    private SystemConfigService systemConfigService;

    @Override
    public ContainerToken getContainerToken(String namespace) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        String dcosConfigTokenNodePath = ContainerNodePath.getDcosConfigTokenNodePath();
        String data = curatorFrameworkOp.getData(dcosConfigTokenNodePath);
        return (ContainerToken)JSON.parseObject((String)data, ContainerToken.class);
    }

    @Override
    public void saveContainerToken(String namespace, ContainerToken containerToken) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        String dcosConfigTokenNodePath = ContainerNodePath.getDcosConfigTokenNodePath();
        try {
            List containerScaleJobs;
            List containerScaleJobs2;
            HashMap<String, List> allContainerScaleJobs = new HashMap<String, List>();
            List<String> tasks = this.getTasks(curatorFrameworkOp);
            for (String task : tasks) {
                containerScaleJobs2 = this.getContainerScaleJobs(task, curatorFrameworkOp);
                allContainerScaleJobs.put(task, containerScaleJobs2);
            }
            for (Map.Entry next : allContainerScaleJobs.entrySet()) {
                containerScaleJobs2 = (List)next.getValue();
                for (ContainerScaleJob containerScaleJob : containerScaleJobs2) {
                    if (!containerScaleJob.getEnabled().booleanValue()) continue;
                    curatorFrameworkOp.update(JobNodePath.getConfigNodePath(containerScaleJob.getContainerScaleJobConfig().getJobName(), "enabled"), "false");
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (Map.Entry next : allContainerScaleJobs.entrySet()) {
                String taskId = (String)next.getKey();
                containerScaleJobs = (List)next.getValue();
                for (ContainerScaleJob containerScaleJob : containerScaleJobs) {
                    String jobName = containerScaleJob.getContainerScaleJobConfig().getJobName();
                    Integer instances = containerScaleJob.getContainerScaleJobConfig().getInstances();
                    String shardingItemParametersNodePath = JobNodePath.getConfigNodePath(jobName, "shardingItemParameters");
                    String scaleShardingItemParameters = this.getContainerScaleJobShardingItemParameters(containerToken, taskId, instances);
                    curatorFrameworkOp.update(shardingItemParametersNodePath, scaleShardingItemParameters);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (Map.Entry next : allContainerScaleJobs.entrySet()) {
                containerScaleJobs = (List)next.getValue();
                for (ContainerScaleJob containerScaleJob : containerScaleJobs) {
                    if (!containerScaleJob.getEnabled().booleanValue()) continue;
                    curatorFrameworkOp.update(JobNodePath.getConfigNodePath(containerScaleJob.getContainerScaleJobConfig().getJobName(), "enabled"), "true");
                }
            }
            curatorFrameworkOp.update(dcosConfigTokenNodePath, JSON.toJSONString((Object)containerToken));
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SaturnJobConsoleException(e);
        }
    }

    private List<String> getTasks(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        ArrayList<String> tasks = new ArrayList<String>();
        List<String> children = curatorFrameworkOp.getChildren(ContainerNodePath.getDcosTasksNodePath());
        if (children != null) {
            tasks.addAll(children);
        }
        return tasks;
    }

    private List<ContainerScaleJob> getContainerScaleJobs(String task, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) throws SaturnJobConsoleException {
        List<String> jobs;
        ArrayList<ContainerScaleJob> containerScaleJobs = new ArrayList<ContainerScaleJob>();
        String dcosTaskScaleJobsNodePath = ContainerNodePath.getDcosTaskScaleJobsNodePath(task);
        if (curatorFrameworkOp.checkExists(dcosTaskScaleJobsNodePath) && (jobs = curatorFrameworkOp.getChildren(dcosTaskScaleJobsNodePath)) != null) {
            for (String job : jobs) {
                ContainerScaleJob containerScaleJob = this.getContainerScaleJob(curatorFrameworkOp, task, job);
                if (containerScaleJob == null) continue;
                containerScaleJobs.add(containerScaleJob);
            }
        }
        Collections.sort(containerScaleJobs, new Comparator<ContainerScaleJob>(){

            @Override
            public int compare(ContainerScaleJob o1, ContainerScaleJob o2) {
                return o1.getContainerScaleJobConfig().getJobName().compareTo(o2.getContainerScaleJobConfig().getJobName());
            }
        });
        return containerScaleJobs;
    }

    private ContainerScaleJob getContainerScaleJob(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String id, String jobName) throws SaturnJobConsoleException {
        ContainerScaleJob containerScaleJob = null;
        String data = curatorFrameworkOp.getData(ContainerNodePath.getDcosTaskScaleJobNodePath(id, jobName));
        if (data != null) {
            containerScaleJob = new ContainerScaleJob();
            ContainerScaleJobConfig containerScaleJobConfig = (ContainerScaleJobConfig)JSON.parseObject((String)data, ContainerScaleJobConfig.class);
            containerScaleJob.setContainerScaleJobConfig(containerScaleJobConfig);
            String enabledStr = curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(jobName, "enabled"));
            containerScaleJob.setEnabled(Boolean.valueOf(enabledStr));
        }
        return containerScaleJob;
    }

    private String getContainerScaleJobShardingItemParameters(ContainerToken containerToken, String appId, Integer instances) throws SaturnJobConsoleException {
        try {
            String auth = Base64.encodeBase64String((byte[])(containerToken.getUserName() + ":" + containerToken.getPassword()).getBytes("UTF-8"));
            String url = "";
            url = SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI != null && SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI.endsWith("/") ? SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI + "v2/apps/" + appId + "?force=true" : SaturnEnvProperties.VIP_SATURN_DCOS_REST_URI + "/v2/apps/" + appId + "?force=true";
            return "0=curl -X PUT -H \"Content-Type:application/json\" -H \"Authorization:Basic " + auth + "\" --data '{\"instances\":" + instances + "}' " + url;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SaturnJobConsoleException(e);
        }
    }

    @Override
    public List<ContainerVo> getContainerVos(String namespace) throws SaturnJobConsoleException {
        ArrayList<ContainerVo> containerVos = new ArrayList<ContainerVo>();
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        List<String> allUnSystemJobs = this.jobService.getUnSystemJobNames(namespace);
        Map<String, List<String>> taskBindJobNames = this.getTaskBindJobNames(curatorFrameworkOp, allUnSystemJobs);
        ContainerToken containerToken = this.getContainerToken(namespace);
        List<String> tasks = this.getTasks(curatorFrameworkOp);
        Map<String, List<ContainerExecutorVo>> containerExecutors = this.getContainerExecutors(curatorFrameworkOp, allUnSystemJobs);
        if (!tasks.isEmpty()) {
            for (String task : tasks) {
                ContainerVo containerVo = new ContainerVo();
                containerVo.setTaskId(task);
                containerVo.setContainerExecutorVos(containerExecutors.get(task));
                containerVo.setBindingJobNames(this.changeTypeOfBindingJobNames(taskBindJobNames.get(task)));
                containerVo.setContainerStatus(this.changeTypeOfContainerStatus(containerToken, task));
                ContainerConfig containerConfig = (ContainerConfig)JSON.parseObject((String)curatorFrameworkOp.getData(ContainerNodePath.getDcosTaskConfigNodePath(task)), ContainerConfig.class);
                containerVo.setContainerConfig(this.changeTypeOfContainerConfig(containerConfig));
                containerVo.setCreateTime(this.changeTypeOfCreateTime(containerConfig));
                containerVo.setContainerScaleJobVos(this.getContainerScaleJobVos(namespace, task, curatorFrameworkOp));
                containerVo.setInstancesConfigured(String.valueOf(containerConfig.getInstances()));
                containerVos.add(containerVo);
            }
        }
        return containerVos;
    }

    private Map<String, List<String>> getTaskBindJobNames(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, List<String> allUnSystemJobs) throws SaturnJobConsoleException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String job : allUnSystemJobs) {
            String data;
            String preferListNodePath = JobNodePath.getConfigNodePath(job, "preferList");
            if (!curatorFrameworkOp.checkExists(preferListNodePath) || null == (data = curatorFrameworkOp.getData(preferListNodePath))) continue;
            String[] split = data.split(",");
            for (int i = 0; i < split.length; ++i) {
                List taskJobs;
                String tmp = split[i].trim();
                if (!tmp.startsWith("@")) continue;
                String taskId = tmp.substring(1);
                if (!map.containsKey(taskId)) {
                    map.put(taskId, new ArrayList());
                }
                if ((taskJobs = (List)map.get(taskId)).contains(job)) continue;
                taskJobs.add(job);
            }
        }
        return map;
    }

    private void handleContainerExecutorsFromZK(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, Map<String, List<ContainerExecutorVo>> containerExecutors) {
        List<String> executors;
        if (curatorFrameworkOp.checkExists(ExecutorNodePath.getExecutorNodePath()) && (executors = curatorFrameworkOp.getChildren(ExecutorNodePath.getExecutorNodePath())) != null) {
            for (String executor : executors) {
                String task;
                String executorTaskNodePath = ExecutorNodePath.getExecutorTaskNodePath(executor);
                if (!curatorFrameworkOp.checkExists(executorTaskNodePath) || (task = curatorFrameworkOp.getData(executorTaskNodePath)) == null) continue;
                if (!containerExecutors.containsKey(task)) {
                    containerExecutors.put(task, new ArrayList());
                }
                ContainerExecutorVo containerExecutorVo = new ContainerExecutorVo();
                containerExecutorVo.setExecutorName(executor);
                String executorIpNodePath = ExecutorNodePath.getExecutorIpNodePath(executor);
                if (curatorFrameworkOp.checkExists(executorIpNodePath)) {
                    String executorIp = curatorFrameworkOp.getData(executorIpNodePath);
                    containerExecutorVo.setIp(executorIp);
                }
                containerExecutors.get(task).add(containerExecutorVo);
            }
        }
    }

    private Map<String, List<ContainerExecutorVo>> getContainerExecutors(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, List<String> allUnSystemJobs) {
        HashMap<String, List<ContainerExecutorVo>> containerExecutors = new HashMap<String, List<ContainerExecutorVo>>();
        this.handleContainerExecutorsFromZK(curatorFrameworkOp, containerExecutors);
        for (String job : allUnSystemJobs) {
            Collection values = containerExecutors.values();
            if (values == null) continue;
            for (List value : values) {
                if (value == null) continue;
                for (ContainerExecutorVo containerExecutorVo : value) {
                    Boolean isRunning;
                    String sharding;
                    String jobServerShardingNodePath = JobNodePath.getServerNodePath(job, containerExecutorVo.getExecutorName(), "sharding");
                    if (!curatorFrameworkOp.checkExists(jobServerShardingNodePath) || (sharding = curatorFrameworkOp.getData(jobServerShardingNodePath)) == null || sharding.trim().length() == 0 || !(isRunning = Boolean.valueOf(this.isRunningOrEnabled(curatorFrameworkOp, job, sharding))).booleanValue()) continue;
                    String runningJobNames = containerExecutorVo.getRunningJobNames();
                    if (runningJobNames == null) {
                        containerExecutorVo.setRunningJobNames(job);
                        continue;
                    }
                    containerExecutorVo.setRunningJobNames(runningJobNames + ",<br/>" + job);
                }
            }
        }
        return containerExecutors;
    }

    private boolean isRunningOrEnabled(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String job, String sharding) {
        String enabledNodePath;
        String[] split;
        boolean isRunning = false;
        for (String tmp : split = sharding.split(",")) {
            String runningNodePath = JobNodePath.getExecutionNodePath(job, tmp.trim(), "running");
            if (!curatorFrameworkOp.checkExists(runningNodePath)) continue;
            isRunning = true;
            break;
        }
        if (!isRunning && Boolean.parseBoolean(curatorFrameworkOp.getData(enabledNodePath = JobNodePath.getConfigNodePath(job, "enabled")))) {
            isRunning = true;
        }
        return isRunning;
    }

    private String changeTypeOfBindingJobNames(List<String> bindingJobNames) {
        String result = "";
        if (bindingJobNames != null) {
            int size = bindingJobNames.size();
            for (int i = 0; i < size; ++i) {
                result = result + bindingJobNames.get(i);
                if (i >= size - 1) continue;
                result = result + ",<br/>";
            }
        }
        return result;
    }

    private String changeTypeOfContainerStatus(ContainerToken containerToken, String task) {
        ContainerStatus containerStatus = null;
        String errorMessage = "";
        try {
            containerStatus = MarathonRestClient.getContainerStatus(containerToken.getUserName(), containerToken.getPassword(), task);
        }
        catch (SaturnJobConsoleException e) {
            log.info("get status error, cause of: {}", (Throwable)e);
            errorMessage = "<font color='red'>get task status error, message is: " + StringEscapeUtils.escapeHtml4((String)e.getMessage()) + "</font>";
        }
        String total_count = containerStatus == null || containerStatus.getTotalCount() == null ? "-" : String.valueOf(containerStatus.getTotalCount());
        String healthy_count = containerStatus == null || containerStatus.getHealthyCount() == null ? "-" : String.valueOf(containerStatus.getHealthyCount());
        String unhealthy_count = containerStatus == null || containerStatus.getUnhealthyCount() == null ? "-" : String.valueOf(containerStatus.getUnhealthyCount());
        String staged_count = containerStatus == null || containerStatus.getStagedCount() == null ? "-" : String.valueOf(containerStatus.getStagedCount());
        String running_count = containerStatus == null || containerStatus.getRunningCount() == null ? "-" : String.valueOf(containerStatus.getRunningCount());
        return String.format("\u5f53\u524d\u5b9e\u4f8b\u603b\u6570\uff1a%s<br/><br/>\u5065\u5eb7\u5b9e\u4f8b\u6570\uff1a%s<br/>\u975e\u5065\u5eb7\u5b9e\u4f8b\u6570\uff1a%s<br/><br/>staged\u5b9e\u4f8b\u6570\uff1a%s<br/>running\u5b9e\u4f8b\u6570\uff1a%s<br/>%s", total_count, healthy_count, unhealthy_count, staged_count, running_count, errorMessage);
    }

    private String changeTypeOfContainerConfig(ContainerConfig containerConfig) {
        String constraints = containerConfig.getConstraints() == null ? "-" : JSON.toJSONString(containerConfig.getConstraints());
        String env = containerConfig.getEnv() == null ? "-" : JSON.toJSONString(containerConfig.getEnv());
        String privileged = containerConfig.getPrivileged() == null ? "-" : String.valueOf(containerConfig.getPrivileged());
        String force_pull_image = containerConfig.getForcePullImage() == null ? "-" : String.valueOf(containerConfig.getForcePullImage());
        String volumes = containerConfig.getVolumes() == null ? "-" : JSON.toJSONString(containerConfig.getVolumes());
        String cmd = containerConfig.getCmd() == null ? "-" : containerConfig.getCmd();
        return String.format("\u914d\u7f6e\u7684\u5b9e\u4f8b\u6570\uff1a%s<br/>CPU\uff1a%s\u6838<br/>\u5185\u5b58\uff1a%sM<br/>\u955c\u50cf\uff1a%s<br/>\u7ea6\u675f\u6807\u8bc6\uff1a%s<br/>\u73af\u5883\u53d8\u91cf\uff1a%s<br/>\u662f\u5426\u4f7f\u7528\u7279\u6743\u6a21\u5f0f\uff1a%s<br/>\u662f\u5426\u5f3a\u5236\u62c9\u955c\u50cf\uff1a%s<br/>\u5bb9\u5668\u4e0e\u5bbf\u4e3b\u673a\u7684\u76ee\u5f55\u6620\u5c04\uff1a%s<br/>CMD\uff1a%s", containerConfig.getInstances(), containerConfig.getCpus(), containerConfig.getMem(), containerConfig.getImage(), constraints, env, privileged, force_pull_image, volumes, cmd);
    }

    private String changeTypeOfCreateTime(ContainerConfig containerConfig) {
        Long createTime = containerConfig.getCreateTime();
        if (createTime != null) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(createTime);
        }
        return null;
    }

    private List<ContainerScaleJobVo> getContainerScaleJobVos(String namespace, String taskId, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) throws SaturnJobConsoleException {
        List<String> jobs;
        ArrayList<ContainerScaleJobVo> containerScaleJobVos = new ArrayList<ContainerScaleJobVo>();
        String dcosTaskScaleJobsNodePath = ContainerNodePath.getDcosTaskScaleJobsNodePath(taskId);
        if (curatorFrameworkOp.checkExists(dcosTaskScaleJobsNodePath) && (jobs = curatorFrameworkOp.getChildren(dcosTaskScaleJobsNodePath)) != null) {
            for (String job : jobs) {
                ContainerScaleJobVo containerScaleJobVo = this.getContainerScaleJobVo(namespace, taskId, job);
                if (containerScaleJobVo == null) continue;
                containerScaleJobVos.add(containerScaleJobVo);
            }
        }
        Collections.sort(containerScaleJobVos, new Comparator<ContainerScaleJobVo>(){

            @Override
            public int compare(ContainerScaleJobVo o1, ContainerScaleJobVo o2) {
                return o1.getJobName().compareTo(o2.getJobName());
            }
        });
        return containerScaleJobVos;
    }

    @Override
    public void checkContainerTokenNotNull(String namespace, ContainerToken containerToken) throws SaturnJobConsoleException {
        if (containerToken == null) {
            throw new SaturnJobConsoleException("Please input userName and password");
        }
        if (containerToken.getUserName() == null) {
            throw new SaturnJobConsoleException("Please input userName");
        }
        if (containerToken.getPassword() == null) {
            throw new SaturnJobConsoleException("Please input password");
        }
    }

    @Override
    public void saveOrUpdateContainerTokenIfNecessary(String namespace, ContainerToken containerToken) throws SaturnJobConsoleException {
        ContainerToken containerTokenOld = this.getContainerToken(namespace);
        boolean same = containerToken.equals(containerTokenOld);
        if (!same) {
            this.saveContainerToken(namespace, containerToken);
        }
    }

    @Override
    public void addContainer(String namespace, ContainerConfig containerConfig) throws SaturnJobConsoleException {
        String taskId;
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        if (curatorFrameworkOp.checkExists(ContainerNodePath.getDcosTaskIdNodePath(taskId = containerConfig.getTaskId()))) {
            throw new SaturnJobConsoleException("The taskId already exists");
        }
        if (containerConfig.getEnv() == null) {
            containerConfig.setEnv(new HashMap<String, String>());
        }
        containerConfig.getEnv().put(SaturnEnvProperties.NAME_VIP_SATURN_DCOS_TASK, taskId);
        if (!containerConfig.getEnv().containsKey(SaturnEnvProperties.NAME_VIP_SATURN_EXECUTOR_CLEAN)) {
            containerConfig.getEnv().put(SaturnEnvProperties.NAME_VIP_SATURN_EXECUTOR_CLEAN, "true");
        }
        ContainerToken containerToken = this.getContainerToken(namespace);
        MarathonRestClient.deploy(containerToken.getUserName(), containerToken.getPassword(), containerConfig);
        containerConfig.setCreateTime(System.currentTimeMillis());
        this.replaceEnvSensitiveParams(containerConfig);
        curatorFrameworkOp.update(ContainerNodePath.getDcosTaskConfigNodePath(taskId), JSON.toJSONString((Object)containerConfig));
    }

    private void replaceEnvSensitiveParams(ContainerConfig containerConfig) {
        String sensitiveParams = this.systemConfigService.getValue("CONTAINER_SENSITIVE_PARAMS");
        List<String> sensitiveWords = this.extractSensitiveWords(sensitiveParams);
        if (containerConfig.getEnv() != null) {
            Map<String, String> env = containerConfig.getEnv();
            for (String sensitiveWord : sensitiveWords) {
                if (!env.containsKey(sensitiveWord)) continue;
                env.put(sensitiveWord, "******");
            }
        }
    }

    private List<String> extractSensitiveWords(String sensitiveParams) {
        String[] split;
        ArrayList<String> words = new ArrayList<String>();
        if (sensitiveParams != null && sensitiveParams.trim().length() > 0 && (split = sensitiveParams.split(",")) != null) {
            for (String s : split) {
                String tmp = s.trim();
                if (tmp.length() <= 0) continue;
                words.add(tmp);
            }
        }
        return words;
    }

    @Override
    public void updateContainerInstances(String namespace, String taskId, int instances) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        String dcosTaskIdNodePath = ContainerNodePath.getDcosTaskIdNodePath(taskId);
        String dcosTaskConfigNodePath = ContainerNodePath.getDcosTaskConfigNodePath(taskId);
        if (!curatorFrameworkOp.checkExists(dcosTaskIdNodePath)) {
            throw new SaturnJobConsoleException("The taskId already exists");
        }
        String taskConfigJson = curatorFrameworkOp.getData(dcosTaskConfigNodePath);
        ContainerConfig containerConfig = (ContainerConfig)JSON.parseObject((String)taskConfigJson, ContainerConfig.class);
        ContainerToken containerToken = this.getContainerToken(namespace);
        MarathonRestClient.scale(containerToken.getUserName(), containerToken.getPassword(), taskId, instances);
        containerConfig.setInstances(instances);
        curatorFrameworkOp.update(dcosTaskConfigNodePath, JSON.toJSONString((Object)containerConfig));
    }

    @Override
    public void removeContainer(String namespace, String taskId) throws SaturnJobConsoleException {
        String dcosTaskIdNodePath;
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        if (!curatorFrameworkOp.checkExists(dcosTaskIdNodePath = ContainerNodePath.getDcosTaskIdNodePath(taskId))) {
            throw new SaturnJobConsoleException("The taskId already exists");
        }
        List<ContainerScaleJobVo> containerScaleJobVos = this.getContainerScaleJobVos(namespace, taskId, curatorFrameworkOp);
        List<String> allUnSystemJobs = this.jobService.getUnSystemJobNames(namespace);
        for (String job : allUnSystemJobs) {
            String[] split;
            String preferList;
            String preferListNodePath = JobNodePath.getConfigNodePath(job, "preferList");
            if (!curatorFrameworkOp.checkExists(preferListNodePath) || null == (preferList = curatorFrameworkOp.getData(preferListNodePath))) continue;
            for (String tmp : split = preferList.trim().split(",")) {
                if (!tmp.trim().equals("@" + taskId)) continue;
                throw new SaturnJobConsoleException("Cannot destroy the container, because it's binding a job");
            }
        }
        for (ContainerScaleJobVo containerScaleJobVo : containerScaleJobVos) {
            this.deleteContainerScaleJob(namespace, taskId, containerScaleJobVo.getJobName());
        }
        ContainerToken containerToken = this.getContainerToken(namespace);
        MarathonRestClient.destroy(containerToken.getUserName(), containerToken.getPassword(), taskId);
        curatorFrameworkOp.deleteRecursive(dcosTaskIdNodePath);
    }

    @Override
    public String getContainerDetail(String namespace, String taskId) throws SaturnJobConsoleException {
        String dcosTaskIdNodePath;
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        if (!curatorFrameworkOp.checkExists(dcosTaskIdNodePath = ContainerNodePath.getDcosTaskIdNodePath(taskId))) {
            throw new SaturnJobConsoleException("The taskId already exists");
        }
        ContainerToken containerToken = this.getContainerToken(namespace);
        return MarathonRestClient.info(containerToken.getUserName(), containerToken.getPassword(), taskId);
    }

    @Override
    public String getRegistryCatalog(String namespace) throws SaturnJobConsoleException {
        return MarathonRestClient.getRegistryCatalog();
    }

    @Override
    public String getRegistryRepositoryTags(String namespace, String repository) throws SaturnJobConsoleException {
        return MarathonRestClient.getRegistryRepositoriesTagsList(repository);
    }

    @Override
    public void addContainerScaleJob(String namespace, String taskId, String jobDesc, int instances, String timeZone, String cron) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        String jobName = "system_scale_" + System.currentTimeMillis();
        ContainerToken containerToken = this.getContainerToken(namespace);
        JobConfig jobConfig = new JobConfig();
        jobConfig.setJobName(jobName);
        jobConfig.setDescription(jobDesc);
        jobConfig.setTimeZone(timeZone);
        jobConfig.setCron(cron);
        jobConfig.setJobMode("system_scale");
        jobConfig.setJobType(JobType.SHELL_JOB.name());
        jobConfig.setPreferList("@" + taskId);
        jobConfig.setShardingTotalCount(1);
        jobConfig.setShardingItemParameters(this.getContainerScaleJobShardingItemParameters(containerToken, taskId, instances));
        jobConfig.setUseDispreferList(false);
        jobConfig.setTimeout4AlarmSeconds(30);
        jobConfig.setTimeoutSeconds(30);
        jobConfig.setJobParameter("");
        jobConfig.setQueueName("");
        jobConfig.setChannelName("");
        jobConfig.setPausePeriodDate("");
        jobConfig.setPausePeriodTime("");
        this.jobService.addJob(namespace, jobConfig, "");
        ContainerScaleJobConfig containerScaleJobConfig = new ContainerScaleJobConfig();
        containerScaleJobConfig.setJobName(jobName);
        containerScaleJobConfig.setJobDesc(jobDesc);
        containerScaleJobConfig.setInstances(instances);
        containerScaleJobConfig.setTimeZone(timeZone);
        containerScaleJobConfig.setCron(cron);
        try {
            String containerScaleJobStr = JSON.toJSONString((Object)containerScaleJobConfig);
            String dcosTaskScaleJobNodePath = ContainerNodePath.getDcosTaskScaleJobNodePath(taskId, jobName);
            curatorFrameworkOp.fillJobNodeIfNotExist(dcosTaskScaleJobNodePath, containerScaleJobStr);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SaturnJobConsoleException(e.getMessage(), e);
        }
    }

    @Override
    public ContainerScaleJobVo getContainerScaleJobVo(String namespace, String taskId, String jobName) throws SaturnJobConsoleException {
        ContainerScaleJobVo containerScaleJobVo = null;
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        try {
            ContainerScaleJob containerScaleJob = this.getContainerScaleJob(curatorFrameworkOp, taskId, jobName);
            ContainerScaleJobConfig containerScaleJobConfig = containerScaleJob.getContainerScaleJobConfig();
            containerScaleJobVo = new ContainerScaleJobVo();
            containerScaleJobVo.setJobName(containerScaleJobConfig.getJobName());
            containerScaleJobVo.setJobDesc(containerScaleJobConfig.getJobDesc());
            if (containerScaleJobConfig.getInstances() != null) {
                containerScaleJobVo.setInstances(containerScaleJobConfig.getInstances().toString());
            }
            if (containerScaleJobConfig.getTimeZone() == null) {
                containerScaleJobVo.setTimeZone("Asia/Shanghai");
            } else {
                containerScaleJobVo.setTimeZone(containerScaleJobConfig.getTimeZone());
            }
            containerScaleJobVo.setCron(containerScaleJobConfig.getCron());
            containerScaleJobVo.setEnabled(containerScaleJob.getEnabled().toString());
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SaturnJobConsoleException(e);
        }
        return containerScaleJobVo;
    }

    @Override
    public void enableContainerScaleJob(String namespace, String jobName, boolean flag) throws SaturnJobConsoleException {
        String enabledNodePath;
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        String enabledStr = curatorFrameworkOp.getData(enabledNodePath = JobNodePath.getConfigNodePath(jobName, "enabled"));
        Boolean enabled = Boolean.valueOf(enabledStr);
        if (enabled == flag) {
            throw new SaturnJobConsoleException("The job is already " + (flag ? "enabled" : "disabled"));
        }
        curatorFrameworkOp.update(enabledNodePath, flag);
    }

    @Override
    public void deleteContainerScaleJob(String namespace, String taskId, String jobName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        try {
            String jobNodePath = JobNodePath.getJobNodePath(jobName);
            if (curatorFrameworkOp.checkExists(jobNodePath)) {
                String enabledNodePath = JobNodePath.getConfigNodePath(jobName, "enabled");
                String enabledStr = curatorFrameworkOp.getData(enabledNodePath);
                Boolean enabled = Boolean.valueOf(enabledStr);
                if (enabled.booleanValue()) {
                    curatorFrameworkOp.update(enabledNodePath, false);
                }
                for (long waitStopTime = 5000L; waitStopTime > 0L; waitStopTime -= 100L) {
                    Thread.sleep(100L);
                    JobStatus jobStatus = this.jobService.getJobStatus(namespace, jobName);
                    if (!JobStatus.STOPPED.equals((Object)jobStatus)) continue;
                    this.jobService.removeJob(namespace, jobName);
                    this.deleteScaleJobNodePath(curatorFrameworkOp, taskId, jobName);
                    return;
                }
                throw new SaturnJobConsoleException("The job is not stopped, cannot be deleted, please retry later");
            }
            this.deleteScaleJobNodePath(curatorFrameworkOp, taskId, jobName);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SaturnJobConsoleException(e.getMessage(), e);
        }
    }

    private void deleteScaleJobNodePath(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String taskId, String jobName) {
        String dcosTaskScaleJobNodePath = ContainerNodePath.getDcosTaskScaleJobNodePath(taskId, jobName);
        curatorFrameworkOp.deleteRecursive(dcosTaskScaleJobNodePath);
    }

    @Override
    public int getContainerRunningInstances(String namespace, String taskId) throws SaturnJobConsoleException {
        ContainerToken containerToken = this.getContainerToken(namespace);
        return MarathonRestClient.count(containerToken.getUserName(), containerToken.getPassword(), taskId);
    }
}

