/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl.statistics;

import com.alibaba.fastjson.JSON;
import com.vip.saturn.job.console.domain.AbnormalJob;
import com.vip.saturn.job.console.domain.DomainStatistics;
import com.vip.saturn.job.console.domain.ExecutorStatistics;
import com.vip.saturn.job.console.domain.JobStatistics;
import com.vip.saturn.job.console.domain.Timeout4AlarmJob;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.domain.ZkStatistics;
import com.vip.saturn.job.console.mybatis.entity.SaturnStatistics;
import com.vip.saturn.job.console.mybatis.service.SaturnStatisticsService;
import com.vip.saturn.job.console.service.helper.DashboardServiceHelper;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.StatisticsModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsPersistence {
    private static final Logger log = LoggerFactory.getLogger(StatisticsPersistence.class);
    @Resource
    private SaturnStatisticsService saturnStatisticsService;

    public void persist(StatisticsModel statisticsModel, ZkCluster zkCluster) {
        List<JobStatistics> jobList = statisticsModel.getJobStatisticsAnalyzer().getJobList();
        List<ExecutorStatistics> executorList = statisticsModel.getExecutorInfoAnalyzer().getExecutorList();
        this.saveOrUpdateDomainProcessCount(new ZkStatistics(statisticsModel.getZkClusterDailyCountAnalyzer().getTotalCount(), statisticsModel.getZkClusterDailyCountAnalyzer().getErrorCount()), zkCluster.getZkAddr());
        this.saveOrUpdateTop10FailDomain(statisticsModel.getDomainStatisticsAnalyzer().getDomainList(), zkCluster.getZkAddr());
        this.saveOrUpdateTop10UnstableDomain(statisticsModel.getDomainStatisticsAnalyzer().getDomainList(), zkCluster.getZkAddr());
        this.saveOrUpdateTop10FailExecutor(executorList, zkCluster.getZkAddr());
        this.saveOrUpdateTop10FailJob(jobList, zkCluster.getZkAddr());
        this.saveOrUpdateTop10ActiveJob(jobList, zkCluster.getZkAddr());
        this.saveOrUpdateTop10LoadJob(jobList, zkCluster.getZkAddr());
        this.saveOrUpdateTop10LoadExecutor(executorList, zkCluster.getZkAddr());
        this.saveOrUpdateAbnormalJob(statisticsModel.getOutdatedNoRunningJobAnalyzer().getOutdatedNoRunningJobs(), zkCluster.getZkAddr());
        this.saveOrUpdateTimeout4AlarmJob(statisticsModel.getTimeout4AlarmJobAnalyzer().getTimeout4AlarmJobList(), zkCluster.getZkAddr());
        this.saveOrUpdateUnableFailoverJob(statisticsModel.getUnableFailoverJobAnalyzer().getUnableFailoverJobList(), zkCluster.getZkAddr());
        this.saveOrUpdateVersionDomainNumber(statisticsModel.getExecutorInfoAnalyzer().getVersionDomainNumber(), zkCluster.getZkAddr());
        this.saveOrUpdateVersionExecutorNumber(statisticsModel.getExecutorInfoAnalyzer().getVersionExecutorNumber(), zkCluster.getZkAddr());
        this.saveOrUpdateJobRankDistribution(jobList, zkCluster.getZkAddr());
        this.saveOrUpdateExecutorInDockerCount(statisticsModel.getExecutorInfoAnalyzer().getExeInDocker(), zkCluster.getZkAddr());
        this.saveOrUpdateExecutorNotInDockerCount(statisticsModel.getExecutorInfoAnalyzer().getExeNotInDocker(), zkCluster.getZkAddr());
        this.saveOrUpdateJobCount(jobList.size(), zkCluster.getZkAddr());
    }

    private void saveOrUpdateJobCount(int jobCount, String zkAddr) {
        try {
            String jobCountString = JSON.toJSONString((Object)jobCount);
            SaturnStatistics jobCountFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("job_count", zkAddr);
            if (jobCountFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("job_count", zkAddr, jobCountString);
                this.saturnStatisticsService.create(ss);
            } else {
                jobCountFromDB.setResult(jobCountString);
                this.saturnStatisticsService.updateByPrimaryKey(jobCountFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateExecutorNotInDockerCount(int exeNotInDocker, String zkAddr) {
        try {
            String exeNotInDockerString = JSON.toJSONString((Object)exeNotInDocker);
            SaturnStatistics exeNotInDockerFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("executor_not_in_docker_count", zkAddr);
            if (exeNotInDockerFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("executor_not_in_docker_count", zkAddr, exeNotInDockerString);
                this.saturnStatisticsService.create(ss);
            } else {
                exeNotInDockerFromDB.setResult(exeNotInDockerString);
                this.saturnStatisticsService.updateByPrimaryKey(exeNotInDockerFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateExecutorInDockerCount(int exeInDocker, String zkAddr) {
        try {
            String exeInDockerString = JSON.toJSONString((Object)exeInDocker);
            SaturnStatistics exeInDockerFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("executor_in_docker_count", zkAddr);
            if (exeInDockerFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("executor_in_docker_count", zkAddr, exeInDockerString);
                this.saturnStatisticsService.create(ss);
            } else {
                exeInDockerFromDB.setResult(exeInDockerString);
                this.saturnStatisticsService.updateByPrimaryKey(exeInDockerFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateJobRankDistribution(List<JobStatistics> jobList, String zkBsKey) {
        try {
            HashMap<Integer, Integer> jobDegreeCountMap = new HashMap<Integer, Integer>();
            for (JobStatistics jobStatistics : jobList) {
                int jobDegree = jobStatistics.getJobDegree();
                Integer count = (Integer)jobDegreeCountMap.get(jobDegree);
                jobDegreeCountMap.put(jobDegree, count == null ? 1 : count + 1);
            }
            String jobDegreeMapString = JSON.toJSONString(jobDegreeCountMap);
            SaturnStatistics jobDegreeMapFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("job_rank_distribution", zkBsKey);
            if (jobDegreeMapFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("job_rank_distribution", zkBsKey, jobDegreeMapString);
                this.saturnStatisticsService.create(ss);
            } else {
                jobDegreeMapFromDB.setResult(jobDegreeMapString);
                this.saturnStatisticsService.updateByPrimaryKey(jobDegreeMapFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateTop10FailExecutor(List<ExecutorStatistics> executorList, String zkAddr) {
        try {
            executorList = DashboardServiceHelper.sortExecutorByFailureRate(executorList);
            List<ExecutorStatistics> top10FailExecutor = executorList.subList(0, executorList.size() > 9 ? 10 : executorList.size());
            String top10FailExecutorJsonString = JSON.toJSONString(top10FailExecutor);
            SaturnStatistics top10FailExecutorFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_fail_executor", zkAddr);
            if (top10FailExecutorFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("top_10_fail_executor", zkAddr, top10FailExecutorJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                top10FailExecutorFromDB.setResult(top10FailExecutorJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(top10FailExecutorFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateTop10FailDomain(List<DomainStatistics> domainList, String zkAddr) {
        try {
            domainList = DashboardServiceHelper.sortDomainByAllTimeFailureRate(domainList);
            List<DomainStatistics> top10FailDomainList = domainList.subList(0, domainList.size() > 9 ? 10 : domainList.size());
            String top10FailDomainJsonString = JSON.toJSONString(top10FailDomainList);
            SaturnStatistics top10FailDomainFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_fail_domain", zkAddr);
            if (top10FailDomainFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("top_10_fail_domain", zkAddr, top10FailDomainJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                top10FailDomainFromDB.setResult(top10FailDomainJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(top10FailDomainFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateTop10UnstableDomain(List<DomainStatistics> domainList, String zkAddr) {
        try {
            domainList = DashboardServiceHelper.sortDomainByShardingCount(domainList);
            List<DomainStatistics> top10UnstableDomain = domainList.subList(0, domainList.size() > 9 ? 10 : domainList.size());
            String top10UnstableDomainJsonString = JSON.toJSONString(top10UnstableDomain);
            SaturnStatistics top10UnstableDomainFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_unstable_domain", zkAddr);
            if (top10UnstableDomainFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("top_10_unstable_domain", zkAddr, top10UnstableDomainJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                top10UnstableDomainFromDB.setResult(top10UnstableDomainJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(top10UnstableDomainFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateTop10FailJob(List<JobStatistics> jobList, String zkAddr) {
        try {
            jobList = DashboardServiceHelper.sortJobByAllTimeFailureRate(jobList);
            List<JobStatistics> top10FailJob = jobList.subList(0, jobList.size() > 9 ? 10 : jobList.size());
            String top10FailJobJsonString = JSON.toJSONString(top10FailJob);
            SaturnStatistics top10FailJobFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_fail_job", zkAddr);
            if (top10FailJobFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("top_10_fail_job", zkAddr, top10FailJobJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                top10FailJobFromDB.setResult(top10FailJobJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(top10FailJobFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateTop10ActiveJob(List<JobStatistics> jobList, String zkAddr) {
        try {
            jobList = DashboardServiceHelper.sortJobByDayProcessCount(jobList);
            List<JobStatistics> top10ActiveJob = jobList.subList(0, jobList.size() > 9 ? 10 : jobList.size());
            String top10ActiveJobJsonString = JSON.toJSONString(top10ActiveJob);
            SaturnStatistics top10ActiveJobFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_active_job", zkAddr);
            if (top10ActiveJobFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("top_10_active_job", zkAddr, top10ActiveJobJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                top10ActiveJobFromDB.setResult(top10ActiveJobJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(top10ActiveJobFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateTop10LoadJob(List<JobStatistics> jobList, String zkAddr) {
        try {
            jobList = DashboardServiceHelper.sortJobByLoadLevel(jobList);
            List<JobStatistics> top10LoadJob = jobList.subList(0, jobList.size() > 9 ? 10 : jobList.size());
            String top10LoadJobJsonString = JSON.toJSONString(top10LoadJob);
            SaturnStatistics top10LoadJobFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_load_job", zkAddr);
            if (top10LoadJobFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("top_10_load_job", zkAddr, top10LoadJobJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                top10LoadJobFromDB.setResult(top10LoadJobJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(top10LoadJobFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateTop10LoadExecutor(List<ExecutorStatistics> executorList, String zkAddr) {
        try {
            executorList = DashboardServiceHelper.sortExecutorByLoadLevel(executorList);
            List<ExecutorStatistics> top10LoadExecutor = executorList.subList(0, executorList.size() > 9 ? 10 : executorList.size());
            String top10LoadExecutorJsonString = JSON.toJSONString(top10LoadExecutor);
            SaturnStatistics top10LoadExecutorFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_load_executor", zkAddr);
            if (top10LoadExecutorFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("top_10_load_executor", zkAddr, top10LoadExecutorJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                top10LoadExecutorFromDB.setResult(top10LoadExecutorJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(top10LoadExecutorFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateDomainProcessCount(ZkStatistics zks, String zkAddr) {
        try {
            String domainListJsonString = JSON.toJSONString((Object)zks);
            SaturnStatistics domainProcessCountFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("domain_process_count_of_the_day", zkAddr);
            if (domainProcessCountFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("domain_process_count_of_the_day", zkAddr, domainListJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                domainProcessCountFromDB.setResult(domainListJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(domainProcessCountFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateAbnormalJob(List<AbnormalJob> unnormalJobList, String zkAddr) {
        try {
            unnormalJobList = DashboardServiceHelper.sortUnnormaoJobByTimeDesc(unnormalJobList);
            SaturnStatistics unnormalJobFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("unnormal_job", zkAddr);
            if (unnormalJobFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("unnormal_job", zkAddr, JSON.toJSONString(unnormalJobList));
                this.saturnStatisticsService.create(ss);
            } else {
                List oldUnnormalJobList = JSON.parseArray((String)unnormalJobFromDB.getResult(), AbnormalJob.class);
                this.dealWithReadStatus(unnormalJobList, oldUnnormalJobList);
                unnormalJobFromDB.setResult(JSON.toJSONString(unnormalJobList));
                this.saturnStatisticsService.updateByPrimaryKey(unnormalJobFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void dealWithReadStatus(List<AbnormalJob> unnormalJobList, List<AbnormalJob> oldUnnormalJobList) {
        if (oldUnnormalJobList == null || oldUnnormalJobList.isEmpty()) {
            return;
        }
        for (AbnormalJob example : unnormalJobList) {
            AbnormalJob equalOld = DashboardServiceHelper.findEqualAbnormalJob(example, oldUnnormalJobList);
            if (equalOld == null) continue;
            example.setRead(equalOld.isRead());
        }
    }

    private void saveOrUpdateTimeout4AlarmJob(List<Timeout4AlarmJob> timeout4AlarmJobList, String zkAddr) {
        try {
            String timeout4AlarmJobJsonString = JSON.toJSONString(timeout4AlarmJobList);
            SaturnStatistics timeout4AlarmJobFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("timeout_4_alarm_job", zkAddr);
            if (timeout4AlarmJobFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("timeout_4_alarm_job", zkAddr, timeout4AlarmJobJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                List oldTimeout4AlarmJobs = JSON.parseArray((String)timeout4AlarmJobFromDB.getResult(), Timeout4AlarmJob.class);
                this.dealWithReadStatus4Timeout4AlarmJob(timeout4AlarmJobList, oldTimeout4AlarmJobs);
                timeout4AlarmJobFromDB.setResult(JSON.toJSONString(timeout4AlarmJobList));
                this.saturnStatisticsService.updateByPrimaryKey(timeout4AlarmJobFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void dealWithReadStatus4Timeout4AlarmJob(List<Timeout4AlarmJob> jobList, List<Timeout4AlarmJob> oldJobList) {
        if (oldJobList == null || oldJobList.isEmpty()) {
            return;
        }
        for (Timeout4AlarmJob job : jobList) {
            Timeout4AlarmJob oldJob = DashboardServiceHelper.findEqualTimeout4AlarmJob(job, oldJobList);
            if (oldJob == null) continue;
            job.setRead(oldJob.isRead());
        }
    }

    private void saveOrUpdateUnableFailoverJob(List<AbnormalJob> unableFailoverJobList, String zkAddr) {
        try {
            String unableFailoverJobJsonString = JSON.toJSONString(unableFailoverJobList);
            SaturnStatistics unableFailoverJobFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("unable_failover_job", zkAddr);
            if (unableFailoverJobFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("unable_failover_job", zkAddr, unableFailoverJobJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                unableFailoverJobFromDB.setResult(unableFailoverJobJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(unableFailoverJobFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateVersionDomainNumber(Map<String, Long> versionDomainNumber, String zkAddr) {
        try {
            String versionDomainNumberJsonString = JSON.toJSONString(versionDomainNumber);
            SaturnStatistics versionDomainNumberFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("version_domain_number", zkAddr);
            if (versionDomainNumberFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("version_domain_number", zkAddr, versionDomainNumberJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                versionDomainNumberFromDB.setResult(versionDomainNumberJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(versionDomainNumberFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveOrUpdateVersionExecutorNumber(Map<String, Long> versionExecutorNumber, String zkAddr) {
        try {
            String versionExecutorNumberJsonString = JSON.toJSONString(versionExecutorNumber);
            SaturnStatistics versionExecutorNumberFromDB = this.saturnStatisticsService.findStatisticsByNameAndZkList("version_executor_number", zkAddr);
            if (versionExecutorNumberFromDB == null) {
                SaturnStatistics ss = new SaturnStatistics("version_executor_number", zkAddr, versionExecutorNumberJsonString);
                this.saturnStatisticsService.create(ss);
            } else {
                versionExecutorNumberFromDB.setResult(versionExecutorNumberJsonString);
                this.saturnStatisticsService.updateByPrimaryKey(versionExecutorNumberFromDB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

