/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl.statistics;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.vip.saturn.job.console.domain.AbnormalJob;
import com.vip.saturn.job.console.domain.AbnormalShardingState;
import com.vip.saturn.job.console.domain.DomainStatistics;
import com.vip.saturn.job.console.domain.JobStatistics;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.domain.Timeout4AlarmJob;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.SaturnStatistics;
import com.vip.saturn.job.console.mybatis.service.SaturnStatisticsService;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.service.StatisticsRefreshService;
import com.vip.saturn.job.console.service.SystemConfigService;
import com.vip.saturn.job.console.service.helper.DashboardConstants;
import com.vip.saturn.job.console.service.helper.ZkClusterMappingUtils;
import com.vip.saturn.job.console.service.impl.statistics.StatisticsPersistence;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.DomainStatisticsAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.ExecutorInfoAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.JobStatisticsAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.OutdatedNoRunningJobAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.StatisticsModel;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.Timeout4AlarmJobAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.UnableFailoverJobAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.ZkClusterDailyCountAnalyzer;
import com.vip.saturn.job.console.utils.ConsoleThreadFactory;
import com.vip.saturn.job.console.utils.JobNodePath;
import com.vip.saturn.job.integrate.service.ReportAlarmService;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsRefreshServiceImpl
implements StatisticsRefreshService {
    private static final Logger log = LoggerFactory.getLogger(StatisticsRefreshServiceImpl.class);
    private static final int CONNECT_TIMEOUT_MS = 10000;
    private static final int SO_TIMEOUT_MS = 180000;
    private static final int STAT_THREAD_NUM = 20;
    private Timer refreshStatisticsTimer;
    private Timer cleanAbnormalShardingCacheTimer;
    private Map<String, AbnormalShardingState> abnormalShardingStateCache = new ConcurrentHashMap<String, AbnormalShardingState>();
    @Resource
    private SaturnStatisticsService saturnStatisticsService;
    @Resource
    private StatisticsPersistence statisticsPersistence;
    @Resource
    private SystemConfigService systemConfigService;
    @Resource
    private RegistryCenterService registryCenterService;
    @Resource
    private JobService jobService;
    @Resource
    private ReportAlarmService reportAlarmService;
    private ExecutorService statExecutorService;

    @PostConstruct
    public void init() {
        this.initStatExecutorService();
        this.startRefreshStatisticsTimer();
        this.startCleanAbnormalShardingCacheTimer();
    }

    @PreDestroy
    public void destroy() {
        if (this.statExecutorService != null) {
            this.statExecutorService.shutdownNow();
        }
        if (this.refreshStatisticsTimer != null) {
            this.refreshStatisticsTimer.cancel();
        }
        if (this.cleanAbnormalShardingCacheTimer != null) {
            this.cleanAbnormalShardingCacheTimer.cancel();
        }
    }

    private void initStatExecutorService() {
        if (this.statExecutorService != null) {
            this.statExecutorService.shutdownNow();
        }
        ThreadPoolExecutor tp = new ThreadPoolExecutor(20, 20, (long)(DashboardConstants.REFRESH_INTERVAL_IN_MINUTE + 1), TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ConsoleThreadFactory("dashboard-statistics-thread", true));
        tp.allowCoreThreadTimeOut(true);
        this.statExecutorService = tp;
    }

    private void startRefreshStatisticsTimer() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    log.info("start refresh statistics on timer");
                    Date start = new Date();
                    Collection<ZkCluster> zkClusterList = StatisticsRefreshServiceImpl.this.registryCenterService.getZkClusterList();
                    if (zkClusterList != null) {
                        for (ZkCluster zkCluster : zkClusterList) {
                            if (zkCluster.isOffline()) {
                                log.info("zkcluster:{} is offline, skip statistics refresh.", (Object)zkCluster.getZkClusterKey());
                                continue;
                            }
                            if (!StatisticsRefreshServiceImpl.this.registryCenterService.isDashboardLeader(zkCluster.getZkClusterKey())) continue;
                            StatisticsRefreshServiceImpl.this.refreshStatistics2DB(zkCluster);
                        }
                    }
                    log.info("end refresh statistics on timer which takes {}ms", (Object)(new Date().getTime() - start.getTime()));
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        };
        this.refreshStatisticsTimer = new Timer("refresh-statistics-to-db-timer", true);
        this.refreshStatisticsTimer.scheduleAtFixedRate(timerTask, 15000L, 60000L * (long)DashboardConstants.REFRESH_INTERVAL_IN_MINUTE);
    }

    private void startCleanAbnormalShardingCacheTimer() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    for (Map.Entry entrySet : StatisticsRefreshServiceImpl.this.abnormalShardingStateCache.entrySet()) {
                        AbnormalShardingState shardingState = (AbnormalShardingState)entrySet.getValue();
                        if (shardingState.getAlertTime() + DashboardConstants.ALLOW_DELAY_MILLIONSECONDS * 2L >= System.currentTimeMillis()) continue;
                        StatisticsRefreshServiceImpl.this.abnormalShardingStateCache.remove(entrySet.getKey());
                        log.info("Clean AbnormalShardingCache with key: {}, alertTime: {}, zkNodeCVersion: {}: ", new Object[]{entrySet.getKey(), shardingState.getAlertTime(), shardingState.getZkNodeCVersion()});
                    }
                }
                catch (Throwable t) {
                    log.error("Clean AbnormalShardingCache error", t);
                }
            }
        };
        this.cleanAbnormalShardingCacheTimer = new Timer("clean-abnormalShardingCache-timer", true);
        this.cleanAbnormalShardingCacheTimer.scheduleAtFixedRate(timerTask, 0L, DashboardConstants.ALLOW_DELAY_MILLIONSECONDS);
    }

    @Override
    public void refresh(String zkClusterKey, boolean isForce) throws SaturnJobConsoleException {
        if (isForce) {
            this.refresh(zkClusterKey);
            return;
        }
        boolean isSameIdc = ZkClusterMappingUtils.isCurrentConsoleInTheSameIdc(this.systemConfigService, zkClusterKey);
        if (isSameIdc) {
            log.info("the zk and the console are in the same IDC, refreshStatistics in the current Console");
            this.refresh(zkClusterKey);
        } else {
            log.info("the zk and the console are in different IDC, forward the refresh request to remote console");
            try {
                this.forwardDashboardRefreshToRemote(zkClusterKey);
            }
            catch (SaturnJobConsoleException e) {
                log.warn("remote refresh request error, so refreshStatistics in the current Console, cause by {}", (Throwable)e);
                this.refresh(zkClusterKey);
            }
        }
    }

    private void refresh(String zkClusterKey) throws SaturnJobConsoleException {
        ZkCluster zkCluster = this.registryCenterService.getZkCluster(zkClusterKey);
        if (zkCluster == null) {
            throw new SaturnJobConsoleException("zk cluster not found by zkClusterKey:" + zkClusterKey);
        }
        this.refreshStatistics2DB(zkCluster);
    }

    protected void postRefreshStatistics2DB(StatisticsModel statisticsModel, ZkCluster zkCluster) {
        statisticsModel.getOutdatedNoRunningJobAnalyzer().reportAlarmOutdatedNoRunningJobs();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void forwardDashboardRefreshToRemote(String zkClusterKey) throws SaturnJobConsoleException {
        CloseableHttpClient httpClient = null;
        String url = null;
        try {
            String domain = ZkClusterMappingUtils.getConsoleDomainByZkClusterKey(this.systemConfigService, zkClusterKey);
            if (StringUtils.isBlank((CharSequence)domain)) {
                throw new SaturnJobConsoleException(String.format("The console domain is not found by zkClusterKey(%s)", zkClusterKey));
            }
            url = domain + "/rest/v1/dashboard/refresh?zkClusterKey=" + zkClusterKey;
            httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = this.createHttpRequest(url);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            this.handleResponse(url, httpResponse);
        }
        catch (SaturnJobConsoleException se) {
            try {
                throw se;
                catch (Exception e) {
                    throw new SaturnJobConsoleException("Fail to execute forwardDashboardRefreshToRemote, Url: " + url, e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(httpClient);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)httpClient);
    }

    private void handleResponse(String url, CloseableHttpResponse httpResponse) throws IOException, SaturnJobConsoleException {
        StatusLine statusLine = httpResponse.getStatusLine();
        Integer statusCode = statusLine != null ? Integer.valueOf(statusLine.getStatusCode()) : null;
        log.info("the statusCode of remote request is:" + statusCode);
        if (statusLine != null && statusCode == 200) {
            String takeTime = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8");
            log.info("forwardDashboardRefreshToRemote Url " + url + ", spend time:" + takeTime);
            return;
        }
        if (statusCode >= 400 && statusCode <= 500) {
            String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            if (StringUtils.isNotBlank((CharSequence)responseBody)) {
                String errMsg = JSONObject.parseObject((String)responseBody).getString("message");
                throw new SaturnJobConsoleException(errMsg);
            }
            throw new SaturnJobConsoleException("internal server error");
        }
        throw new SaturnJobConsoleException("unexpected status returned from Saturn Server.");
    }

    private HttpPost createHttpRequest(String url) {
        HttpPost httpPost = new HttpPost(url);
        RequestConfig cfg = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(180000).build();
        httpPost.setConfig(cfg);
        return httpPost;
    }

    private void refreshStatistics2DB(ZkCluster zkCluster) {
        log.info("start refresh statistics by zkClusterKey:{}", (Object)zkCluster.getZkClusterKey());
        Date start = new Date();
        StatisticsModel statisticsModel = this.initStatisticsModel();
        List<Callable<Boolean>> callableList = this.getStatCallableList(zkCluster, statisticsModel);
        try {
            if (callableList != null && !callableList.isEmpty()) {
                this.statExecutorService.invokeAll(callableList);
            }
            this.statisticsPersistence.persist(statisticsModel, zkCluster);
            this.postRefreshStatistics2DB(statisticsModel, zkCluster);
        }
        catch (InterruptedException e) {
            log.warn("the refreshStatistics2DB thread is interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        log.info("end refresh statistics by zkClusterKey:{}, takes {}", (Object)zkCluster.getZkClusterKey(), (Object)(new Date().getTime() - start.getTime()));
    }

    private List<Callable<Boolean>> getStatCallableList(final ZkCluster zkCluster, final StatisticsModel statisticsModel) {
        ArrayList callableList = Lists.newArrayList();
        for (final RegistryCenterConfiguration config : zkCluster.getRegCenterConfList()) {
            if (!zkCluster.getZkAddr().equals(config.getZkAddressList())) continue;
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return StatisticsRefreshServiceImpl.this.analyzeStatistics(statisticsModel, zkCluster, config);
                }
            };
            callableList.add(callable);
        }
        return callableList;
    }

    private boolean analyzeStatistics(StatisticsModel statisticsModel, ZkCluster zkCluster, RegistryCenterConfiguration config) {
        String namespace = config.getNamespace();
        try {
            DomainStatistics domain = statisticsModel.getDomainStatisticsAnalyzer().initDomain(zkCluster, config);
            CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
            List<AbnormalJob> oldAbnormalJobs = this.getOldAbnormalJobs(zkCluster);
            List<Timeout4AlarmJob> oldTimeout4AlarmJobs = this.getOldTimeout4AlarmJobs(zkCluster);
            statisticsModel.analyzeExecutor(curatorFrameworkOp, config);
            List<String> jobs = this.jobService.getUnSystemJobNames(config.getNamespace());
            for (String job : jobs) {
                if (!curatorFrameworkOp.checkExists(JobNodePath.getConfigNodePath(job))) continue;
                try {
                    Boolean localMode = Boolean.valueOf(curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(job, "localMode")));
                    JobStatistics jobStatistics = statisticsModel.analyzeJobStatistics(curatorFrameworkOp, job, localMode, config);
                    String jobDegree = String.valueOf(jobStatistics.getJobDegree());
                    statisticsModel.analyzeShardingCount(curatorFrameworkOp, domain);
                    if (!localMode.booleanValue()) {
                        statisticsModel.analyzeOutdatedNoRunningJob(curatorFrameworkOp, oldAbnormalJobs, job, jobDegree, config);
                    }
                    statisticsModel.analyzeTimeout4AlarmJob(curatorFrameworkOp, oldTimeout4AlarmJobs, job, jobDegree, config);
                    statisticsModel.analyzeUnableFailoverJob(curatorFrameworkOp, job, jobDegree, config);
                }
                catch (Exception e) {
                    log.info(String.format("analyzeStatistics namespace(%s) jobName(%s) error", namespace, job), (Throwable)e);
                }
            }
            statisticsModel.analyzeProcessCount(domain, jobs, config);
        }
        catch (Exception e) {
            log.info(String.format("analyzeStatistics namespace(%s) error", namespace), (Throwable)e);
            return false;
        }
        return true;
    }

    private List<AbnormalJob> getOldAbnormalJobs(ZkCluster zkCluster) {
        String result;
        SaturnStatistics saturnStatistics = this.saturnStatisticsService.findStatisticsByNameAndZkList("unnormal_job", zkCluster.getZkAddr());
        List<AbnormalJob> oldAbnormalJobs = new ArrayList<AbnormalJob>();
        if (saturnStatistics != null && StringUtils.isNotBlank((CharSequence)(result = saturnStatistics.getResult()))) {
            oldAbnormalJobs = JSON.parseArray((String)result, AbnormalJob.class);
        }
        return oldAbnormalJobs;
    }

    private List<Timeout4AlarmJob> getOldTimeout4AlarmJobs(ZkCluster zkCluster) {
        String result;
        SaturnStatistics saturnStatistics = this.saturnStatisticsService.findStatisticsByNameAndZkList("timeout_4_alarm_job", zkCluster.getZkAddr());
        List<Timeout4AlarmJob> oldTimeout4AlarmJobs = new ArrayList<Timeout4AlarmJob>();
        if (saturnStatistics != null && StringUtils.isNotBlank((CharSequence)(result = saturnStatistics.getResult()))) {
            oldTimeout4AlarmJobs = JSON.parseArray((String)result, Timeout4AlarmJob.class);
        }
        return oldTimeout4AlarmJobs;
    }

    protected StatisticsModel initStatisticsModel() {
        StatisticsModel statisticsModel = new StatisticsModel();
        ExecutorInfoAnalyzer executorInfoAnalyzer = new ExecutorInfoAnalyzer();
        statisticsModel.setExecutorInfoAnalyzer(executorInfoAnalyzer);
        OutdatedNoRunningJobAnalyzer outdatedNoRunningJobAnalyzer = new OutdatedNoRunningJobAnalyzer();
        outdatedNoRunningJobAnalyzer.setAbnormalShardingStateCache(this.abnormalShardingStateCache);
        outdatedNoRunningJobAnalyzer.setReportAlarmService(this.reportAlarmService);
        outdatedNoRunningJobAnalyzer.setJobService(this.jobService);
        statisticsModel.setOutdatedNoRunningJobAnalyzer(outdatedNoRunningJobAnalyzer);
        UnableFailoverJobAnalyzer unableFailoverJobAnalyzer = new UnableFailoverJobAnalyzer();
        unableFailoverJobAnalyzer.setJobService(this.jobService);
        statisticsModel.setUnableFailoverJobAnalyzer(unableFailoverJobAnalyzer);
        Timeout4AlarmJobAnalyzer timeout4AlarmJobAnalyzer = new Timeout4AlarmJobAnalyzer();
        timeout4AlarmJobAnalyzer.setReportAlarmService(this.reportAlarmService);
        statisticsModel.setTimeout4AlarmJobAnalyzer(timeout4AlarmJobAnalyzer);
        JobStatisticsAnalyzer jobStatisticsAnalyzer = new JobStatisticsAnalyzer();
        statisticsModel.setJobStatisticsAnalyzer(jobStatisticsAnalyzer);
        DomainStatisticsAnalyzer domainStatisticsAnalyzer = new DomainStatisticsAnalyzer();
        statisticsModel.setDomainStatisticsAnalyzer(domainStatisticsAnalyzer);
        ZkClusterDailyCountAnalyzer zkClusterDailyCountAnalyzer = new ZkClusterDailyCountAnalyzer();
        statisticsModel.setZkClusterDailyCountAnalyzer(zkClusterDailyCountAnalyzer);
        return statisticsModel;
    }
}

