/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl.statistics.analyzer;

import com.vip.saturn.job.console.domain.ExecutorStatistics;
import com.vip.saturn.job.console.domain.JobStatistics;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.utils.ExecutorNodePath;
import com.vip.saturn.job.console.utils.JobNodePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorInfoAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(ExecutorInfoAnalyzer.class);
    private Map<String, ExecutorStatistics> executorMap = new ConcurrentHashMap<String, ExecutorStatistics>();
    private Map<String, Long> versionDomainNumber = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> versionExecutorNumber = new ConcurrentHashMap<String, Long>();
    private AtomicInteger exeInDocker = new AtomicInteger(0);
    private AtomicInteger exeNotInDocker = new AtomicInteger(0);

    public void analyzeExecutor(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, RegistryCenterConfiguration config) {
        long executorNumber = 0L;
        if (!curatorFrameworkOp.checkExists(ExecutorNodePath.getExecutorNodePath())) {
            this.addVersionNumber("-1", executorNumber);
            return;
        }
        List<String> executors = curatorFrameworkOp.getChildren(ExecutorNodePath.getExecutorNodePath());
        if (executors == null) {
            this.addVersionNumber("-1", executorNumber);
            return;
        }
        String version = null;
        for (String exe : executors) {
            if (curatorFrameworkOp.checkExists(ExecutorNodePath.getExecutorIpNodePath(exe))) {
                String executorMapKey = exe + "-" + config.getNamespace();
                ExecutorStatistics executorStatistics = this.executorMap.get(executorMapKey);
                if (executorStatistics == null) {
                    executorStatistics = new ExecutorStatistics(exe, config.getNamespace());
                    executorStatistics.setNns(config.getNameAndNamespace());
                    executorStatistics.setIp(curatorFrameworkOp.getData(ExecutorNodePath.getExecutorIpNodePath(exe)));
                    this.executorMap.put(executorMapKey, executorStatistics);
                }
                if (this.isExecutorInDocker(curatorFrameworkOp, exe)) {
                    executorStatistics.setRunInDocker(true);
                    this.exeInDocker.incrementAndGet();
                } else {
                    this.exeNotInDocker.incrementAndGet();
                }
            }
            if (version != null) continue;
            version = curatorFrameworkOp.getData(ExecutorNodePath.getExecutorVersionNodePath(exe));
        }
        executorNumber = executors.size();
        if (version == null) {
            version = "-1";
        }
        this.addVersionNumber(version, executorNumber);
    }

    public boolean isExecutorInDocker(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String executorName) {
        return curatorFrameworkOp.checkExists(ExecutorNodePath.get$ExecutorTaskNodePath(executorName));
    }

    private synchronized void addVersionNumber(String version, long executorNumber) {
        if (this.versionDomainNumber.containsKey(version)) {
            Long domainNumber = this.versionDomainNumber.get(version);
            this.versionDomainNumber.put(version, domainNumber + 1L);
        } else {
            this.versionDomainNumber.put(version, 1L);
        }
        if (this.versionExecutorNumber.containsKey(version)) {
            Long executorNumber0 = this.versionExecutorNumber.get(version);
            this.versionExecutorNumber.put(version, executorNumber0 + executorNumber);
        } else if (executorNumber != 0L) {
            this.versionExecutorNumber.put(version, executorNumber);
        }
    }

    public void analyzeServer(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, List<String> servers, String job, String nns, RegistryCenterConfiguration config, int loadLevel, JobStatistics jobStatistics) {
        for (String server : servers) {
            if (!curatorFrameworkOp.checkExists(JobNodePath.getServerStatus(job, server))) {
                return;
            }
            this.calcJobProcessCount(curatorFrameworkOp, nns, server, job, config.getNamespace(), jobStatistics);
            this.calcLoadLevelOfExecutors(curatorFrameworkOp, nns, server, job, config.getNamespace(), loadLevel, jobStatistics);
        }
    }

    private void calcJobProcessCount(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String nns, String server, String job, String namespace, JobStatistics jobStatistics) {
        try {
            String processSuccessCountOfThisExeStr = curatorFrameworkOp.getData(JobNodePath.getProcessSucessCount(job, server));
            String processFailureCountOfThisExeStr = curatorFrameworkOp.getData(JobNodePath.getProcessFailureCount(job, server));
            int processSuccessCountOfThisExe = StringUtils.isBlank((CharSequence)processSuccessCountOfThisExeStr) ? 0 : Integer.parseInt(processSuccessCountOfThisExeStr);
            int processFailureCountOfThisExe = StringUtils.isBlank((CharSequence)processFailureCountOfThisExeStr) ? 0 : Integer.parseInt(processFailureCountOfThisExeStr);
            String executorMapKey = server + "-" + namespace;
            ExecutorStatistics executorStatistics = this.executorMap.get(executorMapKey);
            if (executorStatistics == null) {
                executorStatistics = new ExecutorStatistics(server, namespace);
                executorStatistics.setNns(nns);
                executorStatistics.setIp(curatorFrameworkOp.getData(ExecutorNodePath.getExecutorIpNodePath(server)));
                this.executorMap.put(executorMapKey, executorStatistics);
            }
            executorStatistics.setFailureCountOfTheDay(executorStatistics.getFailureCountOfTheDay() + processFailureCountOfThisExe);
            executorStatistics.setProcessCountOfTheDay(executorStatistics.getProcessCountOfTheDay() + processSuccessCountOfThisExe + processFailureCountOfThisExe);
            jobStatistics.incrProcessCountOfTheDay(processSuccessCountOfThisExe + processFailureCountOfThisExe);
            jobStatistics.incrFailureCountOfTheDay(processFailureCountOfThisExe);
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    private void calcLoadLevelOfExecutors(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String nns, String server, String job, String namespace, int loadLevel, JobStatistics jobStatistics) {
        try {
            if (!Boolean.parseBoolean(curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(job, "enabled")))) {
                return;
            }
            String sharding = curatorFrameworkOp.getData(JobNodePath.getServerSharding(job, server));
            if (StringUtils.isNotEmpty((CharSequence)sharding)) {
                String exesAndShards = (jobStatistics.getExecutorsAndShards() == null ? "" : jobStatistics.getExecutorsAndShards()) + server + ":" + sharding + "; ";
                jobStatistics.setExecutorsAndShards(exesAndShards);
                String executorMapKey = server + "-" + namespace;
                ExecutorStatistics executorStatistics = this.executorMap.get(executorMapKey);
                if (executorStatistics == null) {
                    executorStatistics = new ExecutorStatistics(server, namespace);
                    executorStatistics.setNns(nns);
                    executorStatistics.setIp(curatorFrameworkOp.getData(ExecutorNodePath.getExecutorIpNodePath(server)));
                    this.executorMap.put(executorMapKey, executorStatistics);
                    if (this.isExecutorInDocker(curatorFrameworkOp, server)) {
                        executorStatistics.setRunInDocker(true);
                        this.exeInDocker.incrementAndGet();
                    } else {
                        this.exeNotInDocker.incrementAndGet();
                    }
                }
                if (executorStatistics.getJobAndShardings() != null) {
                    executorStatistics.setJobAndShardings(executorStatistics.getJobAndShardings() + job + ":" + sharding + ";");
                } else {
                    executorStatistics.setJobAndShardings(job + ":" + sharding + ";");
                }
                int newLoad = executorStatistics.getLoadLevel() + loadLevel * sharding.split(",").length;
                executorStatistics.setLoadLevel(newLoad);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, ExecutorStatistics> getExecutorMap() {
        return this.executorMap;
    }

    public List<ExecutorStatistics> getExecutorList() {
        return new ArrayList<ExecutorStatistics>(this.executorMap.values());
    }

    public Map<String, Long> getVersionDomainNumber() {
        return this.versionDomainNumber;
    }

    public Map<String, Long> getVersionExecutorNumber() {
        return this.versionExecutorNumber;
    }

    public int getExeInDocker() {
        return this.exeInDocker.get();
    }

    public int getExeNotInDocker() {
        return this.exeNotInDocker.get();
    }
}

