/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl.statistics.analyzer;

import com.vip.saturn.job.console.domain.AbnormalJob;
import com.vip.saturn.job.console.domain.AbnormalShardingState;
import com.vip.saturn.job.console.domain.JobType;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.service.helper.DashboardConstants;
import com.vip.saturn.job.console.service.helper.DashboardServiceHelper;
import com.vip.saturn.job.console.utils.CronExpression;
import com.vip.saturn.job.console.utils.JobNodePath;
import com.vip.saturn.job.integrate.exception.ReportAlarmException;
import com.vip.saturn.job.integrate.service.ReportAlarmService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutdatedNoRunningJobAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(OutdatedNoRunningJobAnalyzer.class);
    private Map<String, AbnormalShardingState> abnormalShardingStateCache = new ConcurrentHashMap<String, AbnormalShardingState>();
    private ReportAlarmService reportAlarmService;
    private JobService jobService;
    private List<AbnormalJob> outdatedNoRunningJobs = new ArrayList<AbnormalJob>();
    private List<AbnormalJob> needReportAlarmJobs = new ArrayList<AbnormalJob>();

    private static boolean isCronJob(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String jobName) {
        String jobType = curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(jobName, "jobType"));
        return JobType.JAVA_JOB.name().equals(jobType) || JobType.SHELL_JOB.name().equals(jobType);
    }

    private static boolean isEnabledPath(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob) {
        String enabledPath = JobNodePath.getConfigNodePath(abnormalJob.getJobName(), "enabled");
        return Boolean.parseBoolean(curatorFrameworkOp.getData(enabledPath));
    }

    private static boolean isEnabledReport(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String jobName) {
        String enabledReportPath = JobNodePath.getConfigNodePath(jobName, "enabledReport");
        String enabledReportVal = curatorFrameworkOp.getData(enabledReportPath);
        return enabledReportVal == null || "true".equals(enabledReportVal);
    }

    private static long getLastCompleteTime(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String jobName, String shardingItemStr) {
        String lastCompleteTimePath = JobNodePath.getExecutionNodePath(jobName, shardingItemStr, "lastCompleteTime");
        String data = curatorFrameworkOp.getData(lastCompleteTimePath);
        return StringUtils.isBlank((CharSequence)data) ? 0L : Long.parseLong(data.trim());
    }

    private static boolean isInPausePeriod(Date date, String pausePeriodDate, String pausePeriodTime, TimeZone timeZone) {
        boolean pausePeriodTimeIsEmpty;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        int iMon = calendar.get(2) + 1;
        int d = calendar.get(5);
        int h = calendar.get(11);
        int m = calendar.get(12);
        boolean pausePeriodDateIsEmpty = pausePeriodDate == null || pausePeriodDate.trim().isEmpty();
        boolean dateIn = false;
        if (!pausePeriodDateIsEmpty) {
            dateIn = OutdatedNoRunningJobAnalyzer.isDateInPausePeriodDate(iMon, d, pausePeriodDate);
        }
        boolean timeIn = false;
        boolean bl = pausePeriodTimeIsEmpty = pausePeriodTime == null || pausePeriodTime.trim().isEmpty();
        if (!pausePeriodTimeIsEmpty) {
            timeIn = OutdatedNoRunningJobAnalyzer.isTimeInPausePeriodTime(h, m, pausePeriodTime);
        }
        if (pausePeriodDateIsEmpty) {
            if (pausePeriodTimeIsEmpty) {
                return false;
            }
            return timeIn;
        }
        if (pausePeriodTimeIsEmpty) {
            return dateIn;
        }
        return dateIn && timeIn;
    }

    private static boolean isDateInPausePeriodDate(int m, int d, String pausePeriodDate) {
        boolean dateIn = false;
        String[] periodsDate = pausePeriodDate.split(",");
        if (periodsDate == null) {
            return dateIn;
        }
        for (String period : periodsDate) {
            String[] tmp = period.trim().split("-");
            if (tmp == null || tmp.length != 2) {
                dateIn = false;
                break;
            }
            String left = tmp[0].trim();
            String right = tmp[1].trim();
            String[] sMdLeft = left.split("/");
            String[] sMdRight = right.split("/");
            if (sMdLeft != null && sMdLeft.length == 2 && sMdRight != null && sMdRight.length == 2) {
                try {
                    int iMLeft = Integer.parseInt(sMdLeft[0]);
                    int dLeft = Integer.parseInt(sMdLeft[1]);
                    int iMRight = Integer.parseInt(sMdRight[0]);
                    int dRight = Integer.parseInt(sMdRight[1]);
                    boolean isBiggerThanLeft = m > iMLeft || m == iMLeft && d >= dLeft;
                    boolean isSmallerThanRight = m < iMRight || m == iMRight && d <= dRight;
                    boolean bl = dateIn = isBiggerThanLeft && isSmallerThanRight;
                    if (!dateIn) continue;
                }
                catch (NumberFormatException e) {
                    dateIn = false;
                }
                break;
            }
            dateIn = false;
            break;
        }
        return dateIn;
    }

    private static boolean isTimeInPausePeriodTime(int hour, int min, String pausePeriodTime) {
        boolean timeIn = false;
        String[] periodsTime = pausePeriodTime.split(",");
        if (periodsTime == null) {
            return timeIn;
        }
        for (String period : periodsTime) {
            String[] tmp = period.trim().split("-");
            if (tmp == null || tmp.length != 2) {
                timeIn = false;
                break;
            }
            String left = tmp[0].trim();
            String right = tmp[1].trim();
            String[] hmLeft = left.split(":");
            String[] hmRight = right.split(":");
            if (hmLeft != null && hmLeft.length == 2 && hmRight != null && hmRight.length == 2) {
                try {
                    int hLeft = Integer.parseInt(hmLeft[0]);
                    int mLeft = Integer.parseInt(hmLeft[1]);
                    int hRight = Integer.parseInt(hmRight[0]);
                    int mRight = Integer.parseInt(hmRight[1]);
                    boolean isBiggerThanLeft = hour > hLeft || hour == hLeft && min >= mLeft;
                    boolean isSmallerThanRight = hour < hRight || hour == hRight && min <= mRight;
                    boolean bl = timeIn = isBiggerThanLeft && isSmallerThanRight;
                    if (!timeIn) continue;
                }
                catch (NumberFormatException e) {
                    timeIn = false;
                }
                break;
            }
            timeIn = false;
            break;
        }
        return timeIn;
    }

    public void analyze(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, List<AbnormalJob> oldAbnormalJobs, String jobName, String jobDegree, RegistryCenterConfiguration config) {
        AbnormalJob unnormalJob = new AbnormalJob(jobName, config.getNamespace(), config.getNameAndNamespace(), config.getDegree());
        unnormalJob.setJobDegree(jobDegree);
        this.checkOutdatedNoRunningJob(oldAbnormalJobs, curatorFrameworkOp, unnormalJob);
    }

    private synchronized boolean contains(AbnormalJob abnormalJob) {
        return this.outdatedNoRunningJobs.contains(abnormalJob);
    }

    private synchronized void addAbnormalJob(AbnormalJob abnormalJob) {
        this.outdatedNoRunningJobs.add(abnormalJob);
    }

    private synchronized void addNeedReportAlarmJob(AbnormalJob abnormalJob) {
        this.needReportAlarmJobs.add(abnormalJob);
    }

    private void checkOutdatedNoRunningJob(List<AbnormalJob> oldAbnormalJobs, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob) {
        try {
            if (!OutdatedNoRunningJobAnalyzer.isCronJob(curatorFrameworkOp, abnormalJob.getJobName())) {
                return;
            }
            if (!OutdatedNoRunningJobAnalyzer.isEnabledPath(curatorFrameworkOp, abnormalJob)) {
                return;
            }
            if (!OutdatedNoRunningJobAnalyzer.isEnabledReport(curatorFrameworkOp, abnormalJob.getJobName())) {
                return;
            }
            this.doCheckAndHandleOutdatedNoRunningJob(oldAbnormalJobs, curatorFrameworkOp, abnormalJob);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void doCheckAndHandleOutdatedNoRunningJobByShardingItem(List<AbnormalJob> oldAbnormalJobs, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob, String enabledPath, String item) {
        if (this.contains(abnormalJob)) {
            return;
        }
        String jobName = abnormalJob.getJobName();
        int cversion = this.getCversion(curatorFrameworkOp, JobNodePath.getExecutionItemNodePath(jobName, item));
        long nextFireTime = this.checkShardingItemState(curatorFrameworkOp, abnormalJob, enabledPath, item);
        if (nextFireTime != -1L && this.doubleCheckShardingState(abnormalJob, item, cversion)) {
            if (abnormalJob.getCause() == null) {
                abnormalJob.setCause(AbnormalJob.Cause.NOT_RUN.name());
            }
            this.handleOutdatedNoRunningJob(oldAbnormalJobs, curatorFrameworkOp, abnormalJob, nextFireTime);
        }
    }

    private int getCversion(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String path) {
        int cversion = 0;
        Stat stat = curatorFrameworkOp.getStat(path);
        if (stat != null) {
            cversion = stat.getCversion();
        }
        return cversion;
    }

    private boolean doubleCheckShardingState(AbnormalJob abnormalJob, String shardingItemStr, int zkNodeCVersion) {
        String key = abnormalJob.getDomainName() + "_" + abnormalJob.getJobName() + "_" + shardingItemStr;
        long nowTime = System.currentTimeMillis();
        if (this.abnormalShardingStateCache.containsKey(key)) {
            AbnormalShardingState abnormalShardingState = this.abnormalShardingStateCache.get(key);
            if (abnormalShardingState != null && (double)abnormalShardingState.getAlertTime() + (double)DashboardConstants.ALLOW_DELAY_MILLIONSECONDS * 1.5 > (double)nowTime && abnormalShardingState.getZkNodeCVersion() == zkNodeCVersion) {
                this.abnormalShardingStateCache.put(key, new AbnormalShardingState(nowTime, zkNodeCVersion));
                return true;
            }
            this.abnormalShardingStateCache.put(key, new AbnormalShardingState(nowTime, zkNodeCVersion));
            return false;
        }
        this.abnormalShardingStateCache.put(key, new AbnormalShardingState(nowTime, zkNodeCVersion));
        return false;
    }

    private void doCheckAndHandleOutdatedNoRunningJob(List<AbnormalJob> oldAbnormalJobs, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob) {
        String jobName = abnormalJob.getJobName();
        String enabledPath = JobNodePath.getConfigNodePath(abnormalJob.getJobName(), "enabled");
        List<String> items = curatorFrameworkOp.getChildren(JobNodePath.getExecutionNodePath(abnormalJob.getJobName()));
        if (items != null && !items.isEmpty()) {
            int shardingTotalCount = Integer.parseInt(curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(jobName, "shardingTotalCount")));
            for (String item : items) {
                int each = Integer.parseInt(item);
                if (each >= shardingTotalCount) continue;
                this.doCheckAndHandleOutdatedNoRunningJobByShardingItem(oldAbnormalJobs, curatorFrameworkOp, abnormalJob, enabledPath, item);
            }
        } else {
            abnormalJob.setCause(AbnormalJob.Cause.NO_SHARDS.name());
            long nextFireTimeAfterThis = curatorFrameworkOp.getMtime(enabledPath);
            Long nextFireTime = this.getNextFireTimeAfterSpecifiedTimeExcludePausePeriod(nextFireTimeAfterThis, jobName, curatorFrameworkOp);
            if (nextFireTime != null && nextFireTime + DashboardConstants.ALLOW_DELAY_MILLIONSECONDS < System.currentTimeMillis()) {
                this.handleOutdatedNoRunningJob(oldAbnormalJobs, curatorFrameworkOp, abnormalJob, nextFireTime);
            }
        }
    }

    private void handleOutdatedNoRunningJob(List<AbnormalJob> oldAbnormalJobs, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob, Long nextFireTime) {
        String jobName = abnormalJob.getJobName();
        String timeZone = this.getTimeZone(jobName, curatorFrameworkOp);
        this.fillAbnormalJobInfo(curatorFrameworkOp, oldAbnormalJobs, abnormalJob, abnormalJob.getCause(), timeZone, nextFireTime);
        this.reportAlarmAbnormalJobIfNecessary(curatorFrameworkOp, abnormalJob);
        this.addAbnormalJob(abnormalJob);
    }

    private void fillAbnormalJobInfo(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, List<AbnormalJob> oldAbnormalJobs, AbnormalJob abnormalJob, String cause, String timeZone, long nextFireTime) {
        if (this.executorNotReady(curatorFrameworkOp, abnormalJob)) {
            cause = AbnormalJob.Cause.EXECUTORS_NOT_READY.name();
        }
        abnormalJob.setCause(cause);
        abnormalJob.setTimeZone(timeZone);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone(timeZone));
        abnormalJob.setNextFireTimeWithTimeZoneFormat(sdf.format(nextFireTime));
        abnormalJob.setNextFireTime(nextFireTime);
        AbnormalJob oldAbnormalJob = DashboardServiceHelper.findEqualAbnormalJob(abnormalJob, oldAbnormalJobs);
        if (oldAbnormalJob != null) {
            abnormalJob.setRead(oldAbnormalJob.isRead());
            if (oldAbnormalJob.getUuid() != null) {
                abnormalJob.setUuid(oldAbnormalJob.getUuid());
            } else {
                abnormalJob.setUuid(UUID.randomUUID().toString());
            }
            abnormalJob.setHasRerun(oldAbnormalJob.isHasRerun());
        } else {
            abnormalJob.setUuid(UUID.randomUUID().toString());
        }
    }

    private boolean executorNotReady(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob) {
        List<String> servers;
        String jobName = abnormalJob.getJobName();
        String serverNodePath = JobNodePath.getServerNodePath(jobName);
        if (curatorFrameworkOp.checkExists(serverNodePath) && (servers = curatorFrameworkOp.getChildren(serverNodePath)) != null && !servers.isEmpty()) {
            for (String server : servers) {
                if (!curatorFrameworkOp.checkExists(JobNodePath.getServerStatus(jobName, server))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportAlarmAbnormalJobIfNecessary(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob) {
        boolean rerun = this.getRerun(abnormalJob.getJobName(), curatorFrameworkOp);
        if (rerun) {
            if (abnormalJob.isHasRerun()) {
                this.reportAlarmIfNotRead(abnormalJob);
            } else {
                String namespace = abnormalJob.getDomainName();
                String jobName = abnormalJob.getJobName();
                try {
                    log.warn("found abnormal job:{}, will runAtOnce", (Object)abnormalJob);
                    this.jobService.runAtOnce(namespace, jobName);
                }
                catch (Throwable t) {
                    log.warn(String.format("rerun job error, namespace:%s, jobName:%s", namespace, jobName), t);
                    this.reportAlarmIfNotRead(abnormalJob);
                }
                finally {
                    abnormalJob.setHasRerun(true);
                }
            }
        } else {
            this.reportAlarmIfNotRead(abnormalJob);
        }
    }

    private void reportAlarmIfNotRead(AbnormalJob abnormalJob) {
        if (!abnormalJob.isRead()) {
            this.addNeedReportAlarmJob(abnormalJob);
            String namespace = abnormalJob.getDomainName();
            String jobName = abnormalJob.getJobName();
            try {
                this.reportAlarmService.dashboardAbnormalJob(namespace, jobName, abnormalJob.getTimeZone(), abnormalJob.getNextFireTime());
            }
            catch (Throwable t) {
                log.error(String.format("report alarm abnormal job error, namespace:%s, jobName:%s", namespace, jobName), t);
            }
        }
    }

    private long checkShardingItemState(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob, String enabledPath, String shardingItemStr) {
        List<String> itemChildren = curatorFrameworkOp.getChildren(JobNodePath.getExecutionItemNodePath(abnormalJob.getJobName(), shardingItemStr));
        if (itemChildren.size() == 2) {
            return -1L;
        }
        if (itemChildren.contains("running")) {
            return -1L;
        }
        if (itemChildren.contains("completed")) {
            return this.checkShardingItemStateWhenIsCompleted(curatorFrameworkOp, abnormalJob, enabledPath, shardingItemStr);
        }
        return this.checkShardingItemStateWhenNotCompleted(curatorFrameworkOp, abnormalJob, enabledPath, shardingItemStr);
    }

    private long checkShardingItemStateWhenNotCompleted(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob, String enabledPath, String shardingItemStr) {
        Long nextFireTime;
        if (abnormalJob.getNextFireTimeAfterEnabledMtimeOrLastCompleteTime() == 0L) {
            long lastCompleteTime;
            long nextFireTimeAfterThis = curatorFrameworkOp.getMtime(enabledPath);
            if (nextFireTimeAfterThis < (lastCompleteTime = OutdatedNoRunningJobAnalyzer.getLastCompleteTime(curatorFrameworkOp, abnormalJob.getJobName(), shardingItemStr))) {
                nextFireTimeAfterThis = lastCompleteTime;
            }
            abnormalJob.setNextFireTimeAfterEnabledMtimeOrLastCompleteTime(this.getNextFireTimeAfterSpecifiedTimeExcludePausePeriod(nextFireTimeAfterThis, abnormalJob.getJobName(), curatorFrameworkOp));
        }
        if ((nextFireTime = Long.valueOf(abnormalJob.getNextFireTimeAfterEnabledMtimeOrLastCompleteTime())) != null && nextFireTime + DashboardConstants.ALLOW_DELAY_MILLIONSECONDS < System.currentTimeMillis()) {
            return nextFireTime;
        }
        return -1L;
    }

    private long checkShardingItemStateWhenIsCompleted(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob, String enabledPath, String shardingItemStr) {
        long currentTime = System.currentTimeMillis();
        String completedPath = JobNodePath.getExecutionNodePath(abnormalJob.getJobName(), shardingItemStr, "completed");
        long completedMtime = curatorFrameworkOp.getMtime(completedPath);
        if (completedMtime > 0L) {
            Long nextFireTimeExcludePausePeriod;
            long nextFireTimeAfterThis = curatorFrameworkOp.getMtime(enabledPath);
            if (nextFireTimeAfterThis < completedMtime) {
                nextFireTimeAfterThis = completedMtime;
            }
            if ((nextFireTimeExcludePausePeriod = this.getNextFireTimeAfterSpecifiedTimeExcludePausePeriod(nextFireTimeAfterThis, abnormalJob.getJobName(), curatorFrameworkOp)) != null && nextFireTimeExcludePausePeriod + DashboardConstants.ALLOW_DELAY_MILLIONSECONDS < currentTime) {
                if (!this.doubleCheckShardingStateAfterAddingDeltaInterval(curatorFrameworkOp, abnormalJob, nextFireTimeAfterThis, nextFireTimeExcludePausePeriod, currentTime)) {
                    log.debug("still has problem after adding delta interval");
                    return nextFireTimeExcludePausePeriod;
                }
                return -1L;
            }
        }
        return -1L;
    }

    private boolean doubleCheckShardingStateAfterAddingDeltaInterval(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob abnormalJob, long nextFireTimeAfterThis, Long nextFireTimeExcludePausePeriod, long currentTime) {
        Long nextFireTimeExcludePausePeriodWithDelta = this.getNextFireTimeAfterSpecifiedTimeExcludePausePeriod(nextFireTimeAfterThis + 10000L, abnormalJob.getJobName(), curatorFrameworkOp);
        if (nextFireTimeExcludePausePeriod.equals(nextFireTimeExcludePausePeriodWithDelta) || nextFireTimeExcludePausePeriodWithDelta + DashboardConstants.ALLOW_DELAY_MILLIONSECONDS < currentTime) {
            log.debug("still not work after adding delta interval");
            return false;
        }
        return true;
    }

    private Long getNextFireTimeAfterSpecifiedTimeExcludePausePeriod(long nextFireTimeAfterThis, String jobName, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        String cronPath = JobNodePath.getConfigNodePath(jobName, "cron");
        String cronVal = curatorFrameworkOp.getData(cronPath);
        CronExpression cronExpression = null;
        try {
            cronExpression = new CronExpression(cronVal);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        String timeZoneStr = this.getTimeZone(jobName, curatorFrameworkOp);
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
        cronExpression.setTimeZone(timeZone);
        Date nextFireTime = cronExpression.getTimeAfter(new Date(nextFireTimeAfterThis));
        String pausePeriodDatePath = JobNodePath.getConfigNodePath(jobName, "pausePeriodDate");
        String pausePeriodDate = curatorFrameworkOp.getData(pausePeriodDatePath);
        String pausePeriodTimePath = JobNodePath.getConfigNodePath(jobName, "pausePeriodTime");
        String pausePeriodTime = curatorFrameworkOp.getData(pausePeriodTimePath);
        while (nextFireTime != null && OutdatedNoRunningJobAnalyzer.isInPausePeriod(nextFireTime, pausePeriodDate, pausePeriodTime, timeZone)) {
            nextFireTime = cronExpression.getTimeAfter(nextFireTime);
        }
        if (null == nextFireTime) {
            return null;
        }
        return nextFireTime.getTime();
    }

    private String getTimeZone(String jobName, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        String timeZoneStr = curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(jobName, "timeZone"));
        if (timeZoneStr == null || timeZoneStr.trim().length() == 0) {
            timeZoneStr = "Asia/Shanghai";
        }
        return timeZoneStr;
    }

    private boolean getRerun(String jobName, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        String rerun = curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(jobName, "rerun"));
        return Boolean.valueOf(rerun);
    }

    public void reportAlarmOutdatedNoRunningJobs() {
        HashMap abnormalJobMap = new HashMap();
        for (AbnormalJob abnormalJob : this.needReportAlarmJobs) {
            String namespace = abnormalJob.getDomainName();
            if (!abnormalJobMap.containsKey(namespace)) {
                abnormalJobMap.put(namespace, new ArrayList());
            }
            HashMap<String, String> customMap = new HashMap<String, String>();
            customMap.put("job", abnormalJob.getJobName());
            customMap.put("timeZone", abnormalJob.getTimeZone());
            customMap.put("shouldFiredTime", String.valueOf(abnormalJob.getNextFireTime()));
            ((List)abnormalJobMap.get(namespace)).add(customMap);
        }
        for (String namespace : abnormalJobMap.keySet()) {
            this.raiseAlarmPerNamespace((List)abnormalJobMap.get(namespace), namespace);
        }
    }

    private void raiseAlarmPerNamespace(List<Map<String, String>> jobs, String namespace) {
        try {
            this.reportAlarmService.dashboardAbnormalBatchJobs(namespace, jobs);
        }
        catch (ReportAlarmException e) {
            log.error(String.format("batch report alarm abnormal job error, namespace:%s, jobs:%s", namespace, this.getJobNamesString(jobs)), (Throwable)e);
        }
    }

    private String getJobNamesString(List<Map<String, String>> jobs) {
        StringBuilder jobNames = new StringBuilder();
        int size = jobs.size();
        for (int i = 0; i < size; ++i) {
            Map<String, String> job = jobs.get(i);
            jobNames.append(job.get("job"));
            if (i >= size - 1) continue;
            jobNames.append(',');
        }
        return jobNames.toString();
    }

    public List<AbnormalJob> getOutdatedNoRunningJobs() {
        return new ArrayList<AbnormalJob>(this.outdatedNoRunningJobs);
    }

    public void setAbnormalShardingStateCache(Map<String, AbnormalShardingState> abnormalShardingStateCache) {
        this.abnormalShardingStateCache = abnormalShardingStateCache;
    }

    public void setReportAlarmService(ReportAlarmService reportAlarmService) {
        this.reportAlarmService = reportAlarmService;
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }
}

