/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl.statistics.analyzer;

import com.vip.saturn.job.console.domain.AbnormalJob;
import com.vip.saturn.job.console.domain.DomainStatistics;
import com.vip.saturn.job.console.domain.JobStatistics;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.domain.Timeout4AlarmJob;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.DomainStatisticsAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.ExecutorInfoAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.JobStatisticsAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.OutdatedNoRunningJobAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.Timeout4AlarmJobAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.UnableFailoverJobAnalyzer;
import com.vip.saturn.job.console.service.impl.statistics.analyzer.ZkClusterDailyCountAnalyzer;
import java.util.List;

public class StatisticsModel {
    private ExecutorInfoAnalyzer executorInfoAnalyzer;
    private OutdatedNoRunningJobAnalyzer outdatedNoRunningJobAnalyzer;
    private UnableFailoverJobAnalyzer unableFailoverJobAnalyzer;
    private Timeout4AlarmJobAnalyzer timeout4AlarmJobAnalyzer;
    private JobStatisticsAnalyzer jobStatisticsAnalyzer;
    private DomainStatisticsAnalyzer domainStatisticsAnalyzer;
    private ZkClusterDailyCountAnalyzer zkClusterDailyCountAnalyzer;

    public void analyzeExecutor(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, RegistryCenterConfiguration config) throws Exception {
        this.executorInfoAnalyzer.analyzeExecutor(curatorFrameworkOp, config);
    }

    public JobStatistics analyzeJobStatistics(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String job, boolean localMode, RegistryCenterConfiguration config) throws Exception {
        return this.jobStatisticsAnalyzer.analyze(curatorFrameworkOp, job, localMode, config, this.executorInfoAnalyzer);
    }

    public void analyzeShardingCount(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, DomainStatistics domainStatistics) {
        this.domainStatisticsAnalyzer.analyzeShardingCount(curatorFrameworkOp, domainStatistics);
    }

    public void analyzeOutdatedNoRunningJob(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, List<AbnormalJob> oldAbnormalJobs, String jobName, String jobDegree, RegistryCenterConfiguration config) {
        this.outdatedNoRunningJobAnalyzer.analyze(curatorFrameworkOp, oldAbnormalJobs, jobName, jobDegree, config);
    }

    public void analyzeTimeout4AlarmJob(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, List<Timeout4AlarmJob> oldTimeout4AlarmJob, String jobName, String jobDegree, RegistryCenterConfiguration config) {
        this.timeout4AlarmJobAnalyzer.analyze(curatorFrameworkOp, oldTimeout4AlarmJob, jobName, jobDegree, config);
    }

    public void analyzeUnableFailoverJob(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String jobName, String jobDegree, RegistryCenterConfiguration config) {
        this.unableFailoverJobAnalyzer.analyze(curatorFrameworkOp, jobName, jobDegree, config);
    }

    public void analyzeProcessCount(DomainStatistics domainStatistics, List<String> jobs, RegistryCenterConfiguration config) {
        this.domainStatisticsAnalyzer.analyzeProcessCount(domainStatistics, this.zkClusterDailyCountAnalyzer, jobs, this.jobStatisticsAnalyzer.getJobMap(), config);
    }

    public ExecutorInfoAnalyzer getExecutorInfoAnalyzer() {
        return this.executorInfoAnalyzer;
    }

    public void setExecutorInfoAnalyzer(ExecutorInfoAnalyzer executorInfoAnalyzer) {
        this.executorInfoAnalyzer = executorInfoAnalyzer;
    }

    public OutdatedNoRunningJobAnalyzer getOutdatedNoRunningJobAnalyzer() {
        return this.outdatedNoRunningJobAnalyzer;
    }

    public void setOutdatedNoRunningJobAnalyzer(OutdatedNoRunningJobAnalyzer outdatedNoRunningJobAnalyzer) {
        this.outdatedNoRunningJobAnalyzer = outdatedNoRunningJobAnalyzer;
    }

    public UnableFailoverJobAnalyzer getUnableFailoverJobAnalyzer() {
        return this.unableFailoverJobAnalyzer;
    }

    public void setUnableFailoverJobAnalyzer(UnableFailoverJobAnalyzer unableFailoverJobAnalyzer) {
        this.unableFailoverJobAnalyzer = unableFailoverJobAnalyzer;
    }

    public Timeout4AlarmJobAnalyzer getTimeout4AlarmJobAnalyzer() {
        return this.timeout4AlarmJobAnalyzer;
    }

    public void setTimeout4AlarmJobAnalyzer(Timeout4AlarmJobAnalyzer timeout4AlarmJobAnalyzer) {
        this.timeout4AlarmJobAnalyzer = timeout4AlarmJobAnalyzer;
    }

    public JobStatisticsAnalyzer getJobStatisticsAnalyzer() {
        return this.jobStatisticsAnalyzer;
    }

    public void setJobStatisticsAnalyzer(JobStatisticsAnalyzer jobStatisticsAnalyzer) {
        this.jobStatisticsAnalyzer = jobStatisticsAnalyzer;
    }

    public DomainStatisticsAnalyzer getDomainStatisticsAnalyzer() {
        return this.domainStatisticsAnalyzer;
    }

    public void setDomainStatisticsAnalyzer(DomainStatisticsAnalyzer domainStatisticsAnalyzer) {
        this.domainStatisticsAnalyzer = domainStatisticsAnalyzer;
    }

    public ZkClusterDailyCountAnalyzer getZkClusterDailyCountAnalyzer() {
        return this.zkClusterDailyCountAnalyzer;
    }

    public void setZkClusterDailyCountAnalyzer(ZkClusterDailyCountAnalyzer zkClusterDailyCountAnalyzer) {
        this.zkClusterDailyCountAnalyzer = zkClusterDailyCountAnalyzer;
    }
}

