/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl.statistics.analyzer;

import com.vip.saturn.job.console.domain.AbnormalJob;
import com.vip.saturn.job.console.domain.ExecutorProvided;
import com.vip.saturn.job.console.domain.ExecutorProvidedStatus;
import com.vip.saturn.job.console.domain.ExecutorProvidedType;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.utils.JobNodePath;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class UnableFailoverJobAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(UnableFailoverJobAnalyzer.class);
    private JobService jobService;
    private List<AbnormalJob> unableFailoverJobList = new ArrayList<AbnormalJob>();

    public void analyze(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String jobName, String jobDegree, RegistryCenterConfiguration config) {
        AbnormalJob unableFailoverJob = new AbnormalJob(jobName, config.getNamespace(), config.getNameAndNamespace(), config.getDegree());
        if (this.isUnableFailoverJob(curatorFrameworkOp, unableFailoverJob)) {
            unableFailoverJob.setJobDegree(jobDegree);
            this.addUnableFailoverJob(unableFailoverJob);
        }
    }

    private synchronized void addUnableFailoverJob(AbnormalJob unableFailoverJob) {
        this.unableFailoverJobList.add(unableFailoverJob);
    }

    private boolean isUnableFailoverJob(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, AbnormalJob unableFailoverJob) {
        try {
            String jobName = unableFailoverJob.getJobName();
            List<ExecutorProvided> preferListProvided = this.jobService.getCandidateExecutors(curatorFrameworkOp.getCuratorFramework().getNamespace(), jobName);
            if (CollectionUtils.isEmpty(preferListProvided)) {
                return false;
            }
            String preferList = curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(jobName, "preferList"));
            List<String> preferListArr = this.toPerferListArr(preferList);
            boolean containerSelected = false;
            int count = 0;
            if (this.onlyUsePreferList(curatorFrameworkOp, jobName)) {
                for (ExecutorProvided executorProvided : preferListProvided) {
                    if (!preferListArr.contains(executorProvided.getExecutorName())) continue;
                    if (ExecutorProvidedType.DOCKER.equals((Object)executorProvided.getType())) {
                        containerSelected = true;
                        break;
                    }
                    if (!ExecutorProvidedType.PHYSICAL.equals((Object)executorProvided.getType()) || !ExecutorProvidedStatus.ONLINE.equals((Object)executorProvided.getStatus())) continue;
                    ++count;
                }
            } else {
                for (ExecutorProvided executorProvided : preferListProvided) {
                    if (preferListArr.contains(executorProvided.getExecutorName()) && ExecutorProvidedType.DOCKER.equals((Object)executorProvided.getType())) {
                        containerSelected = true;
                    } else {
                        if (ExecutorProvidedType.PHYSICAL.equals((Object)executorProvided.getType()) && ExecutorProvidedStatus.ONLINE.equals((Object)executorProvided.getStatus())) {
                            ++count;
                        }
                        if (count <= true) continue;
                    }
                    break;
                }
            }
            return !containerSelected && count == 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean onlyUsePreferList(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String jobName) {
        String useDispreferListStr = curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(jobName, "useDispreferList"));
        return useDispreferListStr == null ? false : !Boolean.parseBoolean(useDispreferListStr);
    }

    private List<String> toPerferListArr(String preferList) {
        String[] split;
        ArrayList<String> preferListArr = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)preferList)) {
            return preferListArr;
        }
        for (String prefer : split = preferList.split(",")) {
            String tmp = prefer.trim();
            if (tmp.length() <= 0 || preferListArr.contains(tmp)) continue;
            preferListArr.add(tmp);
        }
        return preferListArr;
    }

    public List<AbnormalJob> getUnableFailoverJobList() {
        return new ArrayList<AbnormalJob>(this.unableFailoverJobList);
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }
}

