/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ser.std.NullSerializer;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();
    static Logger log = LoggerFactory.getLogger(JsonUtils.class);

    private static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static String toJSON(Object obj) {
        try {
            String value = JsonUtils.getObjectMapper().writeValueAsString(obj);
            return value;
        }
        catch (Exception e) {
            log.error("msg=Fail at toJSON: ", (Throwable)e);
            return "";
        }
    }

    public static <T> T fromJSON(String jsonStr, Class<T> type) {
        Object result = null;
        try {
            result = JsonUtils.getObjectMapper().readValue(jsonStr, type);
        }
        catch (Exception e) {
            log.error("msg=Fail at fromJSON: ", (Throwable)e);
        }
        return (T)result;
    }

    public static <T> T fromJSON(String jsonStr, JavaType javaType) {
        Object result = null;
        try {
            result = JsonUtils.getObjectMapper().readValue(jsonStr, javaType);
        }
        catch (Exception e) {
            log.error("msg=Fail at fromJSON: ", (Throwable)e);
        }
        return (T)result;
    }

    public static <T> T fromJSON(String jsonStr, TypeReference<T> type) {
        Object result = null;
        try {
            result = JsonUtils.getObjectMapper().readValue(jsonStr, type);
        }
        catch (Exception e) {
            log.error("msg=Fail at fromJSON: ", (Throwable)e);
        }
        return (T)result;
    }

    public static <T> JavaType constructListParametricType(Class<T> contentClass) throws ClassNotFoundException {
        return mapper.getTypeFactory().constructParametricType(List.class, new Class[]{Class.forName(contentClass.getName())});
    }

    static {
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        mapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)NullSerializer.instance);
    }
}

