/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.utils;

import com.google.common.base.Strings;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHostService {
    private static final Logger log = LoggerFactory.getLogger(LocalHostService.class);
    private static final String IP_REGEX = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(00?\\d|1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(00?\\d|1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(00?\\d|1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
    public static volatile String cachedIpAddress = System.getProperty("VIP_SATURN_RUNNING_IP", System.getenv("VIP_SATURN_RUNNING_IP"));
    private static volatile String cachedHostName = System.getProperty("VIP_SATURN_RUNNING_HOSTNAME", System.getenv("VIP_SATURN_RUNNING_HOSTNAME"));

    public static String getHostName() throws UnknownHostException {
        if (!Strings.isNullOrEmpty((String)cachedHostName)) {
            return cachedHostName;
        }
        return LocalHostService.getLocalHost().getHostName();
    }

    private static InetAddress getLocalHost() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    @Deprecated
    public static void setCachedIpAddress(String ip) {
        cachedIpAddress = ip;
    }

    @Deprecated
    public static void setCachedHostName(String hostName) {
        cachedHostName = hostName;
    }

    private static boolean isIpv4(String ipAddress) {
        Pattern pattern = Pattern.compile(IP_REGEX);
        Matcher matcher = pattern.matcher(ipAddress);
        return matcher.matches();
    }

    static {
        if (StringUtils.isEmpty((CharSequence)cachedIpAddress)) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                if (inetAddress.getHostAddress() == null || "127.0.0.1".equals(inetAddress.getHostAddress())) {
                    NetworkInterface ni = NetworkInterface.getByName("bond0");
                    if (ni == null) {
                        ni = NetworkInterface.getByName("eth0");
                    }
                    if (ni == null) {
                        throw new Exception("failed in getting ip from local host, bond0 and eth0");
                    }
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        InetAddress nextElement = ips.nextElement();
                        if ("127.0.0.1".equals(nextElement.getHostAddress()) || nextElement instanceof Inet6Address || nextElement.getHostAddress().contains(":")) continue;
                        inetAddress = nextElement;
                        break;
                    }
                }
                cachedIpAddress = inetAddress.getHostAddress();
            }
            catch (Throwable e) {
                log.error("[localHostService error][please configure hostname or bond0 or eth0. System is shutting down.]", e);
                System.exit(-1);
            }
        } else if (!LocalHostService.isIpv4(cachedIpAddress)) {
            log.error("IP address {} is illegal. System is shutting down.", (Object)cachedIpAddress);
            System.exit(-1);
        }
        log.info("Done initial localhostip: {}.", (Object)cachedIpAddress);
    }
}

