/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.utils;

import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils {
    public static final String HASH_METHOD_PLANTEXT = "plaintext";
    public static final String HASH_METHOD_PBKDF2 = "PBKDF2WithHmacSHA1";
    private static final Logger log = LoggerFactory.getLogger(PasswordUtils.class);
    private static final int ITERATIONS = 10000;
    private static final int SALT_LEN = 8;
    private static final int KEY_LEN = 256;

    public static String genPassword(String password, String hashMethod) throws Exception {
        byte[] salt = SecureRandom.getInstance("SHA1PRNG").generateSeed(8);
        return PasswordUtils.genPassword(password, salt, hashMethod);
    }

    public static String genPassword(String password, byte[] salt, String hashMethod) throws Exception {
        if (!PasswordUtils.isHashMethodSupported(hashMethod)) {
            throw new SaturnJobConsoleException(String.format("hash method [%s] is not supported", hashMethod));
        }
        if (HASH_METHOD_PLANTEXT.equals(hashMethod)) {
            return password;
        }
        return PasswordUtils.hash(password, salt) + "$" + Hex.encodeHexString((byte[])salt);
    }

    public static String hash(String password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(HASH_METHOD_PBKDF2);
        SecretKey key = secretKeyFactory.generateSecret(new PBEKeySpec(password.toCharArray(), salt, 10000, 256));
        return Hex.encodeHexString((byte[])key.getEncoded());
    }

    public static void validate(String password, String passwordInDB, String hashMethod) throws SaturnJobConsoleException {
        String hashOfRequestPassword;
        if (!PasswordUtils.isHashMethodSupported(hashMethod)) {
            throw new SaturnJobConsoleException(String.format("hash method [%s] is not supported", hashMethod));
        }
        if (HASH_METHOD_PLANTEXT.equals(hashMethod)) {
            if (!password.equals(passwordInDB)) {
                throw new SaturnJobConsoleException(4, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
            }
            return;
        }
        String[] saltAndPassword = passwordInDB.split("\\$");
        if (saltAndPassword.length != 2) {
            log.debug("malformed password in db");
            throw new SaturnJobConsoleException(4, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        try {
            hashOfRequestPassword = PasswordUtils.hash(password, PasswordUtils.getSalt(saltAndPassword[1]));
        }
        catch (Exception e) {
            throw new SaturnJobConsoleException(4, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (!hashOfRequestPassword.equals(new String(saltAndPassword[0]))) {
            throw new SaturnJobConsoleException(4, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
    }

    public static boolean isHashMethodSupported(String hashMethod) {
        return HASH_METHOD_PBKDF2.equals(hashMethod) || HASH_METHOD_PLANTEXT.equals(hashMethod);
    }

    private static byte[] getSalt(String s) throws DecoderException {
        return Hex.decodeHex((char[])s.toCharArray());
    }
}

