/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.utils;

import com.vip.saturn.job.console.domain.JobType;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.utils.JobNodePath;
import com.vip.saturn.job.console.utils.SaturnConstants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaturnConsoleUtils {
    private static DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static Random random = new Random();

    public static Logger getAuditLogger() {
        return LoggerFactory.getLogger((String)"AUDITLOG");
    }

    public static String parseMillisecond2DisplayTime(String longInStr) {
        return SaturnConsoleUtils.parseMillisecond2DisplayTime(longInStr, null);
    }

    public static String parseMillisecond2DisplayTime(String longInStr, TimeZone timezone) {
        if (StringUtils.isBlank((CharSequence)longInStr)) {
            return null;
        }
        return dtf.print((ReadableInstant)new DateTime(Long.parseLong(longInStr), DateTimeZone.forTimeZone((TimeZone)timezone)));
    }

    public static boolean checkIfJobIsEnabledReport(String jobName, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        String enabledReportNodePath = JobNodePath.getEnabledReportNodePath(jobName);
        if (curatorFrameworkOp.checkExists(enabledReportNodePath)) {
            return Boolean.parseBoolean(curatorFrameworkOp.getData(enabledReportNodePath));
        }
        String jobTypeNodePath = JobNodePath.getConfigNodePath(jobName, "jobType");
        JobType jobType = JobType.getJobType(curatorFrameworkOp.getData(jobTypeNodePath));
        return jobType == JobType.JAVA_JOB || jobType == JobType.SHELL_JOB;
    }

    public static File createTmpFile() throws SaturnJobConsoleException, IOException {
        int i;
        int loopTimes = 5;
        File tmp = null;
        for (i = 0; i < loopTimes && (tmp = new File(SaturnConstants.CACHES_FILE_PATH, SaturnConsoleUtils.genTmpFileName())).exists(); ++i) {
        }
        if (i == loopTimes) {
            throw new SaturnJobConsoleException("fail to create temp file.");
        }
        FileUtils.forceMkdir((File)tmp.getParentFile());
        if (tmp.createNewFile()) {
            return tmp;
        }
        throw new SaturnJobConsoleException("fail to create temp file.");
    }

    private static String genTmpFileName() {
        return "tmp_exportFile_" + System.currentTimeMillis() + "_" + random.nextInt(1000) + ".xls";
    }

    public static void exportFile(HttpServletResponse response, File srcFile, String exportFileName, boolean deleteTmpFile) throws SaturnJobConsoleException {
        try (FileInputStream inputStream = new FileInputStream(srcFile);){
            SaturnConsoleUtils.exportFile(response, inputStream, exportFileName);
        }
        catch (IOException e) {
            throw new SaturnJobConsoleException("file not found:" + srcFile.getName(), e);
        }
        finally {
            if (deleteTmpFile && srcFile != null) {
                srcFile.delete();
            }
        }
    }

    public static void exportFile(HttpServletResponse response, InputStream inputStream, String exportFileName) throws SaturnJobConsoleException {
        try {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment; filename=" + new String(exportFileName.getBytes("UTF-8"), "ISO8859-1"));
            try (BufferedInputStream bis = new BufferedInputStream(inputStream);
                 BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int bytesRead;
                byte[] buff = new byte[2048];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                }
            }
        }
        catch (Exception e) {
            throw new SaturnJobConsoleException(e);
        }
    }
}

