/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.html.output.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.gbicc.cloud.word.config.SystemConfig;
import net.gbicc.cloud.word.model.report.CrReport;
import net.gbicc.cloud.word.service.report.CrCompanyServiceI;
import net.gbicc.cloud.word.service.report.CrReportScheduleServiceI;
import net.gbicc.cloud.word.service.report.CrReportServiceI;
import net.gbicc.cloud.word.util.DateUtil;
import net.gbicc.cloud.word.util.ReportUtil;
import net.gbicc.html.output.service.OutPutFormat;
import net.gbicc.html.output.util.FileToZipUtil;
import net.gbicc.html.output.util.FileUtil;
import org.apache.commons.lang.StringUtils;
import org.xbrl.word.common.util.IniReader;

public class Db2ExportProcessor {
    protected String dataHome;
    protected String dcId;
    protected boolean isZip;
    protected String fileNameType;
    protected String templatePath;
    protected CrReportScheduleServiceI scheduleService;
    protected CrCompanyServiceI companyService;
    protected IniReader iniReader;
    protected String dataPath;
    protected String tmpPath;
    protected CrReport _report;
    protected CrReportServiceI reportService;
    protected String taskPeriod;

    public String getDcId() {
        return this.dcId;
    }

    public void setDcId(String dcId) {
        this.dcId = dcId;
    }

    public boolean isZip() {
        return this.isZip;
    }

    public void setZip(boolean isZip) {
        this.isZip = isZip;
    }

    public String getFileNameType() {
        return this.fileNameType;
    }

    public void setFileNameType(String fileNameType) {
        this.fileNameType = fileNameType;
    }

    public IniReader getIniReader() {
        return this.iniReader;
    }

    public void setIniReader(IniReader iniReader) {
        this.iniReader = iniReader;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public Db2ExportProcessor(CrReport report, CrReportServiceI reportService) {
        this._report = report;
        this.reportService = reportService;
        this.dataHome = SystemConfig.getInstance().getString("api.data.home");
    }

    public String getDataPath() {
        this.dataPath = StringUtils.isNotEmpty((String)this.dataHome) ? this.dataHome.concat(File.separator) : ReportUtil.getDataPath((CrReport)this._report);
        String string = this.basePath();
        if (StringUtils.isNotEmpty((String)string)) {
            this.dataPath = this.dataPath.concat(string);
        }
        return this.dataPath;
    }

    public String basePath() {
        OutPutFormat outPutFormat = OutPutFormat.tryParse(this.fileNameType);
        if (OutPutFormat.CISP.equals((Object)outPutFormat)) {
            String string = File.separator;
            String string2 = this._report.getReportType();
            String string3 = this._report.getCompId();
            if (StringUtils.isEmpty((String)string3)) {
                string3 = this._report.getStockCode();
            }
            String string4 = this.c(this.taskPeriod);
            return string2.concat(string).concat(string4).concat(string).concat(string3).concat(string);
        }
        if (OutPutFormat.FISP.equals((Object)outPutFormat)) {
            return "";
        }
        OutPutFormat.PF.equals((Object)outPutFormat);
        return "";
    }

    public String exportPath() {
        String string;
        String string2 = "";
        if (StringUtils.isNotEmpty((String)this.dataHome)) {
            string2 = this.dataHome.concat(File.separator);
        }
        if (StringUtils.isNotEmpty((String)(string = this.basePath()))) {
            string2 = String.valueOf(string2) + string;
        }
        return string2;
    }

    public String getTmpPath() {
        if (StringUtils.isEmpty((String)this.tmpPath)) {
            this.tmpPath = this.getDataPath().concat(File.separator).concat(Long.toString(new Date().getTime())).concat(File.separator);
        }
        return this.tmpPath;
    }

    protected void createDataFileToZip(List<String> copyFileName, String filepath, String zippath) {
        Object var4_4 = null;
        InputStream inputStream = null;
        try {
            String string = ReportUtil.getDataPath((CrReport)this._report);
            if (copyFileName != null && copyFileName.size() > 0) {
                int n = 0;
                while (n < copyFileName.size()) {
                    String string2 = string.concat(File.separator).concat(copyFileName.get(n));
                    String string3 = this.tmpPath.concat(copyFileName.get(n));
                    File file = new File(string2);
                    if (file.exists()) {
                        FileUtil.saveAsFile(string2, string3);
                    }
                    ++n;
                }
            }
            FileToZipUtil.zipMultiFile(this.tmpPath, zippath, false);
        }
        finally {
            try {
                FileUtil.deleteFile(this.tmpPath);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (var4_4 != null) {
                try {
                    var4_4.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    protected String fileNameFormat() throws IllegalAccessException {
        OutPutFormat outPutFormat = OutPutFormat.tryParse(this.fileNameType);
        if (OutPutFormat.CISP.equals((Object)outPutFormat)) {
            return this.b();
        }
        if (OutPutFormat.FISP.equals((Object)outPutFormat)) {
            return this.a();
        }
        if (!OutPutFormat.PF.equals((Object)outPutFormat)) {
            throw new IllegalAccessException("\u76f4\u8fde\u901a\u9053\u4e2d\u8bbe\u7f6e\u7684\u6587\u4ef6\u540d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9");
        }
        return "";
    }

    private String a() throws IllegalAccessException {
        String string;
        Object object;
        String string2;
        Map<String, Object> map = this.getTaskTpl();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (map != null) {
            string2 = (String)map.get("SUP_ID");
            object = this.b(string2);
            string3 = (String)object.get("REGULATOR_CODE");
            string = (String)object.get("REGULATOR_ID");
            string4 = this.a(string);
            string5 = this.c(this.taskPeriod);
        }
        string2 = this._report.getReportType();
        object = this.c();
        string = DateUtil.dateToString((Date)this._report.getEndDate(), (String)"yyyyMMdd");
        if (StringUtils.isEmpty((String)string3)) {
            throw new IllegalAccessException("\u6570\u636e\u6e90\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)string4)) {
            throw new IllegalAccessException("\u62a5\u9001\u673a\u6784\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)string5)) {
            throw new IllegalAccessException("\u4f20\u8f93\u9891\u5ea6\u4e3a\u7a7a");
        }
        return String.valueOf(string3) + "-" + string4 + "_" + string2 + "_V01_" + string5 + "_" + string + "_" + (String)object + "_Z";
    }

    private String b() throws IllegalAccessException {
        String string;
        Map<String, Object> map = this.getTaskTpl();
        String string2 = "";
        if (map != null) {
            string = (String)map.get("SUP_ID");
            Map<String, Object> map2 = this.b(string);
            string2 = (String)map2.get("REGULATOR_CODE");
        }
        if (StringUtils.isEmpty((String)string2)) {
            throw new IllegalAccessException("\u6570\u636e\u6e90\u7f16\u7801\u4e3a\u7a7a");
        }
        string = this.d();
        if (StringUtils.isEmpty((String)string)) {
            throw new IllegalAccessException("\u62a5\u544a\u7c7b\u578b\u540d\u79f0\u4e3a\u7a7a");
        }
        return String.valueOf(string2) + "-" + string + "-" + this._report.getName();
    }

    protected Map<String, Object> getTaskTpl() {
        String string = "SELECT B.SUP_ID FROM CR_TASK A,CR_TASK_TPL B WHERE A.TPL_ID = B.TPL_ID AND A.TASK_ID =:taskId";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("taskId", this._report.getTaskId());
        List list = this.reportService.findBySql(string, hashMap);
        Map map = null;
        if (list != null && list.size() > 0) {
            map = (Map)list.get(0);
        }
        return map;
    }

    private String a(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return "";
        }
        String string2 = "";
        String string3 = "SELECT ENTITY_CODE FROM CR_COMPANY_ENTITY_CODE WHERE COMPANY_ID = :companyId AND REGULATOR_ID = :regulatorId";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("companyId", this._report.getCompId());
        hashMap.put("regulatorId", string);
        List list = this.reportService.findBySql(string3, hashMap);
        if (list != null && list.size() > 0) {
            string2 = (String)((Map)list.get(0)).get("ENTITY_CODE");
        }
        return string2;
    }

    private Map<String, Object> b(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)string)) {
            return hashMap;
        }
        String string2 = "SELECT REGULATOR_NAME,REGULATOR_CODE,REGULATOR_ID FROM CR_REGULATOR WHERE SUP_ID = :supId";
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("supId", string);
        List list = this.reportService.findBySql(string2, hashMap2);
        if (list != null && list.size() > 0) {
            hashMap.putAll((Map)list.get(0));
        }
        return hashMap;
    }

    private String c() {
        int n;
        String string = "";
        String string2 = "SELECT MAX(VERSION) AS VERSION FROM CR_REPORT_VERSION WHERE REPORT_ID = :reportId AND CREATE_DATE = :createDate";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("reportId", this._report.getId());
        hashMap.put("createDate", DateUtil.getNowDateShort());
        List list = this.reportService.findBySql(string2, hashMap);
        if (list != null && list.size() > 0) {
            Object v = ((Map)list.get(0)).get("VERSION");
            if (v instanceof Integer) {
                string = "" + (Integer)v;
            } else if (v instanceof String) {
                string = (String)v;
            }
        }
        string = StringUtils.isNotEmpty((String)string) ? ((n = Integer.parseInt(string) + 1) < 10 ? "0" + n : String.valueOf(n)) : "01";
        return string;
    }

    public String getTaskPeriod() {
        return this.taskPeriod;
    }

    public void setTaskPeriod(String taskPeriod) {
        this.taskPeriod = taskPeriod;
    }

    private String c(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return "";
        }
        if ("day".equals(string)) {
            return "1";
        }
        if ("week".equals(string)) {
            return "2";
        }
        if ("month".equals(string)) {
            return "3";
        }
        if ("season".equals(string)) {
            return "4";
        }
        if ("half_year".equals(string)) {
            return "5";
        }
        if ("year".equals(string)) {
            return "6";
        }
        if ("once".equals(string)) {
            return "7";
        }
        return "";
    }

    private String d() {
        Object v;
        String string = "";
        String string2 = " SELECT TYPE_NAME FROM CR_REPORT_TYPE WHERE TYPE_CODE = :typeCode ";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("typeCode", this._report.getReportType());
        List list = this.reportService.findBySql(string2, hashMap);
        if (list != null && list.size() > 0 && (v = ((Map)list.get(0)).get("TYPE_NAME")) instanceof String) {
            string = (String)v;
        }
        return string;
    }
}

