/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.html.output.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    public static void moveFile(String filePath, String destPath) {
        FileUtil.saveAsFile(filePath, destPath);
        FileUtil.deleteFile(filePath);
    }

    public static void moveFile(File file, String destPath) {
        try {
            FileUtil.saveAsFile(file, destPath);
            FileUtil.deleteFile(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public static void deleteFile(File file) throws FileNotFoundException {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    FileUtil.deleteFile(fileArray[n]);
                    ++n;
                }
                file.delete();
            }
        } else {
            throw new FileNotFoundException();
        }
    }

    public static void deleteFile(String filePath) {
        try {
            FileUtil.deleteFile(new File(filePath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public static void saveAsFile(String filePath, String destPath) {
        File file = new File(filePath);
        FileUtil.saveAsFile(file, destPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveAsFile(File file, String destPath) {
        if (file.isDirectory()) {
            File[] fileArray;
            File[] fileArray2 = fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                FileUtil.saveAsFile(file2, String.valueOf(destPath) + File.separator + file2.getName());
                ++n2;
            }
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                FileUtil.saveAsFile(fileInputStream, destPath);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void saveAsFile(InputStream in, String destPath) {
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                int n;
                byte[] byArray = new byte[1024];
                File file = new File(destPath);
                if (!file.exists()) {
                    new File(file.getParent()).mkdirs();
                }
                fileOutputStream = new FileOutputStream(file);
                filterOutputStream = new BufferedOutputStream(fileOutputStream);
                while ((n = in.read(byArray)) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (IOException iOException) {
                block31: {
                    iOException.printStackTrace();
                    if (filterOutputStream == null) break block31;
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException3) {
                        iOException3.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        FileUtil.moveFile("d:\\122", "d:\\123");
    }
}

