/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.html.output.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.gbicc.cloud.word.config.SystemConfig;
import net.gbicc.html.output.util.io.DcReader;
import net.gbicc.html.output.util.io.IoStream;
import net.gbicc.html.output.util.io.IoStreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;
import org.xbrl.word.common.io.StorageGate;
import system.io.FastByteArrayOutputStream;

public class RemoteFileIoStream
implements IoStream {
    private Logger a = Logger.getLogger(this.getClass());
    private FTPClient b;
    private int c;
    private String d;
    private String e;
    private String f;
    private boolean g;

    public RemoteFileIoStream(String host, int port, String username, String password, boolean mode) throws IOException {
        this.d = host;
        this.c = port;
        this.e = username;
        this.f = password;
        this.g = mode;
    }

    private void a() throws IOException {
        this.b = new FTPClient();
        this.b.setControlKeepAliveTimeout(0L);
        this.b.setControlKeepAliveReplyTimeout(1000);
        this.b.setControlEncoding("UTF-8");
        if (this.c == 0) {
            this.c = this.b.getDefaultPort();
        }
        this.a.info((Object)String.format("ftp client connecting, parameter is host[%s], port[%s]", this.d, this.c));
        this.b.connect(this.d, this.c);
        int n = this.b.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)n)) {
            this.a.error((Object)("a reply code [" + n + "], connect failure!"));
            this.b.disconnect();
            System.exit(1);
        }
        this.a.info((Object)"ftp client logining...");
        if (!this.b.login(this.e, this.f)) {
            this.a.error((Object)("a reply code [" + this.b.getReplyCode() + "], login failure."));
            this.b.logout();
        }
        this.b.setFileType(2);
        if (this.g) {
            this.a.info((Object)"ftp is passive mode.");
            this.b.enterLocalPassiveMode();
        } else {
            this.a.info((Object)"ftp is active mode.");
            this.b.enterLocalActiveMode();
        }
    }

    @Override
    public InputStream getInputStream(String path, String fileName) throws IOException {
        if (StringUtils.isEmpty((String)fileName)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        path = StringUtils.trimToEmpty((String)path);
        FastByteArrayOutputStream fastByteArrayOutputStream = null;
        try {
            this.a();
            this.a.info((Object)("ftp read work directory [" + path + "] from server"));
            FTPFile[] fTPFileArray = this.b.listFiles(path);
            if (fTPFileArray == null) {
                throw new IllegalArgumentException("\u6587\u4ef6\u76ee\u5f55[" + path + "]\u4e0d\u5b58\u5728\uff01");
            }
            int n = this.b.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)n)) {
                this.a.error((Object)("read work dir, reply code is [" + n + "]"));
                throw new FileNotFoundException("FTP\u83b7\u53d6\u6587\u4ef6\u76ee\u5f55\uff1a" + fileName + ", reply code : " + this.b.getReplyString());
            }
            fastByteArrayOutputStream = new FastByteArrayOutputStream();
            String string = StorageGate.makePath((String)path, (String)fileName);
            this.a.info((Object)("ftp read file [" + string + "] from server"));
            this.b.retrieveFile(string, (OutputStream)fastByteArrayOutputStream);
            n = this.b.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)n)) {
                this.a.error((Object)("retrieve file, reply code is [" + n + "]"));
                throw new FileNotFoundException("FTP\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + fileName + ", reply code : " + this.b.getReplyString());
            }
            InputStream inputStream = fastByteArrayOutputStream.getInputStream();
            return inputStream;
        }
        catch (IOException iOException) {
            this.a.error((Object)iOException);
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            this.b();
            if (fastByteArrayOutputStream != null) {
                fastByteArrayOutputStream.close();
            }
        }
    }

    private void b() {
        if (this.b != null && this.b.isConnected()) {
            try {
                try {
                    this.b.disconnect();
                }
                catch (IOException iOException) {
                    this.a.error((Object)iOException);
                    iOException.printStackTrace();
                    if (this.b != null) {
                        this.b = null;
                    }
                }
            }
            finally {
                if (this.b != null) {
                    this.b = null;
                }
            }
        }
    }

    @Override
    public String getPath(String tail, DcReader dc, String dcKey) {
        String string = "";
        string = dc != null ? (StringUtils.isNotEmpty((String)dcKey) ? dc.getValue(dcKey, "ftp.remote_home") : dc.getValue("ftp", "ftp.remote_home")) : SystemConfig.getInstance().getString("ftp.remote_home");
        return StorageGate.makePath((String)string, (String)tail);
    }

    @Override
    public IoStreamResult write(String path, InputStream inStream) throws IOException {
        String string = path;
        try {
            this.a();
            System.out.println("remote connected.");
            File file = new File(string);
            if (file.getParentFile() != null) {
                File file2 = file.getParentFile();
                this.a(file2);
            }
            if (this.b.storeFile(file.getName(), inStream)) {
                System.out.println("remote write ok.");
                IoStreamResult ioStreamResult = new IoStreamResult(200, "remote write ok.");
                return ioStreamResult;
            }
            this.a.error((Object)("remote write error : " + this.b.getReplyCode()));
            IoStreamResult ioStreamResult = new IoStreamResult(this.b.getReplyCode(), "remote write error.");
            return ioStreamResult;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.a.error((Object)iOException);
            throw iOException;
        }
        finally {
            this.b();
        }
    }

    private void a(File file) throws IOException {
        Object object;
        if (file.getParentFile() != null) {
            object = file.getParentFile();
            this.a((File)object);
        }
        object = file.getName();
        this.b.makeDirectory((String)object);
        this.b.changeWorkingDirectory((String)object);
    }
}

