/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.history.HistoricVariableInstanceBaseResource;
import org.activiti.rest.service.api.history.HistoricVariableInstanceQueryRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History"}, description="Manage History", authorizations={@Authorization(value="basicAuth")})
public class HistoricVariableInstanceCollectionResource
extends HistoricVariableInstanceBaseResource {
    @ApiOperation(value="List of historic variable instances", tags={"History"}, nickname="getHistoricVariableInstances")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", dataType="string", value="The process instance id of the historic variable instance.", paramType="query"), @ApiImplicitParam(name="taskId", dataType="string", value="The task id of the historic variable instance.", paramType="query"), @ApiImplicitParam(name="excludeTaskVariables", dataType="boolean", value="Indication to exclude the task variables from the result.", paramType="query"), @ApiImplicitParam(name="variableName", dataType="string", value="The variable name of the historic variable instance.", paramType="query"), @ApiImplicitParam(name="variableNameLike", dataType="string", value="The variable name using the like operator for the historic variable instance.", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that historic variable instances could be queried."), @ApiResponse(code=400, message="Indicates an parameter was passed in the wrong format. The status-message contains additional information.")})
    @RequestMapping(value={"/history/historic-variable-instances"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getHistoricActivityInstances(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        HistoricVariableInstanceQueryRequest query = new HistoricVariableInstanceQueryRequest();
        if (allRequestParams.get("excludeTaskVariables") != null) {
            query.setExcludeTaskVariables(Boolean.valueOf(allRequestParams.get("excludeTaskVariables")));
        }
        if (allRequestParams.get("taskId") != null) {
            query.setTaskId(allRequestParams.get("taskId"));
        }
        if (allRequestParams.get("executionId") != null) {
            query.setExecutionId(allRequestParams.get("executionId"));
        }
        if (allRequestParams.get("processInstanceId") != null) {
            query.setProcessInstanceId(allRequestParams.get("processInstanceId"));
        }
        if (allRequestParams.get("variableName") != null) {
            query.setVariableName(allRequestParams.get("variableName"));
        }
        if (allRequestParams.get("variableNameLike") != null) {
            query.setVariableNameLike(allRequestParams.get("variableNameLike"));
        }
        return this.getQueryResponse(query, allRequestParams);
    }
}

