/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseExecutionVariableResource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Executions"}, description="Manage Executions", authorizations={@Authorization(value="basicAuth")})
public class ExecutionVariableDataResource
extends BaseExecutionVariableResource {
    @RequestMapping(value={"/runtime/executions/{executionId}/variables/{variableName}/data"}, method={RequestMethod.GET})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the execution was found and the requested variables are returned."), @ApiResponse(code=404, message="Indicates the requested execution was not found or the task doesn\u2019t have a variable with the given name (in the given scope). Status message provides additional information.")})
    @ApiOperation(value="Get the binary data for an execution", tags={"Executions"}, nickname="getExecutionVariableData")
    @ResponseBody
    public byte[] getVariableData(@ApiParam(name="executionId") @PathVariable(value="executionId") String executionId, @ApiParam(name="variableName") @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = null;
            Execution execution = this.getExecutionFromRequest(executionId);
            RestVariable variable = this.getVariableFromRequest(execution, variableName, scope, true);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new ActivitiObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new ActivitiException("Error getting variable " + variableName, (Throwable)ioe);
        }
    }
}

