/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.invoker.CompositeMap;
import org.apache.maven.plugins.invoker.FileLogger;
import org.apache.maven.plugins.invoker.InvokerProperties;
import org.apache.maven.plugins.invoker.InvokerSession;
import org.apache.maven.plugins.invoker.PomUtils;
import org.apache.maven.plugins.invoker.Selector;
import org.apache.maven.plugins.invoker.SelectorUtils;
import org.apache.maven.plugins.invoker.SystemPropertyPrinter;
import org.apache.maven.plugins.invoker.model.BuildJob;
import org.apache.maven.plugins.invoker.model.io.xpp3.BuildJobXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.TrackableBase;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.scriptinterpreter.ExecutionLogger;
import org.apache.maven.shared.scriptinterpreter.RunErrorException;
import org.apache.maven.shared.scriptinterpreter.RunFailureException;
import org.apache.maven.shared.scriptinterpreter.ScriptRunner;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public abstract class AbstractInvokerMojo
extends AbstractMojo {
    private static final int RESULT_COLUMN = 60;
    @Parameter(property="invoker.skip", defaultValue="false")
    private boolean skipInvocation;
    @Parameter(defaultValue="false")
    protected boolean suppressSummaries;
    @Parameter(property="invoker.streamLogs", defaultValue="false")
    private boolean streamLogs;
    @Parameter(property="invoker.localRepositoryPath", defaultValue="${settings.localRepository}")
    private File localRepositoryPath;
    @Parameter(property="invoker.projectsDirectory", defaultValue="${basedir}/src/it/")
    private File projectsDirectory;
    @Parameter(property="invoker.reportsDirectory", defaultValue="${project.build.directory}/invoker-reports")
    private File reportsDirectory;
    @Parameter(property="invoker.disableReports", defaultValue="false")
    private boolean disableReports;
    @Parameter(property="invoker.cloneProjectsTo")
    private File cloneProjectsTo;
    @Parameter(defaultValue="false")
    private boolean cloneAllFiles;
    @Parameter(defaultValue="true")
    private boolean cloneClean;
    @Parameter(property="invoker.pom")
    private File pom;
    @Parameter
    private List<String> pomIncludes = Collections.singletonList("*/pom.xml");
    @Parameter
    private List<String> pomExcludes = Collections.emptyList();
    @Parameter
    private List<String> setupIncludes = Collections.singletonList("setup*/pom.xml");
    @Parameter
    private List<String> goals = Collections.singletonList("package");
    @Component
    private Invoker invoker;
    @Component
    private SettingsBuilder settingsBuilder;
    @Component
    private ToolchainManagerPrivate toolchainManagerPrivate;
    @Parameter(property="invoker.selectorScript", defaultValue="selector")
    private String selectorScript;
    @Parameter(property="invoker.preBuildHookScript", defaultValue="prebuild")
    private String preBuildHookScript;
    @Parameter(property="invoker.postBuildHookScript", defaultValue="postbuild")
    private String postBuildHookScript;
    @Parameter(property="invoker.testPropertiesFile", defaultValue="test.properties")
    private String testPropertiesFile;
    @Parameter
    private Map<String, String> properties;
    @Parameter(property="invoker.showErrors", defaultValue="false")
    private boolean showErrors;
    @Parameter(property="invoker.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="invoker.noLog", defaultValue="false")
    private boolean noLog;
    @Parameter
    private File logDirectory;
    @Parameter
    private List<String> profiles;
    @Parameter
    private Map<String, String> filterProperties;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(property="invoker.test")
    private String invokerTest;
    @Parameter(property="invoker.settingsFile")
    private File settingsFile;
    @Parameter(property="invoker.mavenOpts")
    private String mavenOpts;
    @Parameter(property="invoker.mavenHome")
    private File mavenHome;
    @Parameter(property="invoker.mavenExecutable")
    private String mavenExecutable;
    @Parameter(property="invoker.javaHome")
    private File javaHome;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="invoker.addTestClassPath", defaultValue="false")
    private boolean addTestClassPath;
    @Parameter(defaultValue="${project.testClasspathElements}", readonly=true)
    private List<String> testClassPath;
    @Parameter(property="invoker.invokerPropertiesFile", defaultValue="invoker.properties")
    private String invokerPropertiesFile;
    @Parameter(property="invoker.showVersion", defaultValue="false")
    private boolean showVersion;
    @Parameter(property="invoker.parallelThreads", defaultValue="1")
    private int parallelThreads;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(property="invoker.mergeUserSettings", defaultValue="false")
    private boolean mergeUserSettings;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter
    private Map<String, String> scriptVariables;
    @Parameter(defaultValue="0", property="invoker.timeoutInSeconds")
    private int timeoutInSeconds;
    @Parameter(defaultValue="false", property="invoker.writeJunitReport")
    private boolean writeJunitReport;
    @Parameter(defaultValue="maven.invoker.it", property="invoker.junitPackageName")
    private String junitPackageName = "maven.invoker.it";
    private ScriptRunner scriptRunner;
    private String filteredPomPrefix = "interpolated-";
    private final DecimalFormat secFormat = new DecimalFormat("(0.0 s)", new DecimalFormatSymbols(Locale.ENGLISH));
    private String actualMavenVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<BuildJob> buildJobs;
        if (this.skipInvocation) {
            this.getLog().info((CharSequence)"Skipping invocation per configuration. If this is incorrect, ensure the skipInvocation parameter is not set to true.");
            return;
        }
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
        if (!this.disableReports) {
            this.setupReportsFolder();
        }
        if (this.pom == null) {
            try {
                buildJobs = this.getBuildJobs();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error retrieving POM list from includes, excludes, and projects directory. Reason: " + e.getMessage(), (Exception)e);
            }
        }
        try {
            this.projectsDirectory = this.pom.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to discover projectsDirectory from pom File parameter. Reason: " + e.getMessage(), (Exception)e);
        }
        buildJobs = Collections.singletonList(new BuildJob(this.pom.getName(), "normal"));
        if (buildJobs.isEmpty()) {
            this.doFailIfNoProjects();
            this.getLog().info((CharSequence)"No projects were selected for execution.");
            return;
        }
        this.handleScriptRunnerWithScriptClassPath();
        LinkedHashSet<String> collectedProjects = new LinkedHashSet<String>();
        for (BuildJob buildJob : buildJobs) {
            this.collectProjects(this.projectsDirectory, buildJob.getProject(), collectedProjects, true);
        }
        File projectsDir = this.projectsDirectory;
        if (this.cloneProjectsTo != null) {
            this.cloneProjects(collectedProjects);
            projectsDir = this.cloneProjectsTo;
        } else if (this.cloneProjectsTo == null && "maven-plugin".equals(this.project.getPackaging())) {
            this.cloneProjectsTo = new File(this.project.getBuild().getDirectory(), "its");
            this.cloneProjects(collectedProjects);
            projectsDir = this.cloneProjectsTo;
        } else {
            this.getLog().warn((CharSequence)"Filtering of parent/child POMs is not supported without cloning the projects");
        }
        List<BuildJob> setupBuildJobs = null;
        try {
            setupBuildJobs = this.getSetupBuildJobsFromFolders();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Failure during scanning of folders.", (Throwable)e);
        }
        if (!setupBuildJobs.isEmpty()) {
            this.getLog().info((CharSequence)("Running " + setupBuildJobs.size() + " setup job" + (setupBuildJobs.size() < 2 ? "" : "s") + ":"));
            this.runBuilds(projectsDir, setupBuildJobs, 1);
            this.getLog().info((CharSequence)"Setup done.");
        }
        List<BuildJob> nonSetupBuildJobs = this.getNonSetupJobs(buildJobs);
        this.runBuilds(projectsDir, nonSetupBuildJobs, this.parallelThreads);
        this.writeSummaryFile(nonSetupBuildJobs);
        this.processResults(new InvokerSession(nonSetupBuildJobs));
    }

    private void setupReportsFolder() throws MojoExecutionException {
        if (this.reportsDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.reportsDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failure while trying to delete " + this.reportsDirectory.getAbsolutePath(), (Exception)e);
            }
        }
        if (!this.reportsDirectory.mkdirs()) {
            throw new MojoExecutionException("Failure while creating the " + this.reportsDirectory.getAbsolutePath());
        }
    }

    private List<BuildJob> getNonSetupJobs(List<BuildJob> buildJobs) {
        LinkedList<BuildJob> result = new LinkedList<BuildJob>();
        for (BuildJob buildJob : buildJobs) {
            if (buildJob.getType().equals("setup")) continue;
            result.add(buildJob);
        }
        return result;
    }

    private void handleScriptRunnerWithScriptClassPath() {
        ArrayList<String> scriptClassPath;
        if (this.addTestClassPath) {
            scriptClassPath = new ArrayList<String>(this.testClassPath);
            for (Artifact artifact : this.pluginArtifacts) {
                scriptClassPath.remove(artifact.getFile().getAbsolutePath());
            }
        } else {
            scriptClassPath = null;
        }
        this.scriptRunner = new ScriptRunner(this.getLog());
        this.scriptRunner.setScriptEncoding(this.encoding);
        this.scriptRunner.setGlobalVariable("localRepositoryPath", (Object)this.localRepositoryPath);
        if (this.scriptVariables != null) {
            for (Map.Entry entry : this.scriptVariables.entrySet()) {
                this.scriptRunner.setGlobalVariable((String)entry.getKey(), entry.getValue());
            }
        }
        this.scriptRunner.setClassPath(scriptClassPath);
    }

    private void writeSummaryFile(List<BuildJob> buildJobs) throws MojoExecutionException {
        File summaryReportFile = new File(this.reportsDirectory, "invoker-summary.txt");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(summaryReportFile));){
            for (BuildJob buildJob : buildJobs) {
                if (buildJob.getResult().equals("success")) continue;
                writer.append(buildJob.getResult());
                writer.append(" [");
                writer.append(buildJob.getProject());
                writer.append("] ");
                if (buildJob.getFailureMessage() != null) {
                    writer.append(" ");
                    writer.append(buildJob.getFailureMessage());
                }
                writer.append("\n");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write summary report " + summaryReportFile, (Exception)e);
        }
    }

    protected void doFailIfNoProjects() throws MojoFailureException {
    }

    abstract void processResults(InvokerSession var1) throws MojoFailureException;

    private Reader newReader(File file) throws IOException {
        if (StringUtils.isNotEmpty((String)this.encoding)) {
            return ReaderFactory.newReader((File)file, (String)this.encoding);
        }
        return ReaderFactory.newPlatformReader((File)file);
    }

    private void collectProjects(File projectsDir, String projectPath, Collection<String> projectPaths, boolean included) throws MojoExecutionException {
        File pomFile = new File(projectsDir, projectPath = projectPath.replace('\\', '/'));
        if (pomFile.isDirectory()) {
            if (!(pomFile = new File(pomFile, "pom.xml")).exists()) {
                if (included) {
                    projectPaths.add(projectPath);
                }
                return;
            }
            if (!projectPath.endsWith("/")) {
                projectPath = projectPath + '/';
            }
            projectPath = projectPath + "pom.xml";
        } else if (!pomFile.isFile()) {
            return;
        }
        if (!projectPaths.add(projectPath)) {
            return;
        }
        this.getLog().debug((CharSequence)("Collecting parent/child projects of " + projectPath));
        Model model = PomUtils.loadPom(pomFile);
        try {
            String parent;
            String projectsRoot = projectsDir.getCanonicalPath();
            String projectDir = pomFile.getParent();
            String parentPath = "../pom.xml";
            if (model.getParent() != null && StringUtils.isNotEmpty((String)model.getParent().getRelativePath())) {
                parentPath = model.getParent().getRelativePath();
            }
            if ((parent = this.relativizePath(new File(projectDir, parentPath), projectsRoot)) != null) {
                this.collectProjects(projectsDir, parent, projectPaths, false);
            }
            LinkedHashSet modulePaths = new LinkedHashSet();
            modulePaths.addAll(model.getModules());
            for (org.apache.maven.model.Profile profile : model.getProfiles()) {
                modulePaths.addAll(profile.getModules());
            }
            for (String modulePath : modulePaths) {
                String module = this.relativizePath(new File(projectDir, modulePath), projectsRoot);
                if (module == null) continue;
                this.collectProjects(projectsDir, module, projectPaths, false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to analyze POM: " + pomFile, (Exception)e);
        }
    }

    private void cloneProjects(Collection<String> projectPaths) throws MojoExecutionException {
        boolean filter;
        if (!this.cloneProjectsTo.mkdirs() && this.cloneClean) {
            try {
                FileUtils.cleanDirectory((File)this.cloneProjectsTo);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not clean the cloneProjectsTo directory. Reason: " + e.getMessage(), (Exception)e);
            }
        }
        LinkedHashSet<String> dirs = new LinkedHashSet<String>();
        for (String projectPath : projectPaths) {
            if (!new File(this.projectsDirectory, projectPath).isDirectory()) {
                projectPath = this.getParentPath(projectPath);
            }
            dirs.add(projectPath);
        }
        try {
            filter = !this.cloneProjectsTo.getCanonicalFile().equals(this.projectsDirectory.getCanonicalFile());
            ArrayList<String> clonedSubpaths = new ArrayList<String>();
            for (String subpath : dirs) {
                if (!".".equals(subpath) && dirs.contains(this.getParentPath(subpath)) || AbstractInvokerMojo.alreadyCloned(subpath, clonedSubpaths)) continue;
                if (".".equals(subpath)) {
                    String cloneSubdir = this.relativizePath(this.cloneProjectsTo, this.projectsDirectory.getCanonicalPath());
                    if (cloneSubdir != null) {
                        File temp = File.createTempFile("pre-invocation-clone.", "");
                        temp.delete();
                        temp.mkdirs();
                        this.copyDirectoryStructure(this.projectsDirectory, temp);
                        FileUtils.deleteDirectory((File)new File(temp, cloneSubdir));
                        this.copyDirectoryStructure(temp, this.cloneProjectsTo);
                    } else {
                        this.copyDirectoryStructure(this.projectsDirectory, this.cloneProjectsTo);
                    }
                } else {
                    File srcDir = new File(this.projectsDirectory, subpath);
                    File dstDir = new File(this.cloneProjectsTo, subpath);
                    this.copyDirectoryStructure(srcDir, dstDir);
                }
                clonedSubpaths.add(subpath);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clone projects from: " + this.projectsDirectory + " to: " + this.cloneProjectsTo + ". Reason: " + e.getMessage(), (Exception)e);
        }
        if (filter) {
            for (String projectPath : projectPaths) {
                File extensionsFile;
                File baseDir;
                File mvnDir;
                File pomFile = new File(this.cloneProjectsTo, projectPath);
                if (pomFile.isFile()) {
                    this.buildInterpolatedFile(pomFile, pomFile);
                }
                if (!(mvnDir = new File(baseDir = pomFile.getParentFile(), ".mvn")).isDirectory() || !(extensionsFile = new File(mvnDir, "extensions.xml")).isFile()) continue;
                this.buildInterpolatedFile(extensionsFile, extensionsFile);
            }
            this.filteredPomPrefix = null;
        }
    }

    private String getParentPath(String path) {
        int lastSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        return lastSep < 0 ? "." : path.substring(0, lastSep);
    }

    private void copyDirectoryStructure(File sourceDir, File destDir) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        if (!this.cloneAllFiles) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        destDir.mkdirs();
        FileUtils.mkDirs((File)sourceDir, (String[])scanner.getIncludedDirectories(), (File)destDir);
        for (String includedFile : scanner.getIncludedFiles()) {
            File sourceFile = new File(sourceDir, includedFile);
            File destFile = new File(destDir, includedFile);
            FileUtils.copyFile((File)sourceFile, (File)destFile);
            destFile.setWritable(true);
        }
    }

    static boolean alreadyCloned(String subpath, List<String> clonedSubpaths) {
        for (String path : clonedSubpaths) {
            if (!".".equals(path) && !subpath.equals(path) && !subpath.startsWith(path + File.separator)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuilds(final File projectsDir, List<BuildJob> buildJobs, int runWithParallelThreads) throws MojoExecutionException {
        block32: {
            if (!this.localRepositoryPath.exists()) {
                this.localRepositoryPath.mkdirs();
            }
            File interpolatedSettingsFile = this.interpolateSettings(this.settingsFile);
            final File mergedSettingsFile = this.mergeSettings(interpolatedSettingsFile);
            this.actualMavenVersion = this.mavenHome != null ? SelectorUtils.getMavenVersion(this.mavenHome) : SelectorUtils.getMavenVersion();
            this.scriptRunner.setGlobalVariable("mavenVersion", (Object)this.actualMavenVersion);
            final CharSequence actualJreVersion = this.javaHome != null ? this.resolveExternalJreVersion() : SelectorUtils.getJreVersion();
            final Path projectsPath = this.projectsDirectory.toPath();
            HashSet<Object> folderGroupSet = new HashSet<Object>();
            folderGroupSet.add(Paths.get(".", new String[0]));
            for (BuildJob buildJob : buildJobs) {
                Object p = Paths.get(buildJob.getProject(), new String[0]);
                if (Files.isRegularFile(projectsPath.resolve((Path)p), new LinkOption[0])) {
                    p = p.getParent();
                }
                if (p != null) {
                    p = p.getParent();
                }
                while (p != null && folderGroupSet.add(p)) {
                    p = p.getParent();
                }
            }
            ArrayList folderGroup = new ArrayList(folderGroupSet);
            Collections.sort(folderGroup);
            final HashMap<Path, Properties> globalInvokerProperties = new HashMap<Path, Properties>();
            for (Object path : folderGroup) {
                Properties ancestorProperties = (Properties)globalInvokerProperties.get(projectsPath.resolve((Path)path).getParent());
                Path currentInvokerProperties = projectsPath.resolve((Path)path).resolve(this.invokerPropertiesFile);
                Properties currentProperties = Files.isRegularFile(currentInvokerProperties, new LinkOption[0]) ? (ancestorProperties != null ? new Properties(ancestorProperties) : new Properties()) : ancestorProperties;
                if (Files.isRegularFile(currentInvokerProperties, new LinkOption[0])) {
                    try (FileInputStream in = new FileInputStream(currentInvokerProperties.toFile());){
                        currentProperties.load(in);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Failed to read invoker properties: " + currentInvokerProperties);
                    }
                }
                if (currentProperties == null) continue;
                globalInvokerProperties.put(projectsPath.resolve((Path)path).normalize(), currentProperties);
            }
            try {
                if (runWithParallelThreads > 1) {
                    this.getLog().info((CharSequence)("use parallelThreads " + runWithParallelThreads));
                    ExecutorService executorService = Executors.newFixedThreadPool(runWithParallelThreads);
                    for (final BuildJob job : buildJobs) {
                        executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Path ancestorFolder = AbstractInvokerMojo.this.getAncestorFolder(projectsPath.resolve(job.getProject()));
                                    AbstractInvokerMojo.this.runBuild(projectsDir, job, mergedSettingsFile, AbstractInvokerMojo.this.javaHome, actualJreVersion, (Properties)globalInvokerProperties.get(ancestorFolder));
                                }
                                catch (MojoExecutionException e) {
                                    throw new RuntimeException(e.getMessage(), e);
                                }
                            }
                        });
                    }
                    try {
                        executorService.shutdown();
                        executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                        break block32;
                    }
                    catch (InterruptedException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                }
                for (BuildJob job : buildJobs) {
                    Path ancestorFolder = this.getAncestorFolder(projectsPath.resolve(job.getProject()));
                    this.runBuild(projectsDir, job, mergedSettingsFile, this.javaHome, actualJreVersion, (Properties)globalInvokerProperties.get(ancestorFolder));
                }
            }
            finally {
                if (interpolatedSettingsFile != null && this.cloneProjectsTo == null) {
                    interpolatedSettingsFile.delete();
                }
                if (mergedSettingsFile != null && mergedSettingsFile.exists()) {
                    mergedSettingsFile.delete();
                }
            }
        }
    }

    private Path getAncestorFolder(Path p) {
        Path ancestor = p;
        if (Files.isRegularFile(ancestor, new LinkOption[0])) {
            ancestor = ancestor.getParent();
        }
        if (ancestor != null) {
            ancestor = ancestor.getParent();
        }
        return ancestor;
    }

    private File interpolateSettings(File settingsFile) throws MojoExecutionException {
        File interpolatedSettingsFile = null;
        if (settingsFile != null) {
            interpolatedSettingsFile = this.cloneProjectsTo != null ? new File(this.cloneProjectsTo, "interpolated-" + settingsFile.getName()) : new File(settingsFile.getParentFile(), "interpolated-" + settingsFile.getName());
            this.buildInterpolatedFile(settingsFile, interpolatedSettingsFile);
        }
        return interpolatedSettingsFile;
    }

    private File mergeSettings(File interpolatedSettingsFile) throws MojoExecutionException {
        File mergedSettingsFile;
        Settings mergedSettings = this.settings;
        if (this.mergeUserSettings && interpolatedSettingsFile != null) {
            try {
                DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
                request.setGlobalSettingsFile(interpolatedSettingsFile);
                Settings dominantSettings = this.settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
                Settings recessiveSettings = this.cloneSettings();
                SettingsUtils.merge((Settings)dominantSettings, (Settings)recessiveSettings, (String)"user-level");
                mergedSettings = dominantSettings;
                this.getLog().debug((CharSequence)"Merged specified settings file with settings of invoking process");
            }
            catch (SettingsBuildingException e) {
                throw new MojoExecutionException("Could not read specified settings file", (Exception)((Object)e));
            }
        }
        if (this.settingsFile != null && !this.mergeUserSettings) {
            mergedSettingsFile = interpolatedSettingsFile;
        } else {
            try {
                mergedSettingsFile = this.writeMergedSettingsFile(mergedSettings);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create temporary file for invoker settings.xml", (Exception)e);
            }
        }
        return mergedSettingsFile;
    }

    private File writeMergedSettingsFile(Settings mergedSettings) throws IOException {
        File mergedSettingsFile = File.createTempFile("invoker-settings", ".xml");
        SettingsXpp3Writer settingsWriter = new SettingsXpp3Writer();
        try (FileWriter fileWriter = new FileWriter(mergedSettingsFile);){
            settingsWriter.write((Writer)fileWriter, mergedSettings);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Created temporary file for invoker settings.xml: " + mergedSettingsFile.getAbsolutePath()));
        }
        return mergedSettingsFile;
    }

    private Settings cloneSettings() {
        Settings recessiveSettings = SettingsUtils.copySettings((Settings)this.settings);
        this.resetSourceLevelSet((TrackableBase)recessiveSettings);
        for (Mirror mirror : recessiveSettings.getMirrors()) {
            this.resetSourceLevelSet((TrackableBase)mirror);
        }
        for (Server server : recessiveSettings.getServers()) {
            this.resetSourceLevelSet((TrackableBase)server);
        }
        for (Proxy proxy : recessiveSettings.getProxies()) {
            this.resetSourceLevelSet((TrackableBase)proxy);
        }
        for (Profile profile : recessiveSettings.getProfiles()) {
            this.resetSourceLevelSet((TrackableBase)profile);
        }
        return recessiveSettings;
    }

    private void resetSourceLevelSet(TrackableBase trackable) {
        try {
            ReflectionUtils.setVariableValueInObject((Object)trackable, (String)"sourceLevelSet", (Object)Boolean.FALSE);
            this.getLog().debug((CharSequence)("sourceLevelSet: " + ReflectionUtils.getValueIncludingSuperclasses((String)"sourceLevelSet", (Object)trackable)));
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private CharSequence resolveExternalJreVersion() {
        Artifact pluginArtifact = this.mojoExecution.getMojoDescriptor().getPluginDescriptor().getPluginArtifact();
        pluginArtifact.getFile();
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(new File(this.javaHome, "bin/java").getAbsolutePath());
        commandLine.createArg().setValue("-cp");
        commandLine.createArg().setFile(pluginArtifact.getFile());
        commandLine.createArg().setValue(SystemPropertyPrinter.class.getName());
        commandLine.createArg().setValue("java.version");
        final StringBuilder actualJreVersion = new StringBuilder();
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                actualJreVersion.append(line);
            }
        };
        try {
            CommandLineUtils.executeCommandLine((Commandline)commandLine, (StreamConsumer)consumer, null);
        }
        catch (CommandLineException e) {
            this.getLog().warn((CharSequence)e.getMessage());
        }
        return actualJreVersion;
    }

    private File interpolatePomFile(File pomFile, File basedir) throws MojoExecutionException {
        File interpolatedPomFile = null;
        if (pomFile != null) {
            if (StringUtils.isNotEmpty((String)this.filteredPomPrefix)) {
                interpolatedPomFile = new File(basedir, this.filteredPomPrefix + pomFile.getName());
                this.buildInterpolatedFile(pomFile, interpolatedPomFile);
            } else {
                interpolatedPomFile = pomFile;
            }
        }
        return interpolatedPomFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runBuild(File projectsDir, BuildJob buildJob, File settingsFile, File actualJavaHome, CharSequence actualJreVersion, Properties globalInvokerProperties) throws MojoExecutionException {
        File basedir;
        File pomFile = new File(projectsDir, buildJob.getProject());
        if (pomFile.isDirectory()) {
            basedir = pomFile;
            if (!(pomFile = new File(basedir, "pom.xml")).exists()) {
                pomFile = null;
            } else {
                buildJob.setProject(buildJob.getProject() + File.separator + "pom.xml");
            }
        } else {
            basedir = pomFile.getParentFile();
        }
        File interpolatedPomFile = this.interpolatePomFile(pomFile, basedir);
        this.getLog().info((CharSequence)MessageUtils.buffer().a((CharSequence)"Building: ").strong((Object)buildJob.getProject()).toString());
        InvokerProperties invokerProperties = this.getInvokerProperties(basedir, globalInvokerProperties);
        buildJob.setName(invokerProperties.getJobName());
        buildJob.setDescription(invokerProperties.getJobDescription());
        ExecutionResult executionResult = null;
        try {
            int selection = this.getSelection(invokerProperties, actualJreVersion);
            if (selection == 0) {
                boolean executed;
                long milliseconds = System.currentTimeMillis();
                try {
                    executionResult = this.runBuild(basedir, interpolatedPomFile, settingsFile, actualJavaHome, invokerProperties);
                    executed = executionResult.executed;
                }
                finally {
                    milliseconds = System.currentTimeMillis() - milliseconds;
                    buildJob.setTime((double)milliseconds / 1000.0);
                }
                if (executed) {
                    buildJob.setResult("success");
                    if (!this.suppressSummaries) {
                        this.getLog().info((CharSequence)(this.pad(buildJob).success((Object)"SUCCESS").a((Object)Character.valueOf(' ')) + this.formatTime(buildJob.getTime())));
                    }
                } else {
                    buildJob.setResult("skipped");
                    if (!this.suppressSummaries) {
                        this.getLog().info((CharSequence)(this.pad(buildJob).warning((Object)"SKIPPED").a((Object)Character.valueOf(' ')) + this.formatTime(buildJob.getTime())));
                    }
                }
            } else {
                buildJob.setResult("skipped");
                StringBuilder message = new StringBuilder();
                if (selection == 16) {
                    message.append("non-matching selectors");
                } else {
                    if ((selection & 1) != 0) {
                        message.append("Maven version");
                    }
                    if ((selection & 2) != 0) {
                        if (message.length() > 0) {
                            message.append(", ");
                        }
                        message.append("JRE version");
                    }
                    if ((selection & 4) != 0) {
                        if (message.length() > 0) {
                            message.append(", ");
                        }
                        message.append("OS");
                    }
                    if ((selection & 8) != 0) {
                        if (message.length() > 0) {
                            message.append(", ");
                        }
                        message.append("Toolchain");
                    }
                }
                if (!this.suppressSummaries) {
                    this.getLog().info((CharSequence)(this.pad(buildJob).warning((Object)"SKIPPED") + " due to " + message.toString()));
                }
                buildJob.setFailureMessage("Skipped due to " + message.toString());
            }
            this.deleteInterpolatedPomFile(interpolatedPomFile);
        }
        catch (RunErrorException e) {
            buildJob.setResult("error");
            buildJob.setFailureMessage(e.getMessage());
            if (!this.suppressSummaries) {
                this.getLog().info((CharSequence)("  " + e.getMessage()));
                this.getLog().info((CharSequence)(this.pad(buildJob).failure((Object)"ERROR").a((Object)Character.valueOf(' ')) + this.formatTime(buildJob.getTime())));
            }
            this.deleteInterpolatedPomFile(interpolatedPomFile);
            this.writeBuildReport(buildJob, executionResult);
        }
        catch (RunFailureException e2) {
            buildJob.setResult(e2.getType());
            buildJob.setFailureMessage(e2.getMessage());
            if (!this.suppressSummaries) {
                this.getLog().info((CharSequence)("  " + e2.getMessage()));
                this.getLog().info((CharSequence)(this.pad(buildJob).failure((Object)"FAILED").a((Object)Character.valueOf(' ')) + this.formatTime(buildJob.getTime())));
            }
            this.deleteInterpolatedPomFile(interpolatedPomFile);
            {
                catch (Throwable throwable) {
                    this.deleteInterpolatedPomFile(interpolatedPomFile);
                    this.writeBuildReport(buildJob, executionResult);
                    throw throwable;
                }
            }
            this.writeBuildReport(buildJob, executionResult);
        }
        this.writeBuildReport(buildJob, executionResult);
    }

    private MessageBuilder pad(BuildJob buildJob) {
        MessageBuilder buffer = MessageUtils.buffer((int)128);
        buffer.a((CharSequence)"          ");
        buffer.a((CharSequence)buildJob.getProject());
        int l = 10 + buildJob.getProject().length();
        if (l < 60) {
            buffer.a((Object)Character.valueOf(' '));
            if (++l < 60) {
                for (int i = 60 - l; i > 0; --i) {
                    buffer.a((Object)Character.valueOf('.'));
                }
            }
        }
        return buffer.a((Object)Character.valueOf(' '));
    }

    private void deleteInterpolatedPomFile(File interpolatedPomFile) {
        if (interpolatedPomFile != null && StringUtils.isNotEmpty((String)this.filteredPomPrefix)) {
            interpolatedPomFile.delete();
        }
    }

    private int getSelection(InvokerProperties invokerProperties, CharSequence actualJreVersion) {
        return new Selector(this.actualMavenVersion, actualJreVersion.toString(), this.getToolchainPrivateManager()).getSelection(invokerProperties);
    }

    private ToolchainPrivateManager getToolchainPrivateManager() {
        return new ToolchainPrivateManager(this.toolchainManagerPrivate, this.session);
    }

    private void writeBuildReport(BuildJob buildJob, ExecutionResult executionResult) throws MojoExecutionException {
        if (this.disableReports) {
            return;
        }
        String safeFileName = buildJob.getProject().replace('/', '_').replace('\\', '_').replace(' ', '_');
        if (safeFileName.endsWith("_pom.xml")) {
            safeFileName = safeFileName.substring(0, safeFileName.length() - "_pom.xml".length());
        }
        File reportFile = new File(this.reportsDirectory, "BUILD-" + safeFileName + ".xml");
        try (FileOutputStream fos = new FileOutputStream(reportFile);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, buildJob.getModelEncoding());){
            BuildJobXpp3Writer writer = new BuildJobXpp3Writer();
            writer.write(osw, buildJob);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write build report " + reportFile, (Exception)e);
        }
        if (this.writeJunitReport) {
            this.writeJunitReport(buildJob, safeFileName, executionResult);
        }
    }

    private void writeJunitReport(BuildJob buildJob, String safeFileName, ExecutionResult executionResult) throws MojoExecutionException {
        File reportFile = new File(this.reportsDirectory, "TEST-" + safeFileName + ".xml");
        Xpp3Dom testsuite = new Xpp3Dom("testsuite");
        testsuite.setAttribute("name", this.junitPackageName + "." + safeFileName);
        testsuite.setAttribute("time", Double.toString(buildJob.getTime()));
        testsuite.setAttribute("tests", "1");
        testsuite.setAttribute("errors", "0");
        testsuite.setAttribute("skipped", "0");
        testsuite.setAttribute("failures", "0");
        Xpp3Dom testcase = new Xpp3Dom("testcase");
        testsuite.addChild(testcase);
        switch (buildJob.getResult()) {
            case "success": {
                break;
            }
            case "skipped": {
                testsuite.setAttribute("skipped", "1");
                Xpp3Dom skipped = new Xpp3Dom("skipped");
                testcase.addChild(skipped);
                skipped.setValue(buildJob.getFailureMessage());
                break;
            }
            case "error": {
                testsuite.setAttribute("errors", "1");
                break;
            }
            default: {
                testsuite.setAttribute("failures", "1");
                Xpp3Dom failure = new Xpp3Dom("failure");
                testcase.addChild(failure);
                failure.setAttribute("message", buildJob.getFailureMessage());
            }
        }
        testcase.setAttribute("classname", this.junitPackageName + "." + safeFileName);
        testcase.setAttribute("name", safeFileName);
        testcase.setAttribute("time", Double.toString(buildJob.getTime()));
        Xpp3Dom systemOut = new Xpp3Dom("system-out");
        testcase.addChild(systemOut);
        if (executionResult != null && executionResult.fileLogger != null) {
            this.getLog().info((CharSequence)("fileLogger:" + executionResult.fileLogger.getOutputFile()));
            try {
                systemOut.setValue(FileUtils.fileRead((File)executionResult.fileLogger.getOutputFile()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read logfile " + executionResult.fileLogger.getOutputFile(), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)(safeFileName + ", executionResult:" + executionResult));
        }
        try (FileOutputStream fos = new FileOutputStream(reportFile);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, buildJob.getModelEncoding());){
            Xpp3DomWriter.write((Writer)osw, (Xpp3Dom)testsuite);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write JUnit build report " + reportFile, (Exception)e);
        }
    }

    private String formatTime(double seconds) {
        return this.secFormat.format(seconds);
    }

    private ExecutionResult runBuild(File basedir, File pomFile, File settingsFile, File actualJavaHome, InvokerProperties invokerProperties) throws MojoExecutionException, RunFailureException {
        if (this.getLog().isDebugEnabled() && !invokerProperties.getProperties().isEmpty()) {
            Properties props = invokerProperties.getProperties();
            this.getLog().debug((CharSequence)"Using invoker properties:");
            for (String key : new TreeSet<String>(props.stringPropertyNames())) {
                String value = props.getProperty(key);
                this.getLog().debug((CharSequence)("  " + key + " = " + value));
            }
        }
        List<String> goals = this.getGoals(basedir);
        List<String> profiles = this.getProfiles(basedir);
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
        FileLogger logger = this.setupBuildLogFile(basedir);
        boolean selectorResult = true;
        ExecutionResult executionResult = new ExecutionResult();
        try {
            try {
                this.scriptRunner.run("selector script", basedir, this.selectorScript, context, (ExecutionLogger)logger, "skipped", false);
            }
            catch (RunErrorException e) {
                selectorResult = false;
                throw e;
            }
            catch (RunFailureException e) {
                selectorResult = false;
                executionResult.executed = false;
                ExecutionResult executionResult2 = executionResult;
                if (selectorResult) {
                    this.runPostBuildHook(basedir, context, logger);
                }
                if (logger != null) {
                    logger.close();
                }
                return executionResult2;
            }
            this.scriptRunner.run("pre-build script", basedir, this.preBuildHookScript, context, (ExecutionLogger)logger, "failure-pre-hook", false);
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setLocalRepositoryDirectory(this.localRepositoryPath);
            request.setBatchMode(true);
            request.setShowErrors(this.showErrors);
            request.setDebug(this.debug);
            request.setShowVersion(this.showVersion);
            this.setupLoggerForBuildJob(logger, (InvocationRequest)request);
            if (this.mavenHome != null) {
                this.invoker.setMavenHome(this.mavenHome);
                request.addShellEnvironment("M2_HOME", this.mavenHome.getAbsolutePath());
            }
            if (this.mavenExecutable != null) {
                this.invoker.setMavenExecutable(new File(this.mavenExecutable));
            }
            if (actualJavaHome != null) {
                request.setJavaHome(actualJavaHome);
            }
            if (this.environmentVariables != null) {
                for (Map.Entry<String, String> variable : this.environmentVariables.entrySet()) {
                    request.addShellEnvironment(variable.getKey(), variable.getValue());
                }
            }
            int invocationIndex = 1;
            while (invocationIndex <= 1 || invokerProperties.isInvocationDefined(invocationIndex)) {
                request.setBaseDirectory(basedir);
                request.setPomFile(pomFile);
                request.setGoals(goals);
                request.setProfiles(profiles);
                request.setMavenOpts(this.mavenOpts);
                request.setOffline(false);
                int timeOut = invokerProperties.getTimeoutInSeconds(invocationIndex);
                request.setTimeoutInSeconds(timeOut < 0 ? this.timeoutInSeconds : timeOut);
                String customSettingsFile = invokerProperties.getSettingsFile(invocationIndex);
                if (customSettingsFile != null) {
                    File interpolateSettingsFile = this.interpolateSettings(new File(customSettingsFile));
                    File mergeSettingsFile = this.mergeSettings(interpolateSettingsFile);
                    request.setUserSettingsFile(mergeSettingsFile);
                } else {
                    request.setUserSettingsFile(settingsFile);
                }
                Properties systemProperties = this.getSystemProperties(basedir, invokerProperties.getSystemPropertiesFile(invocationIndex));
                request.setProperties(systemProperties);
                invokerProperties.configureInvocation((InvocationRequest)request, invocationIndex);
                if (this.getLog().isDebugEnabled()) {
                    try {
                        this.getLog().debug((CharSequence)("Using MAVEN_OPTS: " + request.getMavenOpts()));
                        this.getLog().debug((CharSequence)("Executing: " + new MavenCommandLineBuilder().build((InvocationRequest)request)));
                    }
                    catch (CommandLineConfigurationException e) {
                        this.getLog().debug((CharSequence)("Failed to display command line: " + e.getMessage()));
                    }
                }
                try {
                    InvocationResult result = this.invoker.execute((InvocationRequest)request);
                    this.verify(result, invocationIndex, invokerProperties, logger);
                }
                catch (MavenInvocationException e) {
                    this.getLog().debug((CharSequence)("Error invoking Maven: " + e.getMessage()), (Throwable)e);
                    throw new RunFailureException("Maven invocation failed. " + e.getMessage(), "failure-build");
                }
                ++invocationIndex;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            if (selectorResult) {
                this.runPostBuildHook(basedir, context, logger);
            }
            if (logger != null) {
                logger.close();
            }
        }
        executionResult.executed = true;
        executionResult.fileLogger = logger;
        return executionResult;
    }

    private void runPostBuildHook(File basedir, Map<String, Object> context, FileLogger logger) throws MojoExecutionException, RunFailureException {
        try {
            this.scriptRunner.run("post-build script", basedir, this.postBuildHookScript, context, (ExecutionLogger)logger, "failure-post-hook", true);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void setupLoggerForBuildJob(FileLogger logger, InvocationRequest request) {
        if (logger != null) {
            request.setErrorHandler((InvocationOutputHandler)logger);
            request.setOutputHandler((InvocationOutputHandler)logger);
        }
    }

    private FileLogger setupBuildLogFile(File basedir) throws MojoExecutionException {
        FileLogger logger = null;
        if (!this.noLog) {
            Path projectLogDirectory = this.logDirectory == null ? basedir.toPath() : (this.cloneProjectsTo != null ? this.logDirectory.toPath().resolve(this.cloneProjectsTo.toPath().relativize(basedir.toPath())) : this.logDirectory.toPath().resolve(this.projectsDirectory.toPath().relativize(basedir.toPath())));
            try {
                logger = this.streamLogs ? new FileLogger(projectLogDirectory.resolve("build.log").toFile(), this.getLog()) : new FileLogger(projectLogDirectory.resolve("build.log").toFile());
                this.getLog().debug((CharSequence)("Build log initialized in: " + projectLogDirectory));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error initializing build logfile in: " + projectLogDirectory, (Exception)e);
            }
        }
        return logger;
    }

    private Properties getSystemProperties(File basedir, String filename) throws MojoExecutionException {
        Properties collectedTestProperties = new Properties();
        if (this.properties != null) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                if (entry.getValue() == null) continue;
                collectedTestProperties.put(entry.getKey(), entry.getValue());
            }
        }
        File propertiesFile = null;
        if (filename != null) {
            propertiesFile = new File(basedir, filename);
        } else if (this.testPropertiesFile != null) {
            propertiesFile = new File(basedir, this.testPropertiesFile);
        }
        if (propertiesFile != null && propertiesFile.isFile()) {
            try (FileInputStream fin = new FileInputStream(propertiesFile);){
                Properties loadedProperties = new Properties();
                loadedProperties.load(fin);
                collectedTestProperties.putAll((Map<?, ?>)loadedProperties);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading system properties from " + propertiesFile);
            }
        }
        return collectedTestProperties;
    }

    private void verify(InvocationResult result, int invocationIndex, InvokerProperties invokerProperties, FileLogger logger) throws RunFailureException {
        if (result.getExecutionException() != null) {
            throw new RunFailureException("The Maven invocation failed. " + result.getExecutionException().getMessage(), "error");
        }
        if (!invokerProperties.isExpectedResult(result.getExitCode(), invocationIndex)) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("The build exited with code ").append(result.getExitCode()).append(". ");
            if (logger != null) {
                buffer.append("See ");
                buffer.append(logger.getOutputFile().getAbsolutePath());
                buffer.append(" for details.");
            } else {
                buffer.append("See console output for details.");
            }
            throw new RunFailureException(buffer.toString(), "failure-build");
        }
    }

    List<String> getGoals(File basedir) throws MojoExecutionException {
        try {
            return this.getTokens(basedir, null, this.goals);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error reading goals", (Exception)e);
        }
    }

    List<String> getProfiles(File basedir) throws MojoExecutionException {
        try {
            return this.getTokens(basedir, null, this.profiles);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error reading profiles", (Exception)e);
        }
    }

    private List<String> calculateExcludes() throws IOException {
        String exclude;
        ArrayList<String> excludes;
        ArrayList<String> arrayList = excludes = this.pomExcludes != null ? new ArrayList<String>(this.pomExcludes) : new ArrayList();
        if (this.settingsFile != null && (exclude = this.relativizePath(this.settingsFile, this.projectsDirectory.getCanonicalPath())) != null) {
            excludes.add(exclude.replace('\\', '/'));
            this.getLog().debug((CharSequence)("Automatically excluded " + exclude + " from project scanning"));
        }
        return excludes;
    }

    private List<BuildJob> getSetupBuildJobsFromFolders() throws IOException, MojoExecutionException {
        List<String> excludes = this.calculateExcludes();
        List<BuildJob> setupPoms = this.scanProjectsDirectory(this.setupIncludes, excludes, "setup");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Setup projects: " + setupPoms));
        }
        return setupPoms;
    }

    List<BuildJob> getBuildJobs() throws IOException, MojoExecutionException {
        List<BuildJob> buildJobs;
        if (this.invokerTest == null) {
            List<String> excludes = this.calculateExcludes();
            List<BuildJob> setupPoms = this.scanProjectsDirectory(this.setupIncludes, excludes, "setup");
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Setup projects: " + Arrays.asList(setupPoms)));
            }
            List<BuildJob> normalPoms = this.scanProjectsDirectory(this.pomIncludes, excludes, "normal");
            LinkedHashMap<String, BuildJob> uniquePoms = new LinkedHashMap<String, BuildJob>();
            for (BuildJob setupPom : setupPoms) {
                uniquePoms.put(setupPom.getProject(), setupPom);
            }
            for (BuildJob normalPom : normalPoms) {
                if (uniquePoms.containsKey(normalPom.getProject())) continue;
                uniquePoms.put(normalPom.getProject(), normalPom);
            }
            buildJobs = new ArrayList(uniquePoms.values());
        } else {
            String[] testRegexes = StringUtils.split((String)this.invokerTest, (String)",");
            ArrayList<String> includes = new ArrayList<String>(testRegexes.length);
            ArrayList<String> excludes = new ArrayList<String>();
            for (String regex : testRegexes) {
                if (regex.startsWith("!")) {
                    excludes.add(regex.substring(1));
                    continue;
                }
                includes.add(regex);
            }
            buildJobs = this.scanProjectsDirectory(includes, excludes, "direct");
        }
        this.relativizeProjectPaths(buildJobs);
        return buildJobs;
    }

    private List<BuildJob> scanProjectsDirectory(List<String> includes, List<String> excludes, String type) throws IOException, MojoExecutionException {
        if (!this.projectsDirectory.isDirectory()) {
            return Collections.emptyList();
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.projectsDirectory.getCanonicalFile());
        scanner.setFollowSymlinks(false);
        if (includes != null) {
            scanner.setIncludes(includes.toArray(new String[includes.size()]));
        }
        if (excludes != null) {
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        LinkedHashMap<String, BuildJob> matches = new LinkedHashMap<String, BuildJob>();
        for (String includedFile : scanner.getIncludedFiles()) {
            matches.put(includedFile, new BuildJob(includedFile, type));
        }
        for (String includedDir : scanner.getIncludedDirectories()) {
            String includedFile = includedDir + File.separatorChar + "pom.xml";
            if (new File(scanner.getBasedir(), includedFile).isFile()) {
                matches.put(includedFile, new BuildJob(includedFile, type));
                continue;
            }
            matches.put(includedDir, new BuildJob(includedDir, type));
        }
        ArrayList<BuildJob> projects = new ArrayList<BuildJob>(matches.size());
        for (BuildJob buildJob : matches.values()) {
            InvokerProperties invokerProperties = this.getInvokerProperties(new File(this.projectsDirectory, buildJob.getProject()).getParentFile(), null);
            buildJob.setOrdinal(invokerProperties.getOrdinal());
            projects.add(buildJob);
        }
        Collections.sort(projects, OrdinalComparator.INSTANCE);
        return projects;
    }

    private void relativizeProjectPaths(List<BuildJob> buildJobs) throws IOException {
        String projectsDirPath = this.projectsDirectory.getCanonicalPath();
        for (BuildJob buildJob : buildJobs) {
            String relativizedPath;
            String projectPath = buildJob.getProject();
            File file = new File(projectPath);
            if (!file.isAbsolute()) {
                file = new File(this.projectsDirectory, projectPath);
            }
            if ((relativizedPath = this.relativizePath(file, projectsDirPath)) == null) {
                relativizedPath = projectPath;
            }
            buildJob.setProject(relativizedPath);
        }
    }

    private String relativizePath(File path, String basedir) throws IOException {
        String relativizedPath = path.getCanonicalPath();
        if (relativizedPath.startsWith(basedir)) {
            if ((relativizedPath = relativizedPath.substring(basedir.length())).startsWith(File.separator)) {
                relativizedPath = relativizedPath.substring(File.separator.length());
            }
            return relativizedPath;
        }
        return null;
    }

    private Map<String, Object> getInterpolationValueSource(boolean escapeXml) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.filterProperties != null) {
            props.putAll(this.filterProperties);
        }
        props.put("basedir", this.project.getBasedir().getAbsolutePath());
        props.put("baseurl", AbstractInvokerMojo.toUrl(this.project.getBasedir().getAbsolutePath()));
        if (this.settings.getLocalRepository() != null) {
            props.put("localRepository", this.settings.getLocalRepository());
            props.put("localRepositoryUrl", AbstractInvokerMojo.toUrl(this.settings.getLocalRepository()));
        }
        return new CompositeMap(this.project, props, escapeXml);
    }

    private static String toUrl(String filename) {
        String url = "file://" + new File(filename).toURI().getPath();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private List<String> getTokens(File basedir, String filename, List<String> defaultTokens) throws IOException {
        File tokenFile;
        List<String> tokens;
        ArrayList<String> arrayList = tokens = defaultTokens != null ? defaultTokens : new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)filename) && (tokenFile = new File(basedir, filename)).exists()) {
            tokens = this.readTokens(tokenFile);
        }
        return tokens;
    }

    private List<String> readTokens(File tokenFile) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, Object> composite = this.getInterpolationValueSource(false);
        try (BufferedReader reader = new BufferedReader((Reader)new InterpolationFilterReader(this.newReader(tokenFile), composite));){
            String line = reader.readLine();
            while (line != null) {
                result.addAll(this.collectListFromCSV(line));
                line = reader.readLine();
            }
        }
        return result;
    }

    private List<String> collectListFromCSV(String csv) {
        ArrayList<String> result = new ArrayList<String>();
        if (csv != null && csv.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(csv, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    void buildInterpolatedFile(File originalFile, File interpolatedFile) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Interpolate " + originalFile.getPath() + " to " + interpolatedFile.getPath()));
        try {
            String xml;
            Map<String, Object> composite = this.getInterpolationValueSource(true);
            try (InterpolationFilterReader reader = new InterpolationFilterReader((Reader)ReaderFactory.newXmlReader((File)originalFile), composite, "@", "@");){
                xml = IOUtil.toString((Reader)reader);
            }
            var6_5 = null;
            try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)interpolatedFile);){
                interpolatedFile.getParentFile().mkdirs();
                writer.write(xml);
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to interpolate file " + originalFile.getPath(), (Exception)e);
        }
    }

    private InvokerProperties getInvokerProperties(File projectDirectory, Properties globalInvokerProperties) throws MojoExecutionException {
        Properties props = globalInvokerProperties != null ? new Properties(globalInvokerProperties) : new Properties();
        File propertiesFile = new File(projectDirectory, this.invokerPropertiesFile);
        if (propertiesFile.isFile()) {
            try {
                FileInputStream in = new FileInputStream(propertiesFile);
                Object object = null;
                try {
                    props.load(in);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)in).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read invoker properties: " + propertiesFile, (Exception)e);
            }
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(this.getInterpolationValueSource(false)));
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            try {
                value = interpolator.interpolate(value, "");
            }
            catch (InterpolationException e) {
                throw new MojoExecutionException("Failed to interpolate invoker properties: " + propertiesFile, (Exception)((Object)e));
            }
            props.setProperty(key, value);
        }
        return new InvokerProperties(props);
    }

    protected boolean isParallelRun() {
        return this.parallelThreads > 1;
    }

    static class ToolchainPrivateManager {
        private ToolchainManagerPrivate manager;
        private MavenSession session;

        ToolchainPrivateManager(ToolchainManagerPrivate manager, MavenSession session) {
            this.manager = manager;
            this.session = session;
        }

        ToolchainPrivate[] getToolchainPrivates(String type) throws MisconfiguredToolchainException {
            return this.manager.getToolchainsForType(type, this.session);
        }
    }

    private static class OrdinalComparator
    implements Comparator {
        private static final OrdinalComparator INSTANCE = new OrdinalComparator();

        private OrdinalComparator() {
        }

        public int compare(Object o1, Object o2) {
            return Integer.compare(((BuildJob)o2).getOrdinal(), ((BuildJob)o1).getOrdinal());
        }
    }

    private static class ExecutionResult {
        boolean executed;
        FileLogger fileLogger;

        private ExecutionResult() {
        }

        public String toString() {
            return "ExecutionResult{executed=" + this.executed + ", fileLogger=" + (Object)((Object)this.fileLogger) + '}';
        }
    }
}

