/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.services.ServiceRegistryProperties;
import org.apereo.cas.services.JsonServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlan;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.replication.RegisteredServiceReplicationStrategy;
import org.apereo.cas.services.resource.RegisteredServiceResourceNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="jsonServiceRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfigureOrder(value=-2147483647)
@ConditionalOnProperty(prefix="cas.serviceRegistry.json", name={"location"})
public class JsonServiceRegistryConfiguration
implements ServiceRegistryExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonServiceRegistryConfiguration.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="registeredServiceReplicationStrategy")
    private RegisteredServiceReplicationStrategy registeredServiceReplicationStrategy;
    @Autowired
    @Qualifier(value="registeredServiceResourceNamingStrategy")
    private RegisteredServiceResourceNamingStrategy resourceNamingStrategy;

    @Bean
    public ServiceRegistry jsonServiceRegistry() {
        ServiceRegistryProperties registry = this.casProperties.getServiceRegistry();
        return new JsonServiceRegistry(registry.getJson().getLocation(), registry.isWatcherEnabled(), this.eventPublisher, this.registeredServiceReplicationStrategy, this.resourceNamingStrategy);
    }

    public void configureServiceRegistry(ServiceRegistryExecutionPlan plan) {
        plan.registerServiceRegistry(this.jsonServiceRegistry());
    }
}

