/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.utils.Constant;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.impl.AbstractOutputStream;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.http.server.impl.WebSocketResponseImpl;

final class WebSocketOutputStream
extends AbstractOutputStream {
    private final HttpServerConfiguration configuration;

    public WebSocketOutputStream(WebSocketRequestImpl webSocketRequest, WebSocketResponseImpl response) {
        super(webSocketRequest.request, response);
        this.configuration = this.request.getConfiguration();
        this.disableChunked();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (this.configuration.getWsIdleTimeout() > 0L || this.configuration.getHttpIdleTimeout() > 0L) {
            ((Request)this.request).setLatestIo(System.currentTimeMillis());
        }
    }

    @Override
    protected void writeHeadPart(boolean hasHeader) throws IOException {
        this.writeString(this.request.getProtocol().getProtocol());
        this.writeBuffer.writeByte((byte)32);
        HttpStatus httpStatus = this.response.getHttpStatus();
        httpStatus.write(this.writeBuffer);
        this.writeString(HeaderNameEnum.CONTENT_TYPE.getName());
        this.writeBuffer.writeByte((byte)58);
        this.writeString(this.response.getContentType());
        this.writeBuffer.write(Constant.CRLF_BYTES);
        if (!hasHeader) {
            this.writeBuffer.write(Constant.CRLF_BYTES);
        }
    }
}

