/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.transport.IMcpHttpServerTransport;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.server.transport.WebRxSseServerTransportProvider;
import io.modelcontextprotocol.server.transport.WebRxStreamableServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProviderBase;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.mcp.server.McpServerProperties;
import org.noear.solon.ai.mcp.server.annotation.McpServerEndpoint;
import org.noear.solon.ai.mcp.server.manager.PromptMcpServerManager;
import org.noear.solon.ai.mcp.server.manager.ResourceMcpServerManager;
import org.noear.solon.ai.mcp.server.manager.ToolMcpServerManager;
import org.noear.solon.ai.mcp.server.prompt.FunctionPrompt;
import org.noear.solon.ai.mcp.server.prompt.PromptProvider;
import org.noear.solon.ai.mcp.server.resource.FunctionResource;
import org.noear.solon.ai.mcp.server.resource.ResourceProvider;
import org.noear.solon.core.Props;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpServerEndpointProvider
implements LifecycleBean {
    private static Logger log = LoggerFactory.getLogger(McpServerEndpointProvider.class);
    private final McpServerTransportProviderBase mcpTransportProvider;
    private final McpServer.SyncSpecification mcpServerSpec;
    private final McpServerProperties serverProperties;
    private final PromptMcpServerManager promptManager = new PromptMcpServerManager();
    private final ResourceMcpServerManager resourceManager = new ResourceMcpServerManager();
    private final ToolMcpServerManager toolManager = new ToolMcpServerManager();
    private final String mcpEndpoint;
    private final String messageEndpoint;
    private McpSchema.LoggingLevel loggingLevel = McpSchema.LoggingLevel.INFO;
    private McpSyncServer server;

    public McpServerEndpointProvider(Properties properties) {
        this((McpServerProperties)Props.from((Properties)properties).bindTo((Object)new McpServerProperties()));
    }

    public McpServerEndpointProvider(McpServerProperties serverProps) {
        if (Utils.isEmpty((String)serverProps.getChannel())) {
            throw new IllegalArgumentException("The channel is required");
        }
        if (serverProps.getContextPath() == null && Solon.app() != null) {
            serverProps.setContextPath(Solon.cfg().serverContextPath());
        }
        this.serverProperties = serverProps;
        if ("sse".equals(serverProps.getChannel())) {
            this.mcpEndpoint = Utils.isEmpty((String)serverProps.getSseEndpoint()) ? serverProps.getMcpEndpoint() : serverProps.getSseEndpoint();
            Assert.notEmpty((String)this.mcpEndpoint, (String)"MCP sse endpoint is empty");
            this.messageEndpoint = Utils.isEmpty((String)serverProps.getMessageEndpoint()) ? PathUtil.joinUri((String)this.mcpEndpoint, (String)"/message") : serverProps.getMessageEndpoint();
        } else if ("streamable".equals(serverProps.getChannel())) {
            this.mcpEndpoint = Utils.isEmpty((String)serverProps.getMcpEndpoint()) ? serverProps.getSseEndpoint() : serverProps.getMcpEndpoint();
            Assert.notEmpty((String)this.mcpEndpoint, (String)"MCP endpoint is empty");
            this.messageEndpoint = this.mcpEndpoint;
        } else {
            this.mcpEndpoint = null;
            this.messageEndpoint = null;
        }
        McpSchema.ServerCapabilities serverCapabilities = McpSchema.ServerCapabilities.builder().tools(true).resources(true, true).prompts(true).logging().build();
        if ("stdio".equalsIgnoreCase(serverProps.getChannel())) {
            this.mcpTransportProvider = new StdioServerTransportProvider();
            this.mcpServerSpec = McpServer.sync((StdioServerTransportProvider)this.mcpTransportProvider).capabilities(serverCapabilities).serverInfo(serverProps.getName(), serverProps.getVersion());
        } else if ("sse".equals(serverProps.getChannel())) {
            this.mcpTransportProvider = WebRxSseServerTransportProvider.builder().sseEndpoint(this.mcpEndpoint).messageEndpoint(this.messageEndpoint).baseUrl(serverProps.getContextPath()).keepAliveInterval(serverProps.getHeartbeatInterval()).objectMapper(new ObjectMapper()).build();
            this.mcpServerSpec = McpServer.sync((WebRxSseServerTransportProvider)this.mcpTransportProvider).capabilities(serverCapabilities).serverInfo(serverProps.getName(), serverProps.getVersion());
        } else {
            this.mcpTransportProvider = WebRxStreamableServerTransportProvider.builder().mcpEndpoint(this.mcpEndpoint).keepAliveInterval(serverProps.getHeartbeatInterval()).objectMapper(new ObjectMapper()).build();
            this.mcpServerSpec = McpServer.sync((WebRxStreamableServerTransportProvider)this.mcpTransportProvider).capabilities(serverCapabilities).serverInfo(serverProps.getName(), serverProps.getVersion());
        }
    }

    @Nullable
    public McpSyncServer getServer() {
        return this.server;
    }

    public String getName() {
        return this.serverProperties.getName();
    }

    public String getVersion() {
        return this.serverProperties.getVersion();
    }

    public String getChannel() {
        return this.serverProperties.getChannel();
    }

    public String getMcpEndpoint() {
        return this.mcpEndpoint;
    }

    @Deprecated
    public String getMessageEndpoint() {
        return this.messageEndpoint;
    }

    public void setLoggingLevel(McpSchema.LoggingLevel loggingLevel) {
        if (loggingLevel != null) {
            this.loggingLevel = loggingLevel;
        }
    }

    public void addResource(FunctionResource functionResource) {
        this.resourceManager.add(this.server, this.mcpServerSpec, this.serverProperties, functionResource);
    }

    public void addResource(ResourceProvider resourceProvider) {
        for (FunctionResource functionResource : resourceProvider.getResources()) {
            this.addResource(functionResource);
        }
    }

    public boolean hasResource(String resourceUri) {
        return this.resourceManager.contains(resourceUri);
    }

    public void removeResource(String resourceUri) {
        this.resourceManager.remove(this.server, resourceUri);
    }

    public void removeResource(ResourceProvider resourceProvider) {
        if (this.server != null) {
            for (FunctionResource functionResource : resourceProvider.getResources()) {
                this.removeResource(functionResource.uri());
            }
        }
    }

    public Collection<FunctionResource> getResources() {
        return this.resourceManager.all();
    }

    public void addPrompt(FunctionPrompt functionPrompt) {
        this.promptManager.add(this.server, this.mcpServerSpec, this.serverProperties, functionPrompt);
    }

    public void addPrompt(PromptProvider promptProvider) {
        for (FunctionPrompt functionPrompt : promptProvider.getPrompts()) {
            this.addPrompt(functionPrompt);
        }
    }

    public boolean hasPrompt(String promptName) {
        return this.promptManager.contains(promptName);
    }

    public void removePrompt(String promptName) {
        this.promptManager.remove(this.server, promptName);
    }

    public void removePrompt(PromptProvider promptProvider) {
        if (this.server != null) {
            for (FunctionPrompt functionPrompt : promptProvider.getPrompts()) {
                this.removePrompt(functionPrompt.name());
            }
        }
    }

    public Collection<FunctionPrompt> getPrompts() {
        return this.promptManager.all();
    }

    public void addTool(FunctionTool functionTool) {
        this.toolManager.add(this.server, this.mcpServerSpec, this.serverProperties, functionTool);
    }

    public void addTool(ToolProvider toolProvider) {
        for (FunctionTool functionTool : toolProvider.getTools()) {
            this.addTool(functionTool);
        }
    }

    public boolean hasTool(String toolName) {
        return this.toolManager.contains(toolName);
    }

    public void removeTool(String toolName) {
        this.toolManager.remove(this.server, toolName);
    }

    public void removeTool(ToolProvider toolProvider) {
        if (this.server != null) {
            for (FunctionTool functionTool : toolProvider.getTools()) {
                this.removeTool(functionTool.name());
            }
        }
    }

    public Collection<FunctionTool> getTools() {
        return this.toolManager.all();
    }

    public void start() {
    }

    public void postStart() {
        this.server = this.mcpServerSpec.build();
        this.server.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(this.loggingLevel).build());
        if ("stdio".equalsIgnoreCase(this.serverProperties.getChannel())) {
            log.info("Mcp-Server started, name={}, version={}, channel={}, toolRegistered={}, resourceRegistered={}, promptRegistered={}", new Object[]{this.serverProperties.getName(), this.serverProperties.getVersion(), this.serverProperties.getChannel(), this.toolManager.count(), this.resourceManager.count(), this.promptManager.count()});
        } else if ("sse".equalsIgnoreCase(this.serverProperties.getChannel())) {
            log.info("Mcp-Server started, name={}, version={}, channel={}, sseEndpoint={}, messageEndpoint={}, toolRegistered={}, resourceRegistered={}, promptRegistered={}", new Object[]{this.serverProperties.getName(), this.serverProperties.getVersion(), this.serverProperties.getChannel(), this.mcpEndpoint, this.messageEndpoint, this.toolManager.count(), this.resourceManager.count(), this.promptManager.count()});
        } else {
            log.info("Mcp-Server started, name={}, version={}, channel={}, mcpEndpoint={}, toolRegistered={}, resourceRegistered={}, promptRegistered={}", new Object[]{this.serverProperties.getName(), this.serverProperties.getVersion(), this.serverProperties.getChannel(), this.mcpEndpoint, this.toolManager.count(), this.resourceManager.count(), this.promptManager.count()});
        }
        if (this.mcpTransportProvider instanceof IMcpHttpServerTransport) {
            IMcpHttpServerTransport tmp = (IMcpHttpServerTransport)((Object)this.mcpTransportProvider);
            tmp.toHttpHandler(Solon.app());
        }
    }

    public boolean pause() {
        if (this.mcpTransportProvider instanceof IMcpHttpServerTransport) {
            IMcpHttpServerTransport tmp = (IMcpHttpServerTransport)((Object)this.mcpTransportProvider);
            if (Utils.isNotEmpty((Collection)Solon.app().router().getBy(tmp.getMcpEndpoint()))) {
                Solon.app().router().remove(tmp.getMcpEndpoint());
                return true;
            }
        }
        return false;
    }

    public boolean resume() {
        if (this.mcpTransportProvider instanceof IMcpHttpServerTransport) {
            IMcpHttpServerTransport tmp = (IMcpHttpServerTransport)((Object)this.mcpTransportProvider);
            if (Utils.isEmpty((Collection)Solon.app().router().getBy(tmp.getMcpEndpoint()))) {
                tmp.toHttpHandler(Solon.app());
                return true;
            }
        }
        return false;
    }

    public void stop() {
        if (this.server != null) {
            this.server.close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private McpServerProperties props = new McpServerProperties();

        public Builder from(Class<?> endpointClz, McpServerEndpoint endpointAnno) {
            String name = Solon.cfg().getByTmpl(endpointAnno.name());
            String version = Solon.cfg().getByTmpl(endpointAnno.version());
            String channel = Solon.cfg().getByTmpl(endpointAnno.channel());
            String heartbeatInterval = Solon.cfg().getByTmpl(endpointAnno.heartbeatInterval());
            String mcpEndpoint = Solon.cfg().getByTmpl(endpointAnno.mcpEndpoint());
            String sseEndpoint = Solon.cfg().getByTmpl(endpointAnno.sseEndpoint());
            String messageEndpoint = Solon.cfg().getByTmpl(endpointAnno.messageEndpoint());
            if (Utils.isEmpty((String)name)) {
                this.props.setName(endpointClz.getSimpleName());
            } else {
                this.props.setName(name);
            }
            this.props.setVersion(version);
            this.props.setChannel(channel);
            this.props.setMcpEndpoint(mcpEndpoint);
            this.props.setSseEndpoint(sseEndpoint);
            this.props.setMessageEndpoint(messageEndpoint);
            this.props.setEnableOutputSchema(endpointAnno.enableOutputSchema());
            if (Utils.isEmpty((String)heartbeatInterval)) {
                this.props.setHeartbeatInterval(null);
            } else {
                this.props.setHeartbeatInterval(ConvertUtil.durationOf((String)heartbeatInterval));
            }
            return this;
        }

        public Builder name(String name) {
            this.props.setName(name);
            return this;
        }

        public Builder version(String version) {
            this.props.setVersion(version);
            return this;
        }

        public Builder channel(String channel) {
            this.props.setChannel(channel);
            return this;
        }

        public Builder mcpEndpoint(String mcpEndpoint) {
            this.props.setMcpEndpoint(mcpEndpoint);
            return this;
        }

        @Deprecated
        public Builder sseEndpoint(String sseEndpoint) {
            this.props.setSseEndpoint(sseEndpoint);
            return this;
        }

        @Deprecated
        public Builder messageEndpoint(String messageEndpoint) {
            this.props.setMessageEndpoint(messageEndpoint);
            return this;
        }

        @Deprecated
        public Builder contextPath(String contextPath) {
            this.props.setContextPath(contextPath);
            return this;
        }

        public Builder heartbeatInterval(Duration sseHeartbeatInterval) {
            this.props.setHeartbeatInterval(sseHeartbeatInterval);
            return this;
        }

        public Builder enableOutputSchema(boolean enableOutputSchema) {
            this.props.setEnableOutputSchema(enableOutputSchema);
            return this;
        }

        public McpServerEndpointProvider build() {
            return new McpServerEndpointProvider(this.props);
        }
    }
}

