/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.snel.ConstantNode;
import org.noear.solon.expression.snel.PropertyNode;

public class SafeNavigationNode
implements Expression {
    private final Expression target;
    private final String propertyName;

    public SafeNavigationNode(Expression target, String propertyName) {
        this.target = target;
        this.propertyName = propertyName;
    }

    public Expression getTarget() {
        return this.target;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object eval(Function context) {
        Object targetValue = this.target.eval(context);
        if (targetValue == null) {
            return null;
        }
        PropertyNode propertyNode = new PropertyNode((Expression)new ConstantNode(targetValue), this.propertyName);
        return propertyNode.eval(context);
    }

    public String toString() {
        return this.target + "?." + this.propertyName;
    }
}

