/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.context;

import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.guidance.PropertiesGuidance;
import org.noear.solon.expression.guidance.ReturnGuidance;
import org.noear.solon.expression.guidance.TypeGuidance;
import org.noear.solon.expression.guidance.TypeGuidanceUnsafety;
import org.noear.solon.expression.snel.PropertyHolder;
import org.noear.solon.expression.snel.ReflectionUtil;

public class EnhanceContext<T, Slf extends EnhanceContext>
implements Function<String, Object>,
TypeGuidance,
PropertiesGuidance,
ReturnGuidance {
    protected final T target;
    protected final boolean isMap;
    private TypeGuidance typeGuidance = TypeGuidanceUnsafety.INSTANCE;
    private Properties properties;
    private boolean allowPropertyDefault = true;
    private boolean allowPropertyNesting = false;
    private boolean allowTextAsProperty = false;
    private boolean allowReturnNull = false;
    private Object lastValue;

    public EnhanceContext(T target) {
        this.target = target;
        this.isMap = target instanceof Map;
    }

    public Slf forProperties(Properties properties) {
        this.properties = properties;
        return (Slf)this;
    }

    public Slf forAllowPropertyDefault(boolean allowPropertyDefault) {
        this.allowPropertyDefault = allowPropertyDefault;
        return (Slf)this;
    }

    public Slf forAllowPropertyNesting(boolean allowPropertyNesting) {
        this.allowPropertyNesting = allowPropertyNesting;
        return (Slf)this;
    }

    public Slf forAllowTextAsProperty(boolean allowTextAsProperty) {
        this.allowTextAsProperty = allowTextAsProperty;
        return (Slf)this;
    }

    public Slf forAllowReturnNull(boolean allowReturnNull) {
        this.allowReturnNull = allowReturnNull;
        return (Slf)this;
    }

    public Slf forTypeGuidance(TypeGuidance typeGuidance) {
        this.typeGuidance = typeGuidance;
        return (Slf)this;
    }

    @Override
    public Object apply(String name) {
        if (this.target == null) {
            return null;
        }
        if ("root".equals(name)) {
            return this.target;
        }
        if ("this".equals(name)) {
            if (this.lastValue == null) {
                return this.target;
            }
            return this.lastValue;
        }
        if (this.isMap) {
            this.lastValue = ((Map)this.target).get(name);
        } else {
            PropertyHolder tmp = ReflectionUtil.getInstance().getProperty(this.target.getClass(), name);
            try {
                this.lastValue = tmp.getValue(this.target);
            }
            catch (Throwable e) {
                throw new EvaluationException("Failed to access property: " + name, e);
            }
        }
        return this.lastValue;
    }

    @Override
    public Class<?> getType(String typeName) throws EvaluationException {
        if (this.typeGuidance == null) {
            throw new EvaluationException("The current context is not supported: 'T(.)'");
        }
        return this.typeGuidance.getType(typeName);
    }

    public T getTarget() {
        return this.target;
    }

    public TypeGuidance getTypeGuidance() {
        return this.typeGuidance;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean allowPropertyDefault() {
        return this.allowPropertyDefault;
    }

    @Override
    public boolean allowPropertyNesting() {
        return this.allowPropertyNesting;
    }

    @Override
    public boolean allowTextAsProperty() {
        return this.allowTextAsProperty;
    }

    @Override
    public boolean allowReturnNull() {
        return this.allowReturnNull;
    }
}

