/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.ArithmeticOp;
import org.noear.solon.expression.snel.TemplateNode;

public class ArithmeticNode
implements Expression {
    private final ArithmeticOp operator;
    private final Expression left;
    private final Expression right;
    private final boolean leftIsTemplate;
    private final boolean rightIsTemplate;

    public ArithmeticNode(ArithmeticOp operator, Expression left, Expression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
        this.leftIsTemplate = left instanceof TemplateNode;
        this.rightIsTemplate = right instanceof TemplateNode;
    }

    public Object eval(Function context) {
        Object leftValue = this.left.eval(context);
        Object rightValue = this.right.eval(context);
        if (this.leftIsTemplate) {
            leftValue = this.getOptimizeValue(leftValue, rightValue);
        } else if (this.rightIsTemplate) {
            rightValue = this.getOptimizeValue(rightValue, leftValue);
        }
        if (this.operator == ArithmeticOp.ADD && (leftValue instanceof String || rightValue instanceof String)) {
            return String.valueOf(leftValue) + rightValue;
        }
        if (leftValue == null || rightValue == null) {
            throw new EvaluationException("Unsupported operation" + this.toString() + ": " + leftValue + " " + this.operator.getCode() + " " + rightValue);
        }
        return this.calculateNumbers((Number)leftValue, (Number)rightValue);
    }

    private Number calculateNumbers(Number a, Number b) {
        if (this.isDouble(a) || this.isDouble(b)) {
            return this.calculateAsDouble(a, b);
        }
        if (this.isFloat(a) || this.isFloat(b)) {
            return Float.valueOf(this.calculateAsFloat(a, b));
        }
        if (this.isLong(a) || this.isLong(b)) {
            return this.calculateAsLong(a, b);
        }
        return this.calculateAsInt(a, b);
    }

    private boolean isDouble(Number n) {
        return n instanceof Double;
    }

    private boolean isFloat(Number n) {
        return n instanceof Float;
    }

    private boolean isLong(Number n) {
        return n instanceof Long;
    }

    private double calculateAsDouble(Number a, Number b) {
        double aVal = a.doubleValue();
        double bVal = b.doubleValue();
        switch (this.operator) {
            case ADD: {
                return aVal + bVal;
            }
            case SUB: {
                return aVal - bVal;
            }
            case MUL: {
                return aVal * bVal;
            }
            case DIV: {
                return aVal / bVal;
            }
            case MOD: {
                return aVal % bVal;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    private float calculateAsFloat(Number a, Number b) {
        float aVal = a.floatValue();
        float bVal = b.floatValue();
        switch (this.operator) {
            case ADD: {
                return aVal + bVal;
            }
            case SUB: {
                return aVal - bVal;
            }
            case MUL: {
                return aVal * bVal;
            }
            case DIV: {
                return aVal / bVal;
            }
            case MOD: {
                return aVal % bVal;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    private long calculateAsLong(Number a, Number b) {
        long aVal = a.longValue();
        long bVal = b.longValue();
        switch (this.operator) {
            case ADD: {
                return aVal + bVal;
            }
            case SUB: {
                return aVal - bVal;
            }
            case MUL: {
                return aVal * bVal;
            }
            case DIV: {
                return aVal / bVal;
            }
            case MOD: {
                return aVal % bVal;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    private int calculateAsInt(Number a, Number b) {
        int aVal = a.intValue();
        int bVal = b.intValue();
        switch (this.operator) {
            case ADD: {
                return aVal + bVal;
            }
            case SUB: {
                return aVal - bVal;
            }
            case MUL: {
                return aVal * bVal;
            }
            case DIV: {
                return aVal / bVal;
            }
            case MOD: {
                return aVal % bVal;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    protected Object getOptimizeValue(Object val, Object ref) {
        if (val instanceof String && ref instanceof Number) {
            return this.getNumber((String)val, 0L);
        }
        return val;
    }

    protected Number getNumber(String value, Number defaultValue) {
        if (value == null && value.length() == 0) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public String toString() {
        return "(" + this.left + " " + this.operator.getCode() + " " + this.right + ")";
    }
}

