/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.web.version.PathVersionResolver;
import org.noear.solon.web.version.VersionResolver;

public class VersionFilter
implements Filter {
    private final List<VersionResolver> resolverList = new ArrayList<VersionResolver>();

    public VersionFilter useHeader(String headerName) {
        this.resolverList.add(ctx -> ctx.header(headerName));
        return this;
    }

    public VersionFilter useParam(String paramName) {
        this.resolverList.add(ctx -> ctx.param(paramName));
        return this;
    }

    public VersionFilter usePathSegment(int index) {
        this.resolverList.add(new PathVersionResolver(index));
        return this;
    }

    public VersionFilter useVersionResolver(VersionResolver ... resolvers) {
        this.resolverList.addAll(Arrays.asList(resolvers));
        return this;
    }

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        for (VersionResolver resolver : this.resolverList) {
            if (!Utils.isEmpty((String)ctx.getVersion())) break;
            ctx.setVersion(resolver.versionResolve(ctx));
        }
        chain.doFilter(ctx);
    }
}

