/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.noear.solon.core.util.SupplierEx;

public abstract class FileBase
implements Closeable {
    private SupplierEx<InputStream> contentSupplier;
    private InputStream content;
    protected String contentType;
    protected long contentSize;
    protected String name;

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getContent() {
        try {
            if (this.content == null) {
                this.content = this.contentSupplier.get();
            }
            return this.content;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.content != null) {
            this.content.close();
        }
    }

    public FileBase() {
    }

    public FileBase(String contentType, long contentSize, SupplierEx<InputStream> contentSupplier, String name) {
        this.contentType = contentType;
        this.contentSize = contentSize;
        this.contentSupplier = contentSupplier;
        this.name = name;
        Objects.requireNonNull(contentSupplier, "The content supplier cannot be null");
    }
}

