/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.noear.solon.core.util.Assert;

public class NamedThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private ThreadGroup group;
    private boolean daemon = false;
    private int priority = 5;

    public NamedThreadFactory(String namePrefix) {
        this.namePrefix = Assert.isEmpty(namePrefix) ? this.getClass().getSimpleName() + "-" : namePrefix;
    }

    public NamedThreadFactory group(ThreadGroup group) {
        this.group = group;
        return this;
    }

    public NamedThreadFactory daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public NamedThreadFactory priority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadCount.incrementAndGet());
        t.setDaemon(this.daemon);
        t.setPriority(this.priority);
        return t;
    }
}

