/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.utils;

public class ByteTree<T> {
    private static final int MAX_DEPTH = 128;
    private static final EndMatcher NULL_END_MATCHER = endByte -> false;
    private final byte value;
    private final int depth;
    private final ByteTree<T> parent;
    protected String stringValue;
    private int shift = -1;
    private ByteTree<T>[] nodes = new ByteTree[1];
    private T attach;

    public ByteTree() {
        this(null, -128);
    }

    public ByteTree(ByteTree<T> parent, byte value) {
        this.parent = parent;
        this.value = value;
        int n = this.depth = parent == null ? 0 : parent.depth + 1;
        if (this.depth > 128) {
            throw new IllegalStateException("maxDepth is 128 , current is " + this.depth);
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public ByteTree<T> search(byte[] bytes, int offset, int len, EndMatcher endMatcher) {
        return this.search(bytes, offset, len, endMatcher, true);
    }

    public ByteTree<T> search(byte[] bytes, int offset, int limit, EndMatcher endMatcher, boolean cache) {
        int i;
        ByteTree<T> byteTree = this;
        while (true) {
            ByteTree<T> b;
            if (offset >= limit) {
                return null;
            }
            if (endMatcher.match(bytes[offset])) {
                return byteTree;
            }
            i = bytes[offset] - byteTree.shift;
            if (i >= byteTree.nodes.length || i < 0 || (b = byteTree.nodes[i]) == null) break;
            byteTree = b;
            ++offset;
        }
        if (cache && byteTree.depth < 128) {
            super.addNode(bytes, offset, limit, endMatcher);
            return byteTree.search(bytes, offset, limit, endMatcher, cache);
        }
        for (i = offset; i < limit; ++i) {
            if (!endMatcher.match(bytes[i])) continue;
            int length = i - offset + byteTree.depth;
            return new VirtualByteTree(new String(bytes, offset - byteTree.depth, length), length);
        }
        return null;
    }

    public void addNode(String value, T attach) {
        byte[] bytes = value.getBytes();
        ByteTree<T> tree = this;
        while (tree.depth > 0) {
            tree = tree.parent;
        }
        ByteTree<T> leafNode = super.addNode(bytes, 0, bytes.length, NULL_END_MATCHER);
        leafNode.stringValue = value;
        leafNode.attach = attach;
    }

    public void addNode(String value) {
        this.addNode(value, null);
    }

    private ByteTree<T> addNode(byte[] value, int offset, int limit, EndMatcher endMatcher) {
        if (offset == limit) {
            return this;
        }
        if (this.depth >= 128) {
            return this;
        }
        byte b = value[offset];
        if (endMatcher.match(b)) {
            return this;
        }
        if (this.shift == -1) {
            this.shift = b;
        }
        if (b - this.shift < 0) {
            this.increase(b - this.shift);
        } else {
            this.increase(b + 1 - this.shift);
        }
        ByteTree<T> nextTree = this.nodes[b - this.shift];
        if (nextTree == null) {
            ByteTree<T> byteTree = new ByteTree<T>(this, b);
            this.nodes[b - this.shift] = byteTree;
            nextTree = byteTree;
        }
        return super.addNode(value, offset + 1, limit, endMatcher);
    }

    private void increase(int size) {
        if (size == 0) {
            size = -1;
        }
        if (size < 0) {
            ByteTree[] temp = new ByteTree[this.nodes.length - size];
            System.arraycopy(this.nodes, 0, temp, -size, this.nodes.length);
            this.nodes = temp;
            this.shift += size;
        } else if (this.nodes.length < size) {
            ByteTree[] temp = new ByteTree[size];
            System.arraycopy(this.nodes, 0, temp, 0, this.nodes.length);
            this.nodes = temp;
        }
    }

    public String getStringValue() {
        if (this.stringValue == null) {
            byte[] b = new byte[this.depth];
            ByteTree<T> tree = this;
            while (tree.depth != 0) {
                b[tree.depth - 1] = tree.value;
                tree = tree.parent;
            }
            this.stringValue = new String(b);
        }
        return this.stringValue;
    }

    public T getAttach() {
        return this.attach;
    }

    private class VirtualByteTree
    extends ByteTree<T> {
        private final int virtualDepth;

        public VirtualByteTree(String value, int depth) {
            this.stringValue = value;
            this.virtualDepth = depth;
        }

        @Override
        public int getDepth() {
            return this.virtualDepth;
        }
    }

    public static interface EndMatcher {
        public boolean match(byte var1);
    }
}

