/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;

public class WebSocketUtil {
    public static final byte OPCODE_CONTINUE = 0;
    public static final byte OPCODE_TEXT = 1;
    public static final byte OPCODE_BINARY = 2;
    public static final byte OPCODE_CLOSE = 8;
    public static final byte OPCODE_PING = 9;
    public static final byte OPCODE_PONG = 10;
    private static final byte[] maskKey = new byte[4];
    private static final SecureRandom secureRandom = new SecureRandom();

    public static void send(OutputStream outputStream, byte opCode, byte[] bytes, int offset, int len) throws IOException {
        int payloadLength;
        int maxlength = len < 126 ? 2 + len : 4 + Math.min(Short.MAX_VALUE, len);
        byte[] writBytes = new byte[maxlength];
        do {
            if ((payloadLength = len - offset) > Short.MAX_VALUE) {
                payloadLength = Short.MAX_VALUE;
            }
            int firstByte = offset + payloadLength < len ? 0 : -128;
            firstByte = offset == 0 ? (int)((byte)(firstByte | opCode)) : (int)((byte)(firstByte | 0));
            int secondByte = payloadLength < 126 ? (int)payloadLength : 126;
            writBytes[0] = firstByte;
            writBytes[1] = secondByte;
            if (secondByte == 126) {
                writBytes[2] = (byte)(payloadLength >> 8 & 0xFF);
                writBytes[3] = (byte)(payloadLength & 0xFF);
                System.arraycopy(bytes, offset, writBytes, 4, payloadLength);
            } else {
                System.arraycopy(bytes, offset, writBytes, 2, payloadLength);
            }
            outputStream.write(writBytes, 0, payloadLength < 126 ? 2 + payloadLength : 4 + payloadLength);
        } while ((offset += payloadLength) < len);
    }

    public static void sendMask(OutputStream outputStream, byte opCode, byte[] bytes, int offset, int len) throws IOException {
        int payloadLength;
        int maxlength = len < 126 ? 6 + len : 8 + Math.min(Short.MAX_VALUE, len);
        byte[] writBytes = new byte[maxlength];
        do {
            int i;
            if ((payloadLength = len - offset) > Short.MAX_VALUE) {
                payloadLength = Short.MAX_VALUE;
            }
            int firstByte = offset + payloadLength < len ? 0 : -128;
            firstByte = offset == 0 ? (int)((byte)(firstByte | opCode)) : (int)((byte)(firstByte | 0));
            int secondByte = payloadLength < 126 ? (int)payloadLength : 126;
            writBytes[0] = firstByte;
            writBytes[1] = (byte)(secondByte | 0x80);
            if (secondByte == 126) {
                writBytes[2] = (byte)(payloadLength >> 8 & 0xFF);
                writBytes[3] = (byte)(payloadLength & 0xFF);
                System.arraycopy(maskKey, 0, writBytes, 4, maskKey.length);
                for (i = 0; i < payloadLength; ++i) {
                    writBytes[8 + i] = (byte)(bytes[i] ^ maskKey[i % 4]);
                }
            } else {
                System.out.println(Arrays.toString(maskKey));
                System.arraycopy(maskKey, 0, writBytes, 2, maskKey.length);
                for (i = 0; i < payloadLength; ++i) {
                    writBytes[6 + i] = (byte)(bytes[i] ^ maskKey[i % 4]);
                }
            }
            outputStream.write(writBytes, 0, payloadLength < 126 ? 6 + payloadLength : 8 + payloadLength);
        } while ((offset += payloadLength) < len);
    }

    static {
        secureRandom.nextBytes(maskKey);
    }
}

