/*
 * Decompiled with CFR 0.152.
 */
package org.xbrl.word.server;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.xbrl.word.common.ServerContext;
import org.xbrl.word.common.StartupParams;
import org.xbrl.word.common.WordRequest;
import org.xbrl.word.common.WordRequestQueue;
import org.xbrl.word.common.WordServerBase;
import org.xbrl.word.common.db.TemplateInstaller;
import org.xbrl.word.common.exception.ServerException;
import org.xbrl.word.common.processor.WordProcessor;
import org.xbrl.word.common.processor.WordProcessorRunner;
import org.xbrl.word.server.processor.WordQueryProcessor;
import org.xbrl.word.server.processor.WordValidateProcessor;
import org.xbrl.word.template.TemplateInstallerImpl;
import system.io.Console;

public class WordReportServer
extends WordServerBase {
    private static final Logger a = Logger.getLogger(WordReportServer.class);

    public WordReportServer(StartupParams params) {
        super(params);
        this.a();
    }

    public WordReportServer() {
        super(WordReportServer.loadDefaultStartupParams());
        this.a();
    }

    private void a() {
        this.registerProcessor(WordValidateProcessor.class);
        this.registerQueryProcessor(WordQueryProcessor.class);
        this.getRepository().setTemplateInstaller((TemplateInstaller)new TemplateInstallerImpl());
    }

    protected int getRequestChannel(WordRequest req) {
        return 5;
    }

    public static void main(String[] args) throws IOException, InterruptedException, ServerException {
        WordReportServer wordReportServer = new WordReportServer(WordReportServer.loadDefaultStartupParams());
        wordReportServer.startup();
        Console.WriteLine((String)"Enter exit or quit to stop.");
        String string = Console.readLine();
        while (true) {
            if ("exit".equalsIgnoreCase(string) || "quit".equalsIgnoreCase(string)) break;
            string = Console.readLine();
        }
        wordReportServer.close();
    }

    protected Runnable newProcessRunnable(WordRequestQueue queue, WordProcessor processor, String threadName) {
        return new WordProcessorRunner(queue, processor, (ServerContext)this);
    }
}

