/*
 * Decompiled with CFR 0.152.
 */
package org.xbrl.word.server.processor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.ProtocolException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.stream.XMLStreamException;
import net.gbicc.xbrl.core.LogWatch;
import net.gbicc.xbrl.core.MsgLevel;
import net.gbicc.xbrl.core.XbrlInstance;
import net.gbicc.xbrl.core.XbrlMessage;
import net.gbicc.xbrl.db.storage.XdbConnection;
import org.apache.commons.beanutils.RowSetDynaClass;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbrl.eureka.dto.ResponseContext;
import org.xbrl.word.WordBridge;
import org.xbrl.word.common.Request;
import org.xbrl.word.common.Response;
import org.xbrl.word.common.ServerContext;
import org.xbrl.word.common.StartupParams;
import org.xbrl.word.common.WordRequest;
import org.xbrl.word.common.WordResponse;
import org.xbrl.word.common.db.DbReader;
import org.xbrl.word.common.db.TraceInfo;
import org.xbrl.word.common.exception.ValidateException;
import org.xbrl.word.common.io.FileChangedException;
import org.xbrl.word.common.io.StorageGate;
import org.xbrl.word.common.processor.WordProcessor;
import org.xbrl.word.common.processor.WordProcessorBase;
import org.xbrl.word.common.protocol.ReportInfo;
import org.xbrl.word.common.protocol.ValidateFileInfo;
import org.xbrl.word.common.protocol.ValidateFileResult;
import org.xbrl.word.common.protocol.ValidateRequest;
import org.xbrl.word.common.protocol.ValidateResponse;
import org.xbrl.word.common.protocol.ValidateResultType;
import org.xbrl.word.common.protocol.WdDataResponse;
import org.xbrl.word.common.protocol.Xbrl2DbRequest;
import org.xbrl.word.common.util.InputFile;
import org.xbrl.word.common.util.MD5Util;
import org.xbrl.word.report.ValidateResult;
import org.xbrl.word.report.WordProcessContext;
import org.xbrl.word.server.processor.WordQueryProcessor;
import org.xml.sax.InputSource;
import system.io.FastByteArrayInputStream;
import system.io.FastByteArrayOutputStream;
import system.io.IOHelper;
import system.qizx.api.ItemSequence;
import system.qizx.api.QName;
import system.qizx.util.basic.PathUtil;
import system.qizx.xdm.IQName;
import system.qizx.xquery.ResultSequence;
import system.qizx.xquery.XQValue;
import system.qizx.xquery.dt.SingleString;
import system.qizx.xquery.dt.SingleWrappedObject;

public class WordValidateProcessor
extends WordProcessorBase
implements DbReader,
WordProcessor {
    private static final Logger b = LoggerFactory.getLogger(WordValidateProcessor.class);
    private static final FastDateFormat c;
    private static final Charset d;
    static final char[] a;
    private Connection e;
    private XdbConnection f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        a = new char[]{'\u3000', ' ', '\t', '\n', '\r', '\u00a0'};
        Class<WordQueryProcessor> clazz = WordQueryProcessor.class;
        synchronized (WordQueryProcessor.class) {
            c = FastDateFormat.getInstance((String)"yyyyMMdd");
            d = Charset.forName("UTF-8");
            Arrays.sort(a);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void close() {
        this.d();
    }

    static boolean a(char c) {
        if (c > '0' && c < '9' || c == '-' || c == '.') {
            return false;
        }
        int n = 0;
        while (n < a.length) {
            if (c == a[n]) {
                return true;
            }
            ++n;
        }
        return Character.isWhitespace(c);
    }

    public RowSetDynaClass queryByParams(String sql, Map<String, Object> params) {
        ArrayList<String> arrayList = new ArrayList<String>(params.keySet());
        for (String object2 : arrayList) {
            if (object2.equals(object2.toUpperCase())) continue;
            params.put(object2.toUpperCase(), params.get(object2));
        }
        Connection connection = this.c();
        ArrayList arrayList2 = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl = false;
        int string = 0;
        while (string < sql.length()) {
            char preparedStatement = sql.charAt(string);
            if (preparedStatement == ':') {
                stringBuilder.append('?');
                bl = true;
                stringBuilder2.setLength(0);
            } else if (bl) {
                if (preparedStatement == ')') {
                    bl = false;
                    stringBuilder.append(preparedStatement);
                    arrayList2.add(stringBuilder2.toString().toUpperCase());
                } else if (WordValidateProcessor.a(preparedStatement)) {
                    bl = false;
                    stringBuilder.append(preparedStatement);
                    arrayList2.add(stringBuilder2.toString().toUpperCase());
                } else {
                    stringBuilder2.append(preparedStatement);
                }
            } else {
                stringBuilder.append(preparedStatement);
            }
            ++string;
        }
        if (bl && stringBuilder2.length() > 0) {
            arrayList2.add(stringBuilder2.toString().toUpperCase());
        }
        String string2 = stringBuilder.toString();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            RowSetDynaClass sQLException;
            preparedStatement = connection.prepareStatement(string2);
            int rowSetDynaClass = 0;
            while (rowSetDynaClass < arrayList2.size()) {
                Object sQLException2 = params.get(arrayList2.get(rowSetDynaClass));
                if (sQLException2 == null) {
                    preparedStatement.setNull(rowSetDynaClass + 1, 12);
                    System.err.println("SQL Param value not found: " + (String)arrayList2.get(rowSetDynaClass));
                    System.err.println("SQL: " + sql);
                } else if (sQLException2 instanceof String) {
                    preparedStatement.setString(rowSetDynaClass + 1, (String)sQLException2);
                } else if (sQLException2 instanceof BigDecimal) {
                    preparedStatement.setBigDecimal(rowSetDynaClass + 1, (BigDecimal)sQLException2);
                } else if (sQLException2 instanceof Integer) {
                    preparedStatement.setInt(rowSetDynaClass + 1, (Integer)sQLException2);
                } else if (sQLException2 instanceof Long) {
                    preparedStatement.setLong(rowSetDynaClass + 1, (Long)sQLException2);
                } else if (sQLException2 instanceof Date) {
                    preparedStatement.setDate(rowSetDynaClass + 1, new java.sql.Date(((Date)sQLException2).getTime()));
                } else if (sQLException2 instanceof java.sql.Date) {
                    preparedStatement.setDate(rowSetDynaClass + 1, (java.sql.Date)sQLException2);
                } else if (sQLException2 instanceof Timestamp) {
                    preparedStatement.setTimestamp(rowSetDynaClass + 1, (Timestamp)sQLException2);
                } else if (sQLException2 instanceof Double) {
                    preparedStatement.setDouble(rowSetDynaClass + 1, (Double)sQLException2);
                } else if (sQLException2 instanceof Float) {
                    preparedStatement.setFloat(rowSetDynaClass + 1, ((Float)sQLException2).floatValue());
                } else if (sQLException2 instanceof Short) {
                    preparedStatement.setShort(rowSetDynaClass + 1, (Short)sQLException2);
                } else {
                    preparedStatement.setString(rowSetDynaClass + 1, sQLException2.toString());
                }
                ++rowSetDynaClass;
            }
            resultSet = preparedStatement.executeQuery();
            RowSetDynaClass rowSetDynaClass2 = sQLException = new RowSetDynaClass(resultSet, true);
            return rowSetDynaClass2;
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                resultSet = null;
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return null;
    }

    private void a(WordProcessContext wordProcessContext) {
        String string;
        String string2;
        String string3;
        ServerContext serverContext = this.getServerContext();
        StartupParams startupParams = serverContext.getRunningParams();
        StorageGate storageGate = serverContext.getStorageGate();
        String string4 = startupParams.getProperty("jdbc.url");
        ResultSequence resultSequence = new ResultSequence((XQValue)new SingleString(string4 == null ? "" : string4));
        wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)"jdbcUrl"), (ItemSequence)resultSequence);
        string4 = startupParams.getProperty("jdbc.driverClassName");
        resultSequence = new ResultSequence((XQValue)new SingleString(string4 == null ? "" : string4));
        wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)"jdbcDriverClassName"), (ItemSequence)resultSequence);
        string4 = startupParams.getProperty("jdbc.username");
        resultSequence = new ResultSequence((XQValue)new SingleString(string4 == null ? "" : string4));
        wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)"jdbcUserName"), (ItemSequence)resultSequence);
        string4 = startupParams.getProperty("jdbc.password");
        resultSequence = new ResultSequence((XQValue)new SingleString(string4 == null ? "" : string4));
        wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)"jdbcPassword"), (ItemSequence)resultSequence);
        resultSequence = new ResultSequence((XQValue)new SingleWrappedObject((Object)storageGate.getResolveServerice()));
        wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)"ribbon"), (ItemSequence)resultSequence);
        for (String string5 : startupParams.getPropertyNames()) {
            if (!string5.startsWith("data.service.name.")) continue;
            string3 = string5.substring("data.service.name.".length()).trim();
            string2 = startupParams.getProperty(string5);
            string2 = string2 != null ? string2.trim() : "";
            string = String.valueOf(string3) + "DataService";
            resultSequence = new ResultSequence((XQValue)new SingleString(string2));
            wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)string), (ItemSequence)resultSequence);
        }
        int n = 0;
        while (n < 16) {
            String string6 = startupParams.getProperty("biz.server." + n);
            if (!StringUtils.isEmpty((String)string6) && !StringUtils.isEmpty((String)(string3 = startupParams.getProperty("biz.query." + n)))) {
                string2 = startupParams.getProperty("biz.login." + n);
                string = startupParams.getProperty("biz.loginUser." + n);
                String string7 = startupParams.getProperty("biz.loginPwd." + n);
                resultSequence = new ResultSequence((XQValue)new SingleString((String)(string6 == null ? "" : string6)));
                wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)("bizServer" + n)), (ItemSequence)resultSequence);
                resultSequence = new ResultSequence((XQValue)new SingleString(string3 == null ? "" : string3));
                wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)("bizQuery" + n)), (ItemSequence)resultSequence);
                resultSequence = new ResultSequence((XQValue)new SingleString(string2 == null ? "" : string2));
                wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)("bizLogin" + n)), (ItemSequence)resultSequence);
                resultSequence = new ResultSequence((XQValue)new SingleString(string == null ? "" : string));
                wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)("bizLoginUser" + n)), (ItemSequence)resultSequence);
                resultSequence = new ResultSequence((XQValue)new SingleString(string7 == null ? "" : string7));
                wordProcessContext.addFormulaParam((QName)IQName.get((String)"http://www.sse.com.cn/cbm", (String)("bizLoginPwd" + n)), (ItemSequence)resultSequence);
            }
            ++n;
        }
    }

    private Connection c() {
        Object object;
        Object object2;
        if (this.e != null) {
            block24: {
                object2 = null;
                try {
                    try {
                        object2 = this.e.createStatement();
                        object = this.e.getMetaData().getDatabaseProductName().toUpperCase();
                        if (((String)object).contains("ORACLE")) {
                            object2.executeQuery("select 1 from dual");
                        } else {
                            object2.executeQuery("select 1");
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            b.info("Reconnect DB ...");
                            this.e.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        this.e = null;
                        try {
                            if (object2 != null) {
                                object2.close();
                            }
                            break block24;
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (object2 != null) {
                            object2.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (this.e != null) {
                return this.e;
            }
        }
        try {
            if (this.f == null) {
                object2 = this.getServerContext();
                object = object2.getRunningParams();
                this.f = new XdbConnection();
                this.f.setUrl(object.getProperty("jdbc.url"));
                this.f.setDriverClass(object.getProperty("jdbc.driverClassName"));
                this.f.setUserName(object.getProperty("jdbc.username"));
                this.f.setPassword(object.getProperty("jdbc.password"));
            }
            Class.forName(this.f.getDriverClass());
            this.e = DriverManager.getConnection(this.f.getUrl(), this.f.getUserName(), this.f.getPassword());
            b.info("Connect DB OK.");
            if (this.e.getMetaData().getDatabaseProductName().toUpperCase().contains("ORACLE")) {
                object2 = this.e.createStatement();
                object2.executeQuery("alter session set nls_date_format = 'yyyy-mm-dd hh24:mi:ss'");
                object2.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.e;
    }

    private void d() {
        if (this.e != null) {
            try {
                this.e.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.e = null;
        }
    }

    public WordResponse process(WordRequest request) {
        a a2 = new a(request);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<WordResponse> future = executorService.submit(a2);
        try {
            int n = this.getServerContext().getRunningParams().getValidateTimeoutSeconds();
            if (n < 60) {
                n = 60;
            }
            n = 180000;
            b.info("validate timeout: {} seconds.", (Object)n);
            WordResponse wordResponse = future.get(n, TimeUnit.SECONDS);
            return wordResponse;
        }
        catch (TimeoutException timeoutException) {
            try {
                future.cancel(true);
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (a2.a != null && a2.a.isAlive()) {
                a2.a.stop();
                b.error("stop valid processor: " + request.getHandle());
            }
            WordResponse wordResponse = request.createErrorResponse("\u9a8c\u8bc1\u8d85\u65f6\u4e2d\u6b62");
            return wordResponse;
        }
        catch (ExecutionException executionException) {
            future.cancel(true);
            b.error(String.valueOf(request.getHandle()) + " executionException", (Throwable)executionException);
            WordResponse wordResponse = request.createErrorResponse("\u6267\u884c\u5f02\u5e38\u4e2d\u6b62");
            return wordResponse;
        }
        catch (InterruptedException interruptedException) {
            future.cancel(true);
            b.error(String.valueOf(request.getHandle()) + " interruptedException", (Throwable)interruptedException);
            WordResponse wordResponse = request.createErrorResponse("\u6267\u884c\u88ab\u4e2d\u6b62\uff08\u8d85\u65f6\u6216\u5176\u4ed6\u5f02\u5e38\uff09");
            return wordResponse;
        }
        catch (Exception exception) {
            future.cancel(true);
            b.error(String.valueOf(request.getHandle()) + " Exception", (Throwable)exception);
            WordResponse wordResponse = request.createErrorResponse("\u6267\u884c\u88ab\u4e2d\u6b62\uff08\u8d85\u65f6\u6216\u5176\u4ed6\u5f02\u5e38\uff09");
            return wordResponse;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    WordResponse a(WordRequest wordRequest) {
        ValidateResponse validateResponse;
        ValidateResponse validateResponse2 = new ValidateResponse();
        if (wordRequest == null || !(wordRequest instanceof ValidateRequest)) {
            validateResponse2.setValidateResult(ValidateResultType.ERROR);
            validateResponse2.setSummaryMessage("\u8bf7\u6c42\u53c2\u6570\u65e0\u6548\uff0c\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01");
            return validateResponse2;
        }
        ValidateRequest validateRequest = (ValidateRequest)wordRequest;
        ServerContext serverContext = this.getServerContext();
        String string = serverContext.getReportHome();
        String string2 = PathUtil.makePath((String)string, (String)"check");
        string2 = PathUtil.makePath((String)string2, (String)this.getCurrentYear());
        String string3 = PathUtil.makePath((String)(string2 = PathUtil.makePath((String)string2, (String)validateRequest.getCompanyCode())), (String)validateRequest.getBulletinID());
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        validateResponse2.setBulletinID(validateRequest.getBulletinID());
        validateResponse2.setValidateID(validateRequest.getValidateID());
        validateResponse2.setCompanyCode(validateRequest.getCompanyCode());
        validateResponse2.setValidateResult(ValidateResultType.WAITING);
        boolean bl = false;
        if (!validateRequest.isNoCache() && (validateResponse = this.a(validateRequest)) != null) {
            bl = true;
            validateResponse2 = validateResponse;
            validateRequest.getTraceMemo().setValidateResFile(String.valueOf(validateRequest.getValidateID()) + "_result.xml");
        }
        if (!bl) {
            this.a(validateRequest, validateResponse2, string3);
        }
        if (StringUtils.isBlank((String)validateResponse2.getCompanyCode())) {
            validateResponse2.setCompanyCode(validateRequest.getCompanyCode());
        }
        wordRequest.getTraceMemo().setResultType(validateResponse2.getValidateResult().toString());
        wordRequest.getTraceMemo().setWordFileCount(Integer.valueOf(validateRequest.getAttachments().size()));
        wordRequest.getTraceMemo().setResultMessage(validateResponse2.getSummaryMessage());
        wordRequest.getTraceMemo().setProcessEndTime(new Date());
        this.a(validateResponse2, validateRequest.getMsgFormatType());
        return validateResponse2;
    }

    private void a(ValidateResponse validateResponse, String string) {
        if ("HTML+JSON".equals(string) && validateResponse != null) {
            for (ValidateFileResult validateFileResult : validateResponse.getDefaultResponse().getAttachments()) {
                if (!StringUtils.isEmpty((String)validateFileResult.getShortValidateJson())) continue;
                String string2 = null;
                ValidateResult validateResult = new ValidateResult();
                switch (validateFileResult.getValidateResult()) {
                    case WAITING: {
                        string2 = validateFileResult.getValidateMessage();
                        if (StringUtils.isEmpty((String)string2)) {
                            string2 = "\u6b63\u5728\u5904\u7406\u4e2d...";
                        }
                        validateResult.addError(new XbrlMessage("COMMON", string2, MsgLevel.Info, null), null);
                        break;
                    }
                    case OK: {
                        string2 = validateFileResult.getValidateMessage();
                        if (StringUtils.isEmpty((String)string2)) {
                            string2 = "\u9a8c\u8bc1\u6b63\u5e38";
                        }
                        validateResult.addError(new XbrlMessage("COMMON", string2, MsgLevel.Info, null), null);
                        break;
                    }
                    case WARNING: {
                        string2 = validateFileResult.getValidateMessage();
                        if (StringUtils.isEmpty((String)string2)) {
                            string2 = "\u9a8c\u8bc1\u6709\u8b66\u544a";
                        }
                        validateResult.addError(new XbrlMessage("COMMON", string2, MsgLevel.Warning, null), null);
                        break;
                    }
                    case CANCELED: {
                        string2 = validateFileResult.getValidateMessage();
                        if (StringUtils.isEmpty((String)string2)) {
                            string2 = "\u9a8c\u8bc1\u5df2\u53d6\u6d88";
                        }
                        validateResult.addError(new XbrlMessage("COMMON", string2, MsgLevel.Info, null), null);
                        break;
                    }
                    case FATAL: 
                    case ERROR: 
                    case NOT_FOUND: 
                    case FILE_CHANGED: 
                    case FILE_NOT_FOUND: 
                    case FILE_FORMAT_ERROR: 
                    case APP_EXCEPTION: {
                        string2 = validateFileResult.getValidateMessage();
                        if (StringUtils.isEmpty((String)string2)) {
                            string2 = "\u9a8c\u8bc1\u6709\u9519\u8bef";
                        }
                        validateResult.addError(new XbrlMessage("COMMON", string2, MsgLevel.Error, null), null);
                    }
                }
                if (StringUtils.isEmpty((String)validateFileResult.getValidateHtml())) {
                    validateFileResult.setValidateHtml(validateResult.toHtml());
                }
                validateFileResult.setShortValidateJson(validateResult.toJson(false));
            }
        }
    }

    private ValidateResponse a(ValidateRequest validateRequest) {
        String string = this.getServerContext().getReportHome();
        String string2 = validateRequest.getValidateID();
        String string3 = PathUtil.makePath((String)string, (String)"check");
        int n = 0;
        while (n < 2) {
            String string4;
            String string5;
            ValidateResponse validateResponse;
            String string6 = PathUtil.makePath((String)string3, (String)this.getYear(-n));
            String string7 = validateRequest.getCompanyCode();
            if (!StringUtils.isEmpty((String)string7) && (validateResponse = this.a(validateRequest, string5 = PathUtil.makePath((String)(string4 = PathUtil.makePath((String)string6, (String)validateRequest.getCompanyCode())), (String)validateRequest.getBulletinID()), string2)) != null) {
                return validateResponse;
            }
            ++n;
        }
        return null;
    }

    private ValidateResponse a(ValidateRequest validateRequest, String string, String string2) {
        String string3 = PathUtil.makePath((String)string, (String)(String.valueOf(string2) + "_result.xml"));
        File file = new File(string3);
        if (file.exists()) {
            ValidateRequest validateRequest2;
            String string4;
            File file2 = new File(PathUtil.makePath((String)string, (String)(String.valueOf(string2) + "_req.xml")));
            if (!file2.exists()) {
                return null;
            }
            try {
                string4 = IOHelper.readAllUtf8((String)file2.getAbsolutePath());
                validateRequest2 = new ValidateRequest();
                validateRequest2.loadXml(string4);
                if (!validateRequest2.equals((Object)validateRequest)) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
            string4 = IOHelper.readAllUtf8((String)string3);
            if (!StringUtils.isEmpty((String)string4)) {
                try {
                    validateRequest2 = new ValidateResponse();
                    validateRequest2.loadXml(string4);
                    return validateRequest2;
                }
                catch (ProtocolException protocolException) {
                    protocolException.printStackTrace();
                }
                catch (XMLStreamException xMLStreamException) {
                    xMLStreamException.printStackTrace();
                }
            }
        }
        return null;
    }

    private void a(String string, boolean bl) {
        try {
            String string2;
            ServerContext serverContext = this.getServerContext();
            StorageGate storageGate = serverContext.getStorageGate();
            String string3 = storageGate.getAbsolutePath(string);
            File file = new File(string3);
            String string4 = string2 = bl ? serverContext.getRunningParams().getTransferWordSucc() : serverContext.getRunningParams().getTransferWordFail();
            if (file.exists() && !StringUtils.isEmpty((String)serverContext.getRunningParams().getTransferWordFail())) {
                File file2;
                File file3 = new File(string2);
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                if ((file2 = new File(PathUtil.makePath((String)string2, (String)IOHelper.getFileName((String)string3)))).exists()) {
                    file2.delete();
                }
                FileUtils.moveFileToDirectory((File)file, (File)file3, (boolean)true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void a(ValidateRequest validateRequest, ValidateResponse validateResponse, String string) {
        block73: {
            String string2;
            ValidateFileResult validateFileResult;
            Object object2;
            ServerContext serverContext = this.getServerContext();
            StorageGate storageGate = serverContext.getStorageGate();
            StartupParams startupParams = serverContext.getRunningParams();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = StringUtils.isNotBlank((String)validateRequest.getCompanyCode());
            boolean bl7 = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object2 : validateRequest.getAttachments()) {
                String string3;
                bl7 = startupParams.isResourceUFMS(object2.getFileIdType());
                if (!object2.isXbrlReport()) continue;
                validateFileResult = new ValidateFileResult();
                string2 = object2.getFileTitle();
                validateFileResult.setFileId(object2.getFileId());
                validateFileResult.setBulletinID(validateRequest.getBulletinID());
                validateFileResult.setFileTitle(string2);
                validateFileResult.setFileIdType(object2.getFileIdType());
                validateResponse.getAttachments().add(validateFileResult);
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append("\u201c").append(object2.getFileTitle()).append("\u201d");
                try {
                    boolean bl8 = this.isConsoleMode();
                    if (bl8) {
                        System.out.println("PROC: " + object2.getFileName());
                    }
                    string3 = StorageGate.makePath((String)object2.getFilePath(), (String)object2.getFileName());
                    InputStream inputStream = null;
                    FastByteArrayInputStream fastByteArrayInputStream = null;
                    inputStream = storageGate.getInputStream(string3, object2.getFileId(), object2.getFileSize(), object2.getFileHash(), object2.getFileAuth(), validateRequest.getSourceSystem(), bl7);
                    try {
                        Object object3;
                        Object object4;
                        WdDataResponse wdDataResponse;
                        Object object5;
                        String string4;
                        Object object6;
                        if (inputStream != null) {
                            object6 = IOHelper.toBytes((InputStream)inputStream);
                            fastByteArrayInputStream = new FastByteArrayInputStream(object6);
                        }
                        object6 = new InputFile();
                        object6.setFileTitle(object2.getFileTitle());
                        object6.setSystemId(string3);
                        object6.setByteStream((InputStream)fastByteArrayInputStream);
                        WordProcessContext wordProcessContext = new WordProcessContext();
                        wordProcessContext.setDbReader((DbReader)this);
                        wordProcessContext.setValidateRequest(validateRequest);
                        wordProcessContext.setServerContext(serverContext);
                        wordProcessContext.setValidateInstance(true);
                        wordProcessContext.setDeptCode(validateRequest.getDeptCode());
                        wordProcessContext.setSourceSystem(validateRequest.getSourceSystem());
                        this.a(wordProcessContext);
                        WordBridge wordBridge = new WordBridge();
                        wordProcessContext = wordBridge.fromWord((InputSource)object6, wordProcessContext);
                        if (!bl6) {
                            string4 = serverContext.getReportHome();
                            String string5 = PathUtil.makePath((String)string4, (String)"check");
                            string5 = PathUtil.makePath((String)string5, (String)this.getCurrentYear());
                            string = PathUtil.makePath((String)(string5 = PathUtil.makePath((String)string5, (String)validateRequest.getCompanyCode())), (String)validateRequest.getBulletinID());
                            object5 = new File(string);
                            if (!((File)object5).exists()) {
                                ((File)object5).mkdirs();
                            }
                            validateResponse.setCompanyCode(validateRequest.getCompanyCode());
                            if (bl7) {
                                if (fastByteArrayInputStream != null) {
                                    fastByteArrayInputStream.reset();
                                }
                                this.downloadFileToLocal(storageGate, validateRequest, (ValidateFileInfo)object2, (InputStream)fastByteArrayInputStream);
                                string3 = StorageGate.makePath((String)object2.getFilePath(), (String)object2.getFileName());
                            }
                        }
                        string4 = string3;
                        int n = string3.lastIndexOf(46);
                        if (n == -1) {
                            string4 = String.valueOf(string4) + ".zip";
                        } else {
                            object5 = string4.substring(0, n);
                            string4 = String.valueOf(object5) + ".zip";
                        }
                        object5 = wordProcessContext.getValidateResult();
                        object5.setTojsonInclusionAlways(startupParams.isTojsonInclusionAlways());
                        validateFileResult.setValidateMessage(object5.getTotalMessage());
                        List list = object5.getWordItems();
                        if (list != null) {
                            validateFileResult.addWordItems(list);
                            validateResponse.addWordItems(list);
                        }
                        if ((wdDataResponse = object5.getDataResponse()) != null) {
                            validateFileResult.setDataResponse(wdDataResponse);
                            validateResponse.addDataResponse(wdDataResponse);
                        }
                        String string6 = null;
                        if (wordProcessContext.getStorage() != null) {
                            Object object7;
                            Object object8;
                            object4 = new FastByteArrayOutputStream();
                            wordProcessContext.getStorage().save((OutputStream)object4);
                            if (!object5.hasFatalError()) {
                                if (!bl8) {
                                    Object object9;
                                    object3 = object4.toByteArray();
                                    if (startupParams.isXbrlFeedback()) {
                                        object8 = new ByteArrayInputStream((byte[])object3);
                                        object7 = new ResponseContext();
                                        try {
                                            storageGate.save(string4, (InputStream)object8, object7);
                                            validateFileResult.setXbrlZipFile(string4);
                                        }
                                        catch (Exception exception) {
                                            b.warn("save xbrl zip file fail,{}", (Object)exception.getMessage());
                                        }
                                        object9 = object7.responseUploadFile != null ? object7.responseUploadFile.getId() : "";
                                        validateFileResult.setXbrlZipFileId((String)object9);
                                        validateRequest.getTraceMemo().setXbrlZipFileId((String)object9);
                                    }
                                    object8 = MD5Util.md5((byte[])object3);
                                    validateFileResult.setFileHash((String)object8);
                                    validateFileResult.setFileSize(((byte[])object3).length);
                                    object7 = wordProcessContext.getKeyContent();
                                    if (object7 != null && object7.hasKeyContent()) {
                                        object7.calculateNewValues();
                                        object9 = object7.getWordItems();
                                        if (object9 != null && object9.size() > 0) {
                                            validateFileResult.mergeWordItems((List)object9);
                                            validateResponse.mergeWordItems((List)object9);
                                        }
                                        List list2 = object7.getHtmlFragments();
                                        validateFileResult.setHtmlFragments(list2);
                                        validateResponse.addHtmlFragments(list2);
                                    }
                                    if ((object9 = wordProcessContext.getValidateResult().getDataResponse()) != null) {
                                        validateFileResult.setDataResponse((WdDataResponse)object9);
                                        validateResponse.addDataResponse((WdDataResponse)object9);
                                    }
                                } else {
                                    this.a(wordProcessContext, (FastByteArrayOutputStream)object4);
                                    this.a(string3, true);
                                }
                            } else if (bl8) {
                                b.error(object5.toText());
                                this.a(string3, false);
                            }
                            string4 = StringUtils.replace((String)string4, (String)"\\", (String)File.separator);
                            string4 = StringUtils.replace((String)string4, (String)"/", (String)File.separator);
                            object3 = IOHelper.getFileName((String)string4);
                            string6 = PathUtil.makePath((String)string, (String)object3);
                            IOHelper.saveAsFile((InputStream)object4.getInputStream(), (String)string6);
                            if (StringUtils.isEmpty((String)validateFileResult.getXbrlZipFile())) {
                                validateFileResult.setXbrlZipFile(StringUtils.replaceOnce((String)string6, (String)serverContext.getReportHome(), (String)"$SSE_REPORT_HOME"));
                            }
                            object4 = null;
                            validateRequest.getTraceMemo().setWordDoc(string3);
                            validateRequest.getTraceMemo().setHtmlDoc("");
                            validateRequest.getTraceMemo().setXbrlDoc((String)object3);
                            validateRequest.getTraceMemo().setIntoMemo("");
                            validateRequest.getTraceMemo().setMemo("");
                            validateRequest.getTraceMemo().setFileId(object2.getFileId());
                            validateRequest.getTraceMemo().setAnDate(null);
                            validateRequest.getTraceMemo().setFileIdType(object2.getFileIdType());
                            validateRequest.getTraceMemo().setDeptCode(validateRequest.getDeptCode());
                            validateRequest.getTraceMemo().setSourceSystem(validateRequest.getSourceSystem());
                            object8 = wordProcessContext.getWordReport().getReportSetting();
                            validateRequest.getTraceMemo().setReportType(object8.getReportType());
                            validateRequest.getTraceMemo().setReportEndTime(DateUtils.parseDate((String)object8.getReportEndDate(), (String[])new String[]{"yyyy-MM-dd"}));
                            validateRequest.getTraceMemo().setIndustry(wordProcessContext.getWordReport().getTemplate().getIndustry());
                            if (StringUtils.isNotEmpty((String)validateRequest.getDisclosureDate())) {
                                object7 = DateUtils.parseDate((String)validateRequest.getDisclosureDate(), (String[])new String[]{"yyyy-MM-dd"});
                                validateRequest.getTraceMemo().setAnDate((Date)object7);
                            }
                            validateRequest.getTraceMemo().setCommitTime(null);
                            validateRequest.getTraceMemo().setState(Integer.valueOf(0));
                        }
                        if ("HTML".equals(validateRequest.getMsgFormatType())) {
                            validateFileResult.setValidateHtml(object5.toHtml());
                            validateFileResult.setShortValidateHtml(object5.toHtml(true));
                        } else if ("JSON".equals(validateRequest.getMsgFormatType())) {
                            validateFileResult.setValidateJson(object5.toJson());
                            validateFileResult.setShortValidateJson(object5.toJson(true));
                        } else if ("HTML+JSON".endsWith(validateRequest.getMsgFormatType())) {
                            validateFileResult.setValidateHtml(object5.toHtml());
                            validateFileResult.setShortValidateJson(object5.toJson(true));
                        } else {
                            validateFileResult.setValidateHtml(object5.toHtml());
                            validateFileResult.setShortValidateHtml(object5.toHtml(true));
                        }
                        if (object5.hasFatalError()) {
                            validateFileResult.setValidateResult(ValidateResultType.FATAL);
                            stringBuilder.append(object5.getTotalMessage());
                            bl4 = true;
                        } else if (object5.hasError()) {
                            validateFileResult.setValidateResult(ValidateResultType.ERROR);
                            stringBuilder.append(object5.getTotalMessage());
                            bl3 = true;
                        } else if (object5.hasWarning()) {
                            validateFileResult.setValidateResult(ValidateResultType.WARNING);
                            stringBuilder.append(object5.getTotalMessage());
                            bl5 = true;
                        } else {
                            validateFileResult.setValidateResult(ValidateResultType.OK);
                            stringBuilder.append(object5.getTotalMessage());
                        }
                        object4 = validateRequest.getAsyncActions();
                        if (StringUtils.isEmpty((String)object4) || !((String)object4).toUpperCase().contains("XBRL2DB")) continue;
                        try {
                            object3 = new Xbrl2DbRequest();
                            object3.setReportSetting((ReportInfo)wordBridge.getReportSetting());
                            object3.setXbrlInput(new InputSource(string6));
                            this.getServerContext().enqueAsyncRequest((Request)object3);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (ValidateException validateException) {
                    validateFileResult.setValidateResult(ValidateResultType.FATAL);
                    validateFileResult.setValidateMessage(validateException.getMessage());
                    stringBuilder.append(": ").append(validateException.getMessage());
                    bl2 = true;
                    validateResponse.setValidateResult(validateException.getResultType());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    validateFileResult.setValidateResult(ValidateResultType.FATAL);
                    string3 = "\u201c" + string2 + "\u201d\u6587\u4ef6\u672a\u627e\u5230\uff01";
                    validateFileResult.setValidateMessage(string3);
                    stringBuilder.append(": ").append(string3);
                    bl2 = true;
                    validateResponse.setValidateResult(ValidateResultType.FILE_NOT_FOUND);
                }
                catch (FileChangedException fileChangedException) {
                    validateFileResult.setValidateResult(ValidateResultType.FATAL);
                    string3 = "\u201c" + string2 + "\u201d\u6587\u4ef6\u5df2\u4fee\u6539\uff01";
                    validateFileResult.setValidateMessage(string3);
                    stringBuilder.append(": ").append(string3);
                    bl2 = true;
                    validateResponse.setValidateResult(ValidateResultType.FILE_CHANGED);
                }
                catch (Exception exception) {
                    validateFileResult.setValidateResult(ValidateResultType.FATAL);
                    string3 = exception.getMessage() == null ? exception.getClass().toString() : exception.getMessage();
                    validateFileResult.setValidateMessage(string3);
                    exception.printStackTrace();
                    stringBuilder.append(": ").append(string3);
                    bl = true;
                }
                catch (Throwable throwable) {
                    validateFileResult.setValidateResult(ValidateResultType.FATAL);
                    string3 = throwable.getMessage() == null ? throwable.getClass().toString() : throwable.getMessage();
                    validateFileResult.setValidateMessage(string3);
                    throwable.printStackTrace();
                    stringBuilder.append(": ").append(throwable.getMessage());
                    bl = true;
                }
            }
            if (bl) {
                validateResponse.setValidateResult(ValidateResultType.APP_EXCEPTION);
            } else if (!bl2) {
                if (bl4) {
                    validateResponse.setValidateResult(ValidateResultType.FATAL);
                } else if (bl3) {
                    validateResponse.setValidateResult(ValidateResultType.ERROR);
                } else if (bl5) {
                    validateResponse.setValidateResult(ValidateResultType.WARNING);
                } else {
                    validateResponse.setValidateResult(ValidateResultType.OK);
                }
            }
            validateResponse.setSummaryMessage(stringBuilder.toString());
            object2 = PathUtil.makePath((String)string, (String)(String.valueOf(validateRequest.getValidateID()) + "_result.xml"));
            Object object10 = null;
            try {
                try {
                    this.a(validateResponse, validateRequest.getMsgFormatType());
                    IOHelper.saveAsFile((byte[])validateResponse.toXml().getBytes(d), (String)object2);
                    validateRequest.getTraceMemo().setValidateResFile(String.valueOf(validateRequest.getValidateID()) + "_result.xml");
                    if (startupParams.isUfmsEnabled()) {
                        validateFileResult = new ResponseContext();
                        object10 = IOUtils.toInputStream((String)validateResponse.toXml(), (String)"UTF-8");
                        string2 = object2;
                        if (string2.startsWith(serverContext.getReportHome())) {
                            string2 = string2.replace(serverContext.getReportHome(), "$SSE_REPORT_HOME");
                        }
                        storageGate.save(string2, (InputStream)object10, (ResponseContext)validateFileResult);
                        String string7 = validateFileResult.responseUploadFile != null ? validateFileResult.responseUploadFile.getId() : "";
                        validateRequest.getTraceMemo().setResultFileId(string7);
                    }
                    LogWatch.info((Object)object2);
                }
                catch (Exception exception) {
                    b.warn("save validate result file:{} fail,{}", object2, (Object)exception.getMessage());
                    if (object10 == null) break block73;
                    try {
                        ((InputStream)object10).close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                if (object10 != null) {
                    try {
                        ((InputStream)object10).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected boolean downloadFileToLocal(StorageGate storage, ValidateRequest vr, ValidateFileInfo vfi) {
        return this.downloadFileToLocal(storage, vr, vfi, null);
    }

    protected boolean downloadFileToLocal(StorageGate storage, ValidateRequest vr, ValidateFileInfo vfi, InputStream in) {
        boolean bl;
        block22: {
            bl = false;
            if (storage == null || vr == null || vfi == null) {
                return bl;
            }
            String string = vfi.getFileId();
            StringBuilder stringBuilder = new StringBuilder();
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                try {
                    String string2 = vfi.getFileName();
                    int n = 0;
                    String string3 = string2 != null && (n = string2.lastIndexOf(".")) > 0 ? string2.substring(n) : "";
                    inputStream = in != null ? in : storage.getInputStream(string2, string, vfi.getFileSize(), vfi.getFileHash(), vfi.getFileAuth(), vr.getSourceSystem());
                    String string4 = PathUtil.makePath((String)"$SSE_REPORT_HOME", (String)"check");
                    string4 = PathUtil.makePath((String)string4, (String)this.getCurrentYear());
                    string4 = PathUtil.makePath((String)string4, (String)vr.getCompanyCode());
                    String string5 = PathUtil.makePath((String)string4, (String)vr.getBulletinID());
                    File file = new File(storage.getAbsolutePath(string5));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    String string6 = PathUtil.makePath((String)string5, (String)(String.valueOf(string) + string3));
                    IOHelper.saveAsFile((InputStream)inputStream, (String)storage.getAbsolutePath(string6));
                    vfi.setFileName(string6);
                    bl = true;
                }
                catch (Exception exception) {
                    b.error("ufms download file is error , fileId:{} ,{}", (Object)string, (Object)exception);
                    stringBuilder.append("\u4ece\u7edf\u4e00\u6587\u4ef6\u7cfb\u7edf\u670d\u52a1\uff08ufms\uff09\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0cfileId: ").append(string).append("; ").append(exception.getMessage());
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (outputStream == null) break block22;
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    private void a(WordProcessContext wordProcessContext, FastByteArrayOutputStream fastByteArrayOutputStream) {
        try {
            ServerContext serverContext = this.getServerContext();
            XbrlInstance xbrlInstance = wordProcessContext.getInstance();
            String string = serverContext.getRunningParams().getTransferXbrlDir();
            if (xbrlInstance != null && !StringUtils.isEmpty((String)string)) {
                String string2 = xbrlInstance.getOwnerDocument().getBaseURI();
                String string3 = StorageGate.makePath((String)string, (String)(string2 = IOHelper.getFileName((String)string2)));
                int n = string3.lastIndexOf(46);
                string3 = n == -1 ? String.valueOf(string3) + ".zip" : String.valueOf(string3.substring(0, n)) + ".zip";
                IOHelper.saveAsFile((InputStream)fastByteArrayOutputStream.getInputStream(), (String)string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Response process(Request request) {
        return this.process((WordRequest)request);
    }

    public boolean callProcedure(String sql, Map<String, Object> params) {
        return false;
    }

    private class a
    implements Callable<WordResponse> {
        Thread a;
        private WordRequest c;

        a(WordRequest wordRequest) {
            this.c = wordRequest;
        }

        public WordResponse a() {
            this.a = Thread.currentThread();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                WordResponse wordResponse = WordValidateProcessor.this.a(this.c);
                return wordResponse;
            }
            finally {
                WordValidateProcessor.this.getServerContext().getOnlineRedo().append(this.c);
                WordValidateProcessor.this.getServerContext().getDbWriteService().save((TraceInfo)this.c);
                stopWatch.split();
                b.info("Single time: [" + Thread.currentThread().getId() + "] " + stopWatch.toSplitString());
            }
        }

        @Override
        public /* synthetic */ Object call() throws Exception {
            return this.a();
        }
    }
}

